/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveInstanceMethod.InheritorUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.InternalUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.JavadocUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.MethodCallUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MoveInstanceMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodProcessor");
    private PsiMethod myMethod;
    private PsiVariable myTargetVariable;
    private PsiClass myTargetClass;
    private final String myNewVisibility;
    private final Map<PsiClass, String> myOldClassParameterNames;

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiVariable getTargetVariable() {
        return this.myTargetVariable;
    }

    public MoveInstanceMethodProcessor(Project project, PsiMethod method, PsiVariable targetVariable, String newVisibility, Map<PsiClass, String> oldClassParameterNames) {
        super(project);
        this.myMethod = method;
        this.myTargetVariable = targetVariable;
        this.myOldClassParameterNames = oldClassParameterNames;
        LOG.assertTrue(this.myTargetVariable instanceof PsiParameter || this.myTargetVariable instanceof PsiField);
        LOG.assertTrue(this.myTargetVariable.getType() instanceof PsiClassType);
        PsiType type = this.myTargetVariable.getType();
        LOG.assertTrue(type instanceof PsiClassType);
        this.myTargetClass = ((PsiClassType)type).resolve();
        this.myNewVisibility = newVisibility;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        MoveInstanceMethodViewDescriptor moveInstanceMethodViewDescriptor = new MoveInstanceMethodViewDescriptor(this.myMethod, this.myTargetVariable, this.myTargetClass);
        if (moveInstanceMethodViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor", "createUsageViewDescriptor"));
        }
        return moveInstanceMethodViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        HashSet members = new HashSet();
        members.add(this.myMethod);
        if (this.myTargetVariable instanceof PsiField) {
            members.add((PsiMember)this.myTargetVariable);
        }
        if (!this.myTargetClass.isInterface()) {
            RefactoringConflictsUtil.analyzeAccessibilityConflicts((Set<PsiMember>)members, this.myTargetClass, (MultiMap<PsiElement, String>)conflicts, this.myNewVisibility);
        } else {
            for (UsageInfo usage : usages) {
                if (!(usage instanceof InheritorUsageInfo)) continue;
                RefactoringConflictsUtil.analyzeAccessibilityConflicts((Set<PsiMember>)members, ((InheritorUsageInfo)usage).getInheritor(), (MultiMap<PsiElement, String>)conflicts, this.myNewVisibility);
            }
        }
        if (this.myTargetVariable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)this.myTargetVariable;
            for (UsageInfo usageInfo : usages) {
                if (!(usageInfo instanceof MethodCallUsageInfo)) continue;
                PsiElement methodCall = ((MethodCallUsageInfo)usageInfo).getMethodCallExpression();
                if (methodCall instanceof PsiMethodCallExpression) {
                    PsiExpression[] expressions = ((PsiMethodCallExpression)methodCall).getArgumentList().getExpressions();
                    int index = this.myMethod.getParameterList().getParameterIndex(parameter);
                    if (index >= expressions.length) continue;
                    PsiExpression instanceValue = expressions[index];
                    if (!((instanceValue = RefactoringUtil.unparenthesizeExpression(instanceValue)) instanceof PsiLiteralExpression) || ((PsiLiteralExpression)instanceValue).getValue() != null) continue;
                    String message = RefactoringBundle.message((String)"0.contains.call.with.null.argument.for.parameter.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(methodCall), true), CommonRefactoringUtil.htmlEmphasize((String)parameter.getName())});
                    conflicts.putValue((Object)instanceValue, (Object)message);
                    continue;
                }
                if (!(methodCall instanceof PsiMethodReferenceExpression)) continue;
                conflicts.putValue((Object)methodCall, (Object)"Method reference would be broken after move");
            }
        }
        try {
            ConflictsUtil.checkMethodConflicts(this.myTargetClass, this.myMethod, this.getPatternMethod(), (MultiMap<PsiElement, String>)conflicts);
        }
        catch (IncorrectOperationException e) {
            // empty catch block
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usages);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiCodeBlock body;
        PsiManager manager = this.myMethod.getManager();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)manager.getProject());
        final ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)searchScope, (boolean)false)) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression) {
                boolean isInternal = PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)element, (boolean)true);
                usages.add(new MethodCallUsageInfo((PsiReferenceExpression)element, isInternal));
                continue;
            }
            if (element instanceof PsiDocTagValue) {
                usages.add(new JavadocUsageInfo((PsiDocTagValue)element));
                continue;
            }
            throw new BaseRefactoringProcessor.UnknownReferenceTypeException(element.getLanguage());
        }
        if (this.myTargetClass.isInterface()) {
            MoveInstanceMethodProcessor.addInheritorUsages(this.myTargetClass, searchScope, usages);
        }
        if ((body = this.myMethod.getBody()) != null) {
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitNewExpression(PsiNewExpression expression) {
                    if (MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression) != null) {
                        usages.add(new InternalUsageInfo((PsiElement)expression));
                    }
                    super.visitNewExpression(expression);
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    if (MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression) != null) {
                        usages.add(new InternalUsageInfo((PsiElement)expression));
                    } else if (!expression.isQualified()) {
                        PsiElement resolved = expression.resolve();
                        if (MoveInstanceMethodProcessor.this.myTargetVariable.equals(resolved)) {
                            usages.add(new InternalUsageInfo((PsiElement)expression));
                        }
                    }
                    super.visitReferenceExpression(expression);
                }
            });
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private static void addInheritorUsages(PsiClass aClass, GlobalSearchScope searchScope, List<UsageInfo> usages) {
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)searchScope, (boolean)false).findAll()) {
            if (!inheritor.isInterface()) {
                usages.add(new InheritorUsageInfo(inheritor));
                continue;
            }
            MoveInstanceMethodProcessor.addInheritorUsages(inheritor, searchScope, usages);
        }
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length == 3);
        this.myMethod = (PsiMethod)elements[0];
        this.myTargetVariable = (PsiVariable)elements[1];
        this.myTargetClass = (PsiClass)elements[2];
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.instance.method.command");
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)this.myTargetClass)) {
            return;
        }
        PsiMethod patternMethod = this.createMethodToAdd();
        ArrayList<PsiReference> docRefs = new ArrayList<PsiReference>();
        for (UsageInfo usage : usages) {
            if (usage instanceof InheritorUsageInfo) {
                PsiClass inheritor = ((InheritorUsageInfo)usage).getInheritor();
                MoveInstanceMethodProcessor.addMethodToClass(inheritor, patternMethod, true);
                continue;
            }
            if (usage instanceof MethodCallUsageInfo && !((MethodCallUsageInfo)usage).isInternal()) {
                PsiElement expression = ((MethodCallUsageInfo)usage).getMethodCallExpression();
                if (expression instanceof PsiMethodCallExpression) {
                    this.correctMethodCall((PsiMethodCallExpression)expression, false);
                    continue;
                }
                if (!(expression instanceof PsiMethodReferenceExpression)) continue;
                PsiExpression newQualifier = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createExpressionFromText(this.myTargetVariable.getType().getCanonicalText(), null);
                ((PsiMethodReferenceExpression)expression).setQualifierExpression(newQualifier);
                continue;
            }
            if (!(usage instanceof JavadocUsageInfo)) continue;
            docRefs.add(usage.getElement().getReference());
        }
        try {
            if (this.myTargetClass.isInterface()) {
                patternMethod.getBody().delete();
            }
            PsiMethod method = MoveInstanceMethodProcessor.addMethodToClass(this.myTargetClass, patternMethod, false);
            this.myMethod.delete();
            for (PsiReference reference : docRefs) {
                reference.bindToElement((PsiElement)method);
            }
            VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements(usages), (PsiMember)method, (String)this.myNewVisibility);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void correctMethodCall(PsiMethodCallExpression expression, boolean isInternalCall) {
        try {
            PsiClass resolved;
            PsiType type;
            PsiManager manager = this.myMethod.getManager();
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            if (!methodExpression.isReferenceTo((PsiElement)this.myMethod)) {
                return;
            }
            PsiExpression oldQualifier = methodExpression.getQualifierExpression();
            PsiExpression newQualifier = null;
            PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)methodExpression);
            if (this.myTargetVariable instanceof PsiParameter) {
                PsiExpression[] arguments;
                int index = this.myMethod.getParameterList().getParameterIndex((PsiParameter)this.myTargetVariable);
                if (index < (arguments = expression.getArgumentList().getExpressions()).length) {
                    newQualifier = (PsiExpression)arguments[index].copy();
                    arguments[index].delete();
                }
            } else {
                PsiClass aClass;
                VisibilityUtil.escalateVisibility((PsiMember)((PsiField)this.myTargetVariable), (PsiElement)expression);
                String newQualifierName = this.myTargetVariable.getName();
                if (this.myTargetVariable instanceof PsiField && oldQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)oldQualifier.getType())) == ((PsiField)this.myTargetVariable).getContainingClass()) {
                    newQualifierName = oldQualifier.getText() + "." + newQualifierName;
                }
                newQualifier = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText(newQualifierName, null);
            }
            PsiExpression newArgument = null;
            if (classReferencedByThis != null) {
                String thisArgumentText = null;
                if (manager.areElementsEquivalent((PsiElement)this.myMethod.getContainingClass(), (PsiElement)classReferencedByThis)) {
                    if (this.myOldClassParameterNames.containsKey(this.myMethod.getContainingClass())) {
                        thisArgumentText = "this";
                    }
                } else {
                    thisArgumentText = classReferencedByThis.getName() + ".this";
                }
                if (thisArgumentText != null) {
                    newArgument = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText(thisArgumentText, null);
                }
            } else if (!isInternalCall && oldQualifier != null && (type = oldQualifier.getType()) instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null && this.getParameterNameToCreate(resolved) != null) {
                newArgument = this.replaceRefsToTargetVariable(oldQualifier);
            }
            if (newArgument != null) {
                expression.getArgumentList().add(newArgument);
            }
            if (newQualifier != null) {
                if (newQualifier instanceof PsiThisExpression && ((PsiThisExpression)newQualifier).getQualifier() == null) {
                    if (oldQualifier != null) {
                        oldQualifier.delete();
                    }
                } else {
                    PsiReferenceExpression refExpr = (PsiReferenceExpression)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText("q." + this.myMethod.getName(), null);
                    refExpr.getQualifierExpression().replace((PsiElement)newQualifier);
                    methodExpression.replace((PsiElement)refExpr);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiExpression replaceRefsToTargetVariable(PsiExpression expression) {
        final PsiManager manager = expression.getManager();
        if (expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).isReferenceTo((PsiElement)this.myTargetVariable)) {
            return MoveInstanceMethodProcessor.createThisExpr(manager);
        }
        expression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (expression.isReferenceTo((PsiElement)MoveInstanceMethodProcessor.this.myTargetVariable)) {
                    try {
                        expression.replace((PsiElement)MoveInstanceMethodProcessor.createThisExpr(manager));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        return expression;
    }

    private static PsiExpression createThisExpr(PsiManager manager) {
        try {
            return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText("this", null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiMethod addMethodToClass(PsiClass aClass, PsiMethod patternMethod, boolean canAddOverride) {
        try {
            PsiMethod method = (PsiMethod)aClass.add((PsiElement)patternMethod);
            ChangeContextUtil.decodeContextInfo((PsiElement)method, null, null);
            if (canAddOverride && OverrideImplementUtil.isInsertOverride(method, aClass)) {
                method.getModifierList().addAnnotation("java.lang.Override");
            }
            return method;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiMethod createMethodToAdd() {
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, true);
        try {
            final PsiManager manager = this.myMethod.getManager();
            final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiCodeBlock body = this.myMethod.getBody();
            if (body != null) {
                final HashMap replaceMap = new HashMap();
                body.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitThisExpression(PsiThisExpression expression) {
                        PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression);
                        if (classReferencedByThis != null && !PsiTreeUtil.isAncestor((PsiElement)MoveInstanceMethodProcessor.this.myMethod, (PsiElement)classReferencedByThis, (boolean)false)) {
                            PsiElementFactory factory2 = JavaPsiFacade.getInstance((Project)MoveInstanceMethodProcessor.this.myProject).getElementFactory();
                            String paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis);
                            try {
                                PsiExpression refExpression = factory2.createExpressionFromText(paramName, null);
                                replaceMap.put(expression, refExpression);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        try {
                            String paramName;
                            PsiClass classReferencedByThis;
                            PsiExpression qualifier = expression.getQualifierExpression();
                            PsiElement resolved = expression.resolve();
                            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)MoveInstanceMethodProcessor.this.myTargetVariable)) {
                                if (resolved instanceof PsiField) {
                                    for (PsiParameter parameter : MoveInstanceMethodProcessor.this.myMethod.getParameterList().getParameters()) {
                                        if (!Comparing.strEqual((String)parameter.getName(), (String)((PsiField)resolved).getName())) continue;
                                        qualifier.replace((PsiElement)factory.createExpressionFromText("this", null));
                                        return;
                                    }
                                }
                                qualifier.delete();
                                return;
                            }
                            if (MoveInstanceMethodProcessor.this.myTargetVariable.equals(resolved)) {
                                PsiThisExpression thisExpression = RefactoringChangeUtil.createThisExpression(manager, PsiTreeUtil.isAncestor((PsiElement)MoveInstanceMethodProcessor.this.myMethod, (PsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class), (boolean)true) ? MoveInstanceMethodProcessor.this.myTargetClass : null);
                                replaceMap.put(expression, thisExpression);
                                return;
                            }
                            if (!MoveInstanceMethodProcessor.this.myMethod.equals(resolved) && (classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression)) != null && (paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis)) != null) {
                                PsiReferenceExpression newQualifier = (PsiReferenceExpression)factory.createExpressionFromText(paramName, null);
                                expression.setQualifierExpression((PsiExpression)newQualifier);
                                return;
                            }
                            super.visitReferenceExpression(expression);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }

                    public void visitNewExpression(PsiNewExpression expression) {
                        try {
                            PsiExpression qualifier = expression.getQualifier();
                            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)MoveInstanceMethodProcessor.this.myTargetVariable)) {
                                qualifier.delete();
                            } else {
                                PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression);
                                if (classReferencedByThis != null) {
                                    if (qualifier != null) {
                                        qualifier.delete();
                                    }
                                    String paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis);
                                    PsiExpression newExpression = factory.createExpressionFromText(paramName + "." + expression.getText(), null);
                                    replaceMap.put(expression, newExpression);
                                }
                            }
                            super.visitNewExpression(expression);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }

                    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                        MoveInstanceMethodProcessor.this.correctMethodCall(expression, true);
                        super.visitMethodCallExpression(expression);
                    }
                });
                for (PsiElement element : replaceMap.keySet()) {
                    PsiElement replacement = (PsiElement)replaceMap.get(element);
                    element.replace(replacement);
                }
            }
            PsiMethod methodCopy = this.getPatternMethod();
            List<PsiParameter> newParameters = Arrays.asList(methodCopy.getParameterList().getParameters());
            RefactoringUtil.fixJavadocsForParams(methodCopy, (Set<PsiParameter>)new HashSet(newParameters));
            return methodCopy;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return this.myMethod;
        }
    }

    private PsiMethod getPatternMethod() throws IncorrectOperationException {
        String name;
        PsiMethod methodCopy = (PsiMethod)this.myMethod.copy();
        String string = this.myTargetClass.isInterface() ? "public" : (name = !Comparing.strEqual((String)this.myNewVisibility, (String)"EscalateVisible") ? this.myNewVisibility : null);
        if (name != null) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)methodCopy, (String)name, (boolean)true);
        }
        if (this.myTargetVariable instanceof PsiParameter) {
            int index = this.myMethod.getParameterList().getParameterIndex((PsiParameter)this.myTargetVariable);
            methodCopy.getParameterList().getParameters()[index].delete();
        }
        this.addParameters(JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory(), methodCopy, this.myTargetClass.isInterface());
        return methodCopy;
    }

    private void addParameters(PsiElementFactory factory, PsiMethod methodCopy, boolean isInterface) throws IncorrectOperationException {
        Set<Map.Entry<PsiClass, String>> entries = this.myOldClassParameterNames.entrySet();
        for (Map.Entry<PsiClass, String> entry : entries) {
            PsiClassType type = factory.createType(entry.getKey());
            PsiParameter parameter = factory.createParameter(entry.getValue(), (PsiType)type);
            if (isInterface) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)false);
            }
            methodCopy.getParameterList().add((PsiElement)parameter);
        }
    }

    private String getParameterNameToCreate(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor", "getParameterNameToCreate"));
        }
        return this.myOldClassParameterNames.get(aClass);
    }
}

