/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RelatedUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameProcessor");
    protected final LinkedHashMap<PsiElement, String> myAllRenames;
    private PsiElement myPrimaryElement;
    private String myNewName;
    private boolean mySearchInComments;
    private boolean mySearchTextOccurrences;
    protected boolean myForceShowPreview;
    private String myCommandName;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final List<AutomaticRenamerFactory> myRenamerFactories;
    private final List<AutomaticRenamer> myRenamers;
    private final List<UnresolvableCollisionUsageInfo> mySkippedUsages;

    public RenameProcessor(Project project, PsiElement element, @NotNull @NonNls String newName, boolean isSearchInComments, boolean isSearchTextOccurrences) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/RenameProcessor", "<init>"));
        }
        super(project);
        this.myAllRenames = new LinkedHashMap();
        this.myNewName = null;
        this.myNonCodeUsages = new NonCodeUsageInfo[0];
        this.myRenamerFactories = new ArrayList<AutomaticRenamerFactory>();
        this.myRenamers = new ArrayList<AutomaticRenamer>();
        this.mySkippedUsages = new ArrayList<UnresolvableCollisionUsageInfo>();
        this.myPrimaryElement = element;
        RenameProcessor.assertNonCompileElement(element);
        this.mySearchInComments = isSearchInComments;
        this.mySearchTextOccurrences = isSearchTextOccurrences;
        this.setNewName(newName);
    }

    @Deprecated
    public RenameProcessor(Project project) {
        this(project, null, "", false, false);
    }

    public Set<PsiElement> getElements() {
        return Collections.unmodifiableSet(this.myAllRenames.keySet());
    }

    public String getNewName(PsiElement element) {
        return this.myAllRenames.get(element);
    }

    public void addRenamerFactory(AutomaticRenamerFactory factory) {
        if (!this.myRenamerFactories.contains(factory)) {
            this.myRenamerFactories.add(factory);
        }
    }

    public void removeRenamerFactory(AutomaticRenamerFactory factory) {
        this.myRenamerFactories.remove(factory);
    }

    @Override
    public void doRun() {
        this.prepareRenaming(this.myPrimaryElement, this.myNewName, this.myAllRenames);
        super.doRun();
    }

    public void prepareRenaming(@NotNull PsiElement element, String newName, LinkedHashMap<PsiElement, String> allRenames) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenameProcessor", "prepareRenaming"));
        }
        List<RenamePsiElementProcessor> processors = RenamePsiElementProcessor.allForElement(element);
        this.myForceShowPreview = false;
        for (RenamePsiElementProcessor processor : processors) {
            if (!processor.canProcessElement(element)) continue;
            processor.prepareRenaming(element, newName, allRenames);
            this.myForceShowPreview |= processor.forcesShowPreview();
        }
    }

    @Nullable
    private String getHelpID() {
        return RenamePsiElementProcessor.forElement(this.myPrimaryElement).getHelpID(this.myPrimaryElement);
    }

    @Override
    public boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        Object[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap<PsiElement, String>)conflicts);
        RenamePsiElementProcessor.forElement(this.myPrimaryElement).findExistingNameConflicts(this.myPrimaryElement, this.myNewName, (MultiMap<PsiElement, String>)conflicts, this.myAllRenames);
        if (!conflicts.isEmpty()) {
            RefactoringEventData conflictData = new RefactoringEventData();
            conflictData.putUserData(RefactoringEventData.CONFLICTS_KEY, (Object)conflicts.values());
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected("refactoring.rename", conflictData);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = this.prepareConflictsDialog((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
            conflictsDialog.show();
            if (!conflictsDialog.isOK()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        final ArrayList<UsageInfo> variableUsages = new ArrayList<UsageInfo>();
        if (!this.myRenamers.isEmpty()) {
            if (!this.findRenamedVariables(variableUsages)) {
                return false;
            }
            final LinkedHashMap<PsiElement, String> renames = new LinkedHashMap<PsiElement, String>();
            for (AutomaticRenamer renamer : this.myRenamers) {
                List<PsiNamedElement> variables = renamer.getElements();
                for (PsiNamedElement variable : variables) {
                    String newName = renamer.getNewName(variable);
                    if (newName == null) continue;
                    this.addElement((PsiElement)variable, newName);
                    this.prepareRenaming((PsiElement)variable, newName, renames);
                }
            }
            if (!renames.isEmpty()) {
                for (PsiElement element : renames.keySet()) {
                    RenameProcessor.assertNonCompileElement(element);
                }
                this.myAllRenames.putAll(renames);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (final Map.Entry entry : renames.entrySet()) {
                            UsageInfo[] usages = (UsageInfo[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<UsageInfo[]>(){

                                public UsageInfo[] compute() {
                                    return RenameUtil.findUsages((PsiElement)entry.getKey(), (String)entry.getValue(), RenameProcessor.this.mySearchInComments, RenameProcessor.this.mySearchTextOccurrences, RenameProcessor.this.myAllRenames);
                                }
                            });
                            Collections.addAll(variableUsages, usages);
                        }
                    }
                };
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) {
                    return false;
                }
            }
        }
        LinkedHashSet usagesSet = ContainerUtil.newLinkedHashSet((Object[])usagesIn);
        usagesSet.addAll(variableUsages);
        List<UnresolvableCollisionUsageInfo> conflictUsages = RenameUtil.removeConflictUsages(usagesSet);
        if (conflictUsages != null) {
            this.mySkippedUsages.addAll(conflictUsages);
        }
        refUsages.set((Object)usagesSet.toArray(new UsageInfo[usagesSet.size()]));
        this.prepareSuccessful();
        return PsiElementRenameHandler.canRename(this.myProject, null, this.myPrimaryElement);
    }

    public static void assertNonCompileElement(PsiElement element) {
        LOG.assertTrue(!(element instanceof PsiCompiledElement), (Object)element);
    }

    private void assertValidName(PsiElement element, String newName) {
        LOG.assertTrue(RenameUtil.isValidName(this.myProject, element, newName), (Object)("element: " + element + ", newName: " + newName));
    }

    private boolean findRenamedVariables(final List<UsageInfo> variableUsages) {
        for (AutomaticRenamer automaticVariableRenamer : this.myRenamers) {
            if (!automaticVariableRenamer.hasAnythingToRename() || this.showAutomaticRenamingDialog(automaticVariableRenamer)) continue;
            return false;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        for (AutomaticRenamer renamer : RenameProcessor.this.myRenamers) {
                            renamer.findUsages(variableUsages, RenameProcessor.this.mySearchInComments, RenameProcessor.this.mySearchTextOccurrences, RenameProcessor.this.mySkippedUsages, RenameProcessor.this.myAllRenames);
                        }
                    }
                });
            }
        };
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject);
    }

    protected boolean showAutomaticRenamingDialog(AutomaticRenamer automaticVariableRenamer) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiNamedElement element : automaticVariableRenamer.getElements()) {
                automaticVariableRenamer.setRename(element, automaticVariableRenamer.getNewName(element));
            }
            return true;
        }
        AutomaticRenamingDialog dialog = new AutomaticRenamingDialog(this.myProject, automaticVariableRenamer);
        dialog.show();
        return dialog.isOK();
    }

    public void addElement(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenameProcessor", "addElement"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/RenameProcessor", "addElement"));
        }
        RenameProcessor.assertNonCompileElement(element);
        this.myAllRenames.put(element, newName);
    }

    private void setNewName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/RenameProcessor", "setNewName"));
        }
        if (this.myPrimaryElement == null) {
            this.myCommandName = RefactoringBundle.message((String)"renaming.something");
            return;
        }
        this.myNewName = newName;
        this.myAllRenames.put(this.myPrimaryElement, newName);
        this.myCommandName = RefactoringBundle.message((String)"renaming.0.1.to.2", (Object[])new Object[]{UsageViewUtil.getType(this.myPrimaryElement), DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPrimaryElement), newName});
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        RenameViewDescriptor renameViewDescriptor = new RenameViewDescriptor(this.myAllRenames);
        if (renameViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenameProcessor", "createUsageViewDescriptor"));
        }
        return renameViewDescriptor;
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        this.myRenamers.clear();
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>(this.myAllRenames.keySet());
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = (PsiElement)elements.get(i);
            String newName = this.myAllRenames.get(element);
            UsageInfo[] usages = RenameUtil.findUsages(element, newName, this.mySearchInComments, this.mySearchTextOccurrences, this.myAllRenames);
            List<UsageInfo> usagesList = Arrays.asList(usages);
            result.addAll(usagesList);
            for (AutomaticRenamerFactory factory : this.myRenamerFactories) {
                if (!factory.isApplicable(element)) continue;
                this.myRenamers.add(factory.createRenamer(element, newName, usagesList));
            }
            for (AutomaticRenamerFactory factory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
                if (factory.getOptionName() != null || !factory.isApplicable(element)) continue;
                this.myRenamers.add(factory.createRenamer(element, newName, usagesList));
            }
        }
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        if ((usageInfos = UsageViewUtil.removeDuplicatedUsages(usageInfos)) == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenameProcessor", "findUsages"));
        }
        return usageInfos;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length > 0);
        if (this.myPrimaryElement != null) {
            this.myPrimaryElement = elements[0];
        }
        Iterator<String> newNames = this.myAllRenames.values().iterator();
        LinkedHashMap<PsiElement, String> newAllRenames = new LinkedHashMap<PsiElement, String>();
        for (PsiElement resolved : elements) {
            newAllRenames.put(resolved, newNames.next());
        }
        this.myAllRenames.clear();
        this.myAllRenames.putAll(newAllRenames);
    }

    @Override
    protected boolean isPreviewUsages(UsageInfo[] usages) {
        if (this.myForceShowPreview) {
            return true;
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        return UsageViewUtil.reportNonRegularUsages(usages, this.myProject);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.rename";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myPrimaryElement);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo[] usages) {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myPrimaryElement);
        return data;
    }

    @Override
    public void performRefactoring(UsageInfo[] usages) {
        int[] nArray;
        if (this.myAllRenames.size() > 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = null;
        }
        int[] choice = nArray;
        String message = null;
        try {
            Iterator<Map.Entry<PsiElement, String>> iterator = this.myAllRenames.entrySet().iterator();
            while (iterator.hasNext()) {
                PsiFile file;
                PsiDirectory containingDirectory;
                Map.Entry<PsiElement, String> entry = iterator.next();
                if (entry.getKey() instanceof PsiFile && CopyFilesOrDirectoriesHandler.checkFileExist(containingDirectory = (file = (PsiFile)entry.getKey()).getContainingDirectory(), choice, file, entry.getValue(), "Rename")) {
                    iterator.remove();
                    continue;
                }
                RenameUtil.checkRename(entry.getKey(), entry.getValue());
            }
        }
        catch (IncorrectOperationException e) {
            message = e.getMessage();
        }
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"rename.title"), (String)message, (String)this.getHelpID(), (Project)this.myProject);
            return;
        }
        ArrayList<Runnable> postRenameCallbacks = new ArrayList<Runnable>();
        MultiMap<PsiElement, UsageInfo> classified = RenameProcessor.classifyUsages(this.myAllRenames.keySet(), usages);
        for (PsiElement element : this.myAllRenames.keySet()) {
            String newName = this.myAllRenames.get(element);
            RefactoringElementListener elementListener = this.getTransaction().getElementListener(element);
            RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement(element);
            Runnable postRenameCallback = renamePsiElementProcessor.getPostRenameCallback(element, newName, elementListener);
            Collection infos = classified.get((Object)element);
            try {
                RenameUtil.doRename(element, newName, infos.toArray(new UsageInfo[infos.size()]), this.myProject, elementListener);
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage(e, element, this.myProject);
                return;
            }
            if (postRenameCallback == null) continue;
            postRenameCallbacks.add(postRenameCallback);
        }
        for (Runnable runnable : postRenameCallbacks) {
            runnable.run();
        }
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            nonCodeUsages.add((NonCodeUsageInfo)usage);
        }
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
        if (!(this.mySkippedUsages.isEmpty() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(RenameProcessor.this.myProject);
                    if (ideFrame != null) {
                        StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                        HyperlinkListener listener = new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                                    return;
                                }
                                Messages.showMessageDialog((String)("<html>Following usages were safely skipped:<br>" + StringUtil.join((Collection)RenameProcessor.this.mySkippedUsages, (Function)new Function<UnresolvableCollisionUsageInfo, String>(){

                                    public String fun(UnresolvableCollisionUsageInfo unresolvableCollisionUsageInfo) {
                                        return unresolvableCollisionUsageInfo.getDescription();
                                    }
                                }, (String)"<br>") + "</html>"), (String)"Not All Usages Were Renamed", null);
                            }
                        };
                        statusBar.notifyProgressByBalloon(MessageType.WARNING, "<html><body>Unable to rename certain usages. <a href=\"\">Browse</a></body></html>", null, listener);
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
    }

    @Override
    protected String getCommandName() {
        return this.myCommandName;
    }

    public static MultiMap<PsiElement, UsageInfo> classifyUsages(Collection<? extends PsiElement> elements, UsageInfo[] usages) {
        MultiMap result = new MultiMap();
        for (UsageInfo usage : usages) {
            PsiElement indirect;
            LOG.assertTrue(usage instanceof MoveRenameUsageInfo);
            if (usage.getReference() instanceof LightElement) continue;
            MoveRenameUsageInfo usageInfo = (MoveRenameUsageInfo)usage;
            if (usage instanceof RelatedUsageInfo) {
                PsiElement relatedElement = ((RelatedUsageInfo)usage).getRelatedElement();
                if (!elements.contains(relatedElement)) continue;
                result.putValue((Object)relatedElement, (Object)usage);
                continue;
            }
            PsiElement referenced = usageInfo.getReferencedElement();
            if (elements.contains(referenced)) {
                result.putValue((Object)referenced, (Object)usage);
                continue;
            }
            if (referenced == null || !elements.contains(indirect = referenced.getNavigationElement())) continue;
            result.putValue((Object)indirect, (Object)usage);
        }
        return result;
    }

    public Collection<String> getNewNames() {
        return this.myAllRenames.values();
    }

    public void setSearchInComments(boolean value) {
        this.mySearchInComments = value;
    }

    public void setSearchTextOccurrences(boolean searchTextOccurrences) {
        this.mySearchTextOccurrences = searchTextOccurrences;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchTextOccurrences() {
        return this.mySearchTextOccurrences;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }
}

