/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiStatement;
import com.intellij.refactoring.safeDelete.ImportSearcher;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;

public class SafeDeleteReferenceJavaDeleteUsageInfo
extends SafeDeleteReferenceSimpleDeleteUsageInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo");

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiElement element, PsiElement referencedElement, boolean isSafeDelete) {
        super(element, referencedElement, isSafeDelete);
    }

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiElement element, PsiElement referencedElement, int startOffset, int endOffset, boolean isNonCodeUsage, boolean isSafeDelete) {
        super(element, referencedElement, startOffset, endOffset, isNonCodeUsage, isSafeDelete);
    }

    @Override
    public void deleteElement() throws IncorrectOperationException {
        if (this.isSafeDelete()) {
            PsiElement element = this.getElement();
            LOG.assertTrue(element != null);
            PsiElement importStatement = ImportSearcher.getImport(element, false);
            if (importStatement != null) {
                if (element instanceof PsiImportStaticReferenceElement && ((PsiImportStaticReferenceElement)element).multiResolve(false).length < 2) {
                    importStatement.delete();
                }
            } else if (element instanceof PsiExpressionStatement && RefactoringUtil.isLoopOrIf(element.getParent())) {
                PsiStatement emptyTest = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createStatementFromText(";", null);
                element.replace((PsiElement)emptyTest);
            } else {
                element.delete();
            }
        }
    }
}

