/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CompositeException;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexedRootsProvider;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformTestCase
extends UsefulTestCase
implements DataProvider {
    public static final String TEST_DIR_PREFIX = "idea_test_";
    protected static IdeaTestApplication ourApplication;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected static final Collection<File> myFilesToDelete;
    protected boolean myAssertionsInTestDetected;
    protected static final Logger LOG;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    public static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    protected static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private static final String[] PREFIX_CANDIDATES;
    private static int LEAK_WALKS;

    protected static long getTimeRequired() {
        return 300L;
    }

    @Nullable
    protected String getApplicationConfigDirPath() throws Exception {
        return null;
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourApplication == null;
        PlatformTestCase.autodetectPlatformPrefix();
        ourApplication = IdeaTestApplication.getInstance(this.getApplicationConfigDirPath());
        ourApplication.setDataProvider(this);
        if (firstTime) {
            PlatformTestCase.cleanPersistedVFSContent();
        }
    }

    public static void autodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        URL resource = PlatformTestCase.class.getClassLoader().getResource("idea/ApplicationInfo.xml");
        if (resource == null) {
            for (String candidate : PREFIX_CANDIDATES) {
                resource = PlatformTestCase.class.getClassLoader().getResource("META-INF/" + candidate + "Plugin.xml");
                if (resource == null) continue;
                PlatformTestCase.setPlatformPrefix(candidate);
                break;
            }
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    @Override
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getSettings((Project)this.getProject());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            PlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.info(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        this.setUpProject();
        this.storeSettings();
        ourTestCase = this;
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            CodeStyleSettingsManager.getInstance((Project)this.myProject).setTemporarySettings(new CodeStyleSettings());
            InjectedLanguageManagerImpl.pushInjectors(this.getProject());
        }
        DocumentCommitThread.getInstance().clearQueue();
        UIUtil.dispatchAllInvocationEvents();
    }

    public Project getProject() {
        return this.myProject;
    }

    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        PlatformTestCase.assertNotNull((String)"Cannot instantiate ProjectManager component", (Object)((Object)this.myProjectManager));
        File projectFile = this.getIprFile();
        this.myProject = this.doCreateProject(projectFile);
        this.myProjectManager.openTestProject(this.myProject);
        LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        this.setUpModule();
        this.setUpJdk();
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        this.runStartupActivities();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected Project doCreateProject(File projectFile) throws Exception {
        return PlatformTestCase.createProject(projectFile, ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }

    @NotNull
    public static Project createProject(File projectFile, String creationPlace) {
        Project project;
        try {
            Project project2 = ProjectManagerEx.getInstanceEx().newProject(FileUtil.getNameWithoutExtension((File)projectFile), projectFile.getPath(), false, false);
            assert (project2 != null);
            project2.putUserData(CREATION_PLACE, (Object)creationPlace);
            project = project2;
        }
        catch (TooManyProjectLeakedException e) {
            StringBuilder leakers = new StringBuilder();
            leakers.append("Too many projects leaked: \n");
            for (Project project3 : e.getLeakedProjects()) {
                String presentableString = PlatformTestCase.getCreationPlace(project3);
                leakers.append(presentableString);
                leakers.append("\n");
            }
            PlatformTestCase.fail((String)leakers.toString());
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "createProject"));
            }
            return null;
        }
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "createProject"));
        }
        return project;
    }

    @NotNull
    public static String getCreationPlace(@NotNull Project project) {
        String base;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/PlatformTestCase", "getCreationPlace"));
        }
        String place = (String)project.getUserData(CREATION_PLACE);
        try {
            base = project.isDisposed() ? "" : project.getBaseDir();
        }
        catch (Exception e) {
            base = " (" + e + " while getting base dir)";
        }
        String string = project + (place != null ? place : "") + base;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "getCreationPlace"));
        }
        return string;
    }

    protected void runStartupActivities() {
        StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        startupManager.runStartupActivities();
        startupManager.startCacheUpdate();
        startupManager.runPostStartupActivities();
    }

    protected File getIprFile() throws IOException {
        File tempFile = FileUtil.createTempFile((String)(this.getName() + "_"), (String)".ipr");
        myFilesToDelete.add(tempFile);
        return tempFile;
    }

    protected void setUpModule() {
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                PlatformTestCase.this.myModule = PlatformTestCase.this.createMainModule();
            }
        }.execute().throwException();
    }

    protected Module createMainModule() throws IOException {
        return this.createModule(this.myProject.getName());
    }

    protected Module createModule(@NonNls String moduleName) {
        return this.doCreateRealModule(moduleName);
    }

    protected Module doCreateRealModule(String moduleName) {
        return PlatformTestCase.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
    }

    protected static Module doCreateRealModuleIn(String moduleName, final Project project, final ModuleType moduleType) {
        VirtualFile baseDir = project.getBaseDir();
        PlatformTestCase.assertNotNull((Object)baseDir);
        final File moduleFile = new File(FileUtil.toSystemDependentName((String)baseDir.getPath()), moduleName + ".iml");
        FileUtil.createIfDoesntExist((File)moduleFile);
        myFilesToDelete.add(moduleFile);
        return (Module)new WriteAction<Module>(){

            protected void run(@NotNull Result<Module> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$2", "run"));
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
                TestCase.assertNotNull((Object)virtualFile);
                Module module = ModuleManager.getInstance((Project)project).newModule(virtualFile.getPath(), moduleType.getId());
                module.getModuleFile();
                result.setResult((Object)module);
            }
        }.execute().getResultObject();
    }

    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(Project project) {
        LocalFileSystemImpl localFileSystem;
        ProjectManagerImpl projectManager;
        if (project != null && !project.isDisposed()) {
            UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
            if (globalInstance != null) {
                globalInstance.dropHistoryInTests();
            }
            ((UndoManagerImpl)UndoManager.getInstance((Project)project)).dropHistoryInTests();
            ((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager().cleanupForNextTest();
        }
        if ((projectManager = (ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerEx)PsiManager.getInstance((Project)defaultProject)).getFileManager().cleanupForNextTest();
        }
        if ((localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance()) != null) {
            localFileSystem.cleanupForNextTest();
        }
        LocalHistoryImpl.getInstanceImpl().cleanupForNextTest();
    }

    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            return ourEternallyLivingFilesCache;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexedRootsProvider provider : (IndexedRootsProvider[])IndexedRootsProvider.EP_NAME.getExtensions()) {
            for (VirtualFile file : IndexableSetContributor.getRootsToIndex(provider)) {
                PlatformTestCase.registerSurvivor(survivors, file);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        return survivors;
    }

    public static void addSurvivingFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/testFramework/PlatformTestCase", "addSurvivingFiles"));
        }
        for (VirtualFile each : files) {
            PlatformTestCase.registerSurvivor(PlatformTestCase.eternallyLivingFiles(), each);
        }
    }

    private static void registerSurvivor(Set<VirtualFile> survivors, VirtualFile file) {
        PlatformTestCase.addSubTree(file, survivors);
        while (file != null && survivors.add(file)) {
            file = file.getParent();
        }
    }

    private static void addSubTree(VirtualFile root, Set<VirtualFile> to) {
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add(child);
                PlatformTestCase.addSubTree(child, to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        CompositeException result = new CompositeException(new Throwable[0]);
        if (this.myProject != null) {
            try {
                LightPlatformTestCase.doTearDown(this.getProject(), ourApplication, false);
            }
            catch (Throwable e) {
                result.add(e);
            }
        }
        try {
            CompositeException damage = this.checkForSettingsDamage();
            result.add(damage);
        }
        catch (Throwable e) {
            result.add(e);
        }
        try {
            Project project = this.getProject();
            this.disposeProject(result);
            if (project != null) {
                try {
                    InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project);
                }
                catch (AssertionError e) {
                    result.add((Throwable)((Object)e));
                }
            }
            try {
                for (File fileToDelete : myFilesToDelete) {
                    this.delete(fileToDelete);
                }
                LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
            }
            catch (Throwable e) {
                result.add(e);
            }
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                result.add(IdeaLogger.ourErrorsOccurred);
            }
            try {
                super.tearDown();
            }
            catch (Throwable e) {
                result.add(e);
            }
            try {
                this.myEditorListenerTracker.checkListenersLeak();
            }
            catch (AssertionError error) {
                result.add((Throwable)((Object)error));
            }
            try {
                this.myThreadTracker.checkLeak();
            }
            catch (AssertionError error) {
                result.add((Throwable)((Object)error));
            }
            try {
                LightPlatformTestCase.checkEditorsReleased();
            }
            catch (Throwable error) {
                result.add(error);
            }
        }
        finally {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        }
        if (!result.isEmpty()) {
            throw result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeProject(@NotNull CompositeException result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase", "disposeProject"));
        }
        try {
            DocumentCommitThread.getInstance().clearQueue();
            if (SwingUtilities.isEventDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
        }
        catch (Exception e) {
            result.add(e);
        }
        try {
            if (this.myProject != null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Collection<Project> projectsStillOpen;
                        Disposer.dispose((Disposable)PlatformTestCase.this.myProject);
                        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
                        if (projectManager instanceof ProjectManagerImpl && !(projectsStillOpen = projectManager.closeTestProject(PlatformTestCase.this.myProject)).isEmpty()) {
                            Project project = projectsStillOpen.iterator().next();
                            projectsStillOpen.clear();
                            throw new AssertionError((Object)("Test project is not disposed: " + project + ";\n created in: " + PlatformTestCase.getCreationPlace(project)));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            result.add(e);
        }
        finally {
            if (this.myProject != null) {
                try {
                    PsiDocumentManager documentManager = (PsiDocumentManager)this.myProject.getComponent(PsiDocumentManager.class, null);
                    if (documentManager != null) {
                        EditorFactory.getInstance().getEventMulticaster().removeDocumentListener((DocumentListener)documentManager);
                    }
                }
                catch (Exception exception) {}
                this.myProject = null;
            }
        }
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    protected final <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            PlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == PlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private String getFullName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    private void delete(File file) {
        boolean b = FileUtil.delete((File)file);
        if (!b && file.exists() && !this.myAssertionsInTestDetected) {
            PlatformTestCase.fail((String)("Can't delete " + file.getAbsolutePath() + " in " + this.getFullName()));
        }
    }

    protected void simulateProjectOpen() {
        ModuleManagerImpl mm = (ModuleManagerImpl)ModuleManager.getInstance((Project)this.myProject);
        StartupManagerImpl sm = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        mm.projectOpened();
        this.setUpJdk();
        sm.runStartupActivities();
        sm.startCacheUpdate();
        sm.runPostStartupActivities();
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk(module, jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        try {
            this.runBareImpl();
        }
        catch (Throwable throwable) {
            try {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PlatformTestCase.cleanupApplicationCaches(PlatformTestCase.this.getProject());
                        PlatformTestCase.this.resetAllFields();
                    }
                }, ModalityState.NON_MODAL);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ApplicationManager.getApplication().invokeAndWait(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
        }
        catch (Throwable throwable) {}
    }

    private void runBareImpl() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ourTestThread = Thread.currentThread();
                ourTestTime = PlatformTestCase.getTimeRequired();
                try {
                    try {
                        PlatformTestCase.this.setUp();
                    }
                    catch (Throwable e) {
                        CompositeException result = new CompositeException(new Throwable[]{e});
                        PlatformTestCase.this.disposeProject(result);
                        throw result;
                    }
                    try {
                        PlatformTestCase.this.myAssertionsInTestDetected = true;
                        PlatformTestCase.this.runTest();
                        PlatformTestCase.this.myAssertionsInTestDetected = false;
                    }
                    catch (Throwable e) {
                        throwables[0] = e;
                        throw e;
                    }
                    finally {
                        PlatformTestCase.this.tearDown();
                    }
                }
                catch (Throwable throwable) {
                    if (throwables[0] == null) {
                        throwables[0] = throwable;
                    }
                }
                finally {
                    ourTestThread = null;
                }
            }
        };
        this.runBareRunnable(runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        if (throwables[0] != null) {
            throw throwables[0];
        }
        PlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(Runnable runnable) throws Throwable {
        SwingUtilities.invokeAndWait(runnable);
    }

    protected boolean isRunInWriteAction() {
        return true;
    }

    @Override
    protected void invokeTestRunnable(final @NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/testFramework/PlatformTestCase", "invokeTestRunnable"));
        }
        final Exception[] e = new Exception[1];
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ApplicationManager.getApplication().isDispatchThread() && PlatformTestCase.this.isRunInWriteAction()) {
                        ApplicationManager.getApplication().runWriteAction(runnable);
                    } else {
                        runnable.run();
                    }
                }
                catch (Exception e1) {
                    e[0] = e1;
                }
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public Object getData(String dataId) {
        return this.myProject == null ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    public static File createTempDir(@NonNls String prefix) throws IOException {
        return PlatformTestCase.createTempDir(prefix, true);
    }

    public static File createTempDir(@NonNls String prefix, boolean refresh) throws IOException {
        File tempDirectory = FileUtilRt.createTempDirectory((String)(TEST_DIR_PREFIX + prefix), null, (boolean)false);
        myFilesToDelete.add(tempDirectory);
        if (refresh) {
            PlatformTestCase.getVirtualFile(tempDirectory);
        }
        return tempDirectory;
    }

    @Nullable
    protected static VirtualFile getVirtualFile(File file) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    protected File createTempDirectory() throws IOException {
        return PlatformTestCase.createTempDir(this.getTestName(true));
    }

    protected File createTempDirectory(boolean refresh) throws IOException {
        return PlatformTestCase.createTempDir(this.getTestName(true), refresh);
    }

    protected File createTempFile(String name, @Nullable String text) throws IOException {
        File directory = this.createTempDirectory();
        File file = new File(directory, name);
        if (!file.createNewFile()) {
            throw new IOException("Can't create " + file);
        }
        if (text != null) {
            FileUtil.writeToFile((File)file, (String)text);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContentOnDisk(File file, byte[] bom, String content, Charset charset) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        if (bom != null) {
            stream.write(bom);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);
        try {
            writer.write(content);
        }
        finally {
            writer.close();
        }
    }

    public static VirtualFile createTempFile(@NonNls String ext, @Nullable byte[] bom, @NonNls String content, Charset charset) throws IOException {
        File temp = FileUtil.createTempFile((String)"copy", (String)("." + ext));
        PlatformTestCase.setContentOnDisk(temp, bom, content, charset);
        myFilesToDelete.add(temp);
        VirtualFile file = PlatformTestCase.getVirtualFile(temp);
        assert (file != null) : temp;
        return file;
    }

    @Nullable
    protected PsiFile getPsiFile(Document document) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    public static void initPlatformLangPrefix() {
        PlatformTestCase.initPlatformPrefix("com.intellij.openapi.components.impl.stores.IdeaProjectStoreImpl", "PlatformLangXml");
    }

    public static void initPlatformPrefix(String classToTest, String prefix) {
        if (!ourPlatformPrefixInitialized) {
            ourPlatformPrefixInitialized = true;
            boolean isUltimate = true;
            try {
                PlatformTestCase.class.getClassLoader().loadClass(classToTest);
            }
            catch (ClassNotFoundException e) {
                isUltimate = false;
            }
            if (!isUltimate) {
                PlatformTestCase.setPlatformPrefix(prefix);
            }
        }
    }

    private static void setPlatformPrefix(String prefix) {
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    protected static VirtualFile createChildData(final @NotNull VirtualFile dir, final @NotNull @NonNls String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/testFramework/PlatformTestCase", "createChildData"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/PlatformTestCase", "createChildData"));
        }
        return (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$7", "run"));
                }
                result.setResult((Object)dir.createChildData(null, name));
            }
        }.execute().throwException().getResultObject();
    }

    protected static VirtualFile createChildDirectory(final @NotNull VirtualFile dir, final @NotNull @NonNls String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/testFramework/PlatformTestCase", "createChildDirectory"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/PlatformTestCase", "createChildDirectory"));
        }
        return (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$8", "run"));
                }
                result.setResult((Object)dir.createChildDirectory(null, name));
            }
        }.execute().throwException().getResultObject();
    }

    protected static void delete(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/PlatformTestCase", "delete"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    file.delete(null);
                }
                catch (IOException e) {
                    TestCase.fail();
                }
            }
        });
    }

    protected static void rename(final @NotNull VirtualFile vFile1, final @NotNull String newName) {
        if (vFile1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile1", "com/intellij/testFramework/PlatformTestCase", "rename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/PlatformTestCase", "rename"));
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                vFile1.rename((Object)this, newName);
            }
        }.execute().throwException();
    }

    static {
        myFilesToDelete = new HashSet<File>();
        LOG = Logger.getInstance((String)"#com.intellij.testFramework.PlatformTestCase");
        ourTestCase = null;
        ourTestTime = 300L;
        Logger.setFactory(TestLoggerFactory.class);
        PREFIX_CANDIDATES = new String[]{"AppCode", "CLion", "CidrCommon", "Python", "PyCharmCore", "Ruby", "UltimateLangXml", "Idea"};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

