/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestFinder
implements TestFinder {
    public PsiClass findSourceElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/JavaTestFinder", "findSourceElement"));
        }
        return TestIntegrationUtils.findOuterClass(element);
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/JavaTestFinder", "findClassesForTest"));
        }
        PsiClass klass = this.findSourceElement(element);
        if (klass == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findClassesForTest"));
            }
            return set;
        }
        GlobalSearchScope scope = this.getSearchScope(element);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)element.getProject());
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithWeights = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        for (Pair<String, Integer> eachNameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights(klass.getName())) {
            for (PsiClass eachClass : cache.getClassesByName((String)eachNameWithWeight.first, scope)) {
                if (!JavaTestFinder.isTestSubjectClass(eachClass)) continue;
                classesWithWeights.add((Pair<? extends PsiNamedElement, Integer>)Pair.create((Object)eachClass, (Object)eachNameWithWeight.second));
            }
        }
        List<PsiElement> list = TestFinderHelper.getSortedElements(classesWithWeights, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findClassesForTest"));
        }
        return list;
    }

    protected GlobalSearchScope getSearchScope(PsiElement element) {
        Module module = JavaTestFinder.getModule(element);
        if (module != null) {
            return GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        }
        return GlobalSearchScope.projectScope((Project)element.getProject());
    }

    private static boolean isTestSubjectClass(PsiClass klass) {
        return !klass.isAnnotationType() && !TestFrameworks.getInstance().isTestClass(klass);
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/JavaTestFinder", "findTestsForClass"));
        }
        PsiClass klass = this.findSourceElement(element);
        if (klass == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findTestsForClass"));
            }
            return set;
        }
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithProximities = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(classesWithProximities);
        this.collectTests(klass, (Processor<Pair<? extends PsiNamedElement, Integer>>)processor);
        List<PsiElement> list = TestFinderHelper.getSortedElements(classesWithProximities, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findTestsForClass"));
        }
        return list;
    }

    private boolean collectTests(PsiClass klass, Processor<Pair<? extends PsiNamedElement, Integer>> processor) {
        GlobalSearchScope scope = this.getSearchScope((PsiElement)klass);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)klass.getProject());
        String klassName = klass.getName();
        Pattern pattern = Pattern.compile(".*" + klassName + ".*");
        HashSet names = new HashSet();
        cache.getAllClassNames(names);
        TestFrameworks frameworks = TestFrameworks.getInstance();
        for (String eachName : names) {
            if (!pattern.matcher(eachName).matches()) continue;
            for (PsiClass eachClass : cache.getClassesByName(eachName, scope)) {
                if (!frameworks.isTestClass(eachClass) && !frameworks.isPotentialTestClass(eachClass) || processor.process((Object)Pair.create((Object)eachClass, (Object)TestFinderHelper.calcTestNameProximity(klassName, eachName)))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Module getModule(PsiElement element) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        return index.getModuleForFile(element.getContainingFile().getVirtualFile());
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/JavaTestFinder", "isTest"));
        }
        return TestIntegrationUtils.isTest(element);
    }
}

