/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.tabs.ColorSelectionComponent;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorConfigurationEditDialog
extends DialogWrapper {
    private FileColorConfiguration myConfiguration;
    private JComboBox myScopeComboBox;
    private final FileColorManager myManager;
    private final ColorSelectionComponent myColorSelectionComponent;
    private final Map<String, NamedScope> myScopeNames;

    public FileColorConfigurationEditDialog(@NotNull FileColorManager manager, @Nullable FileColorConfiguration configuration) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/tabs/FileColorConfigurationEditDialog", "<init>"));
        }
        super(true);
        this.myScopeNames = new HashMap();
        this.setTitle(configuration == null ? "Add Color Label" : "Edit Color Label");
        this.setResizable(false);
        this.myManager = manager;
        this.myConfiguration = configuration;
        this.myColorSelectionComponent = new ColorSelectionComponent();
        this.myColorSelectionComponent.initDefault(manager, configuration == null ? null : configuration.getColorName());
        this.myColorSelectionComponent.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FileColorConfigurationEditDialog.this.updateOKButton();
            }
        });
        this.init();
        this.updateCustomButton();
        if (this.myConfiguration != null && !StringUtil.isEmpty((String)this.myConfiguration.getScopeName())) {
            this.myScopeComboBox.setSelectedItem(this.myConfiguration.getScopeName());
        }
        this.updateOKButton();
    }

    public JComboBox getScopeComboBox() {
        return this.myScopeComboBox;
    }

    protected JComponent createNorthPanel() {
        NamedScopesHolder[] scopeHolders;
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        ArrayList scopeList = new ArrayList();
        Project project = this.myManager.getProject();
        for (NamedScopesHolder scopeHolder : scopeHolders = NamedScopeManager.getAllNamedScopeHolders((Project)project)) {
            NamedScope[] scopes = scopeHolder.getScopes();
            Collections.addAll(scopeList, scopes);
        }
        CustomScopesProviderEx.filterNoSettingsScopes((Project)project, scopeList);
        for (NamedScope scope : scopeList) {
            this.myScopeNames.put(scope.getName(), scope);
        }
        this.myScopeComboBox = new JComboBox<String>(ArrayUtil.toStringArray(this.myScopeNames.keySet()));
        this.myScopeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileColorConfigurationEditDialog.this.updateCustomButton();
                FileColorConfigurationEditDialog.this.updateOKButton();
            }
        });
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BorderLayout());
        JLabel pathLabel = new JLabel("Scope:");
        pathLabel.setDisplayedMnemonic('S');
        pathLabel.setLabelFor(this.myScopeComboBox);
        pathPanel.add((Component)pathLabel, "West");
        pathPanel.add((Component)this.myScopeComboBox, "Center");
        result.add(pathPanel);
        JPanel colorPanel = new JPanel();
        colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorLabel = new JLabel("Color:");
        colorPanel.add(colorLabel);
        colorPanel.add(this.myColorSelectionComponent);
        colorPanel.add(Box.createHorizontalGlue());
        result.add(colorPanel);
        return result;
    }

    private void updateCustomButton() {
        Object item = this.myScopeComboBox.getSelectedItem();
        if (item instanceof String) {
            Color color;
            Color color2 = color = this.myConfiguration == null ? null : ColorUtil.fromHex((String)this.myConfiguration.getColorName(), null);
            if (color == null) {
                color = ColorUtil.getColor(this.myScopeNames.get(item).getClass());
            }
            if (color != null) {
                this.myColorSelectionComponent.setCustomButtonColor(color);
            }
        }
    }

    protected void doOKAction() {
        this.close(0);
        if (this.myConfiguration != null) {
            this.myConfiguration.setScopeName((String)this.myScopeComboBox.getSelectedItem());
            this.myConfiguration.setColorName(this.getColorName());
        } else {
            this.myConfiguration = new FileColorConfiguration((String)this.myScopeComboBox.getSelectedItem(), this.getColorName());
        }
    }

    public FileColorConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Nullable
    private String getColorName() {
        return this.myColorSelectionComponent.getSelectedColorName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myScopeComboBox;
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    public boolean isOKActionEnabled() {
        String scopeName = (String)this.myScopeComboBox.getSelectedItem();
        return scopeName != null && scopeName.length() > 0 && this.getColorName() != null;
    }

    protected JComponent createCenterPanel() {
        return null;
    }
}

