/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.net.NetUtils;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class FileDownloaderImpl
implements FileDownloader {
    private static final Logger LOG = Logger.getInstance(FileDownloaderImpl.class);
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 60000;
    @NonNls
    private static final String LIB_SCHEMA = "lib://";
    private final List<? extends DownloadableFileDescription> myFileDescriptions;
    private final JComponent myParentComponent;
    @Nullable
    private final Project myProject;
    private String myDirectoryForDownloadedFilesPath;
    private final String myDialogTitle;

    public FileDownloaderImpl(@NotNull List<? extends DownloadableFileDescription> fileDescriptions, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull String presentableDownloadName) {
        if (fileDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDescriptions", "com/intellij/util/download/impl/FileDownloaderImpl", "<init>"));
        }
        if (presentableDownloadName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableDownloadName", "com/intellij/util/download/impl/FileDownloaderImpl", "<init>"));
        }
        this.myProject = project;
        this.myFileDescriptions = fileDescriptions;
        this.myParentComponent = parentComponent;
        this.myDialogTitle = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)presentableDownloadName)});
    }

    @Nullable
    public List<VirtualFile> downloadFilesWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project, @Nullable JComponent parentComponent) {
        List<Pair<VirtualFile, DownloadableFileDescription>> pairs = this.downloadWithProgress(targetDirectoryPath, project, parentComponent);
        if (pairs == null) {
            return null;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (Pair<VirtualFile, DownloadableFileDescription> pair : pairs) {
            files.add((VirtualFile)pair.getFirst());
        }
        return files;
    }

    @Nullable
    public List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project, @Nullable JComponent parentComponent) {
        File dir;
        if (targetDirectoryPath != null) {
            dir = new File(targetDirectoryPath);
        } else {
            VirtualFile virtualDir = FileDownloaderImpl.chooseDirectoryForFiles(project, parentComponent);
            if (virtualDir != null) {
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)virtualDir);
            } else {
                return null;
            }
        }
        return this.downloadWithProcess(dir, project, parentComponent);
    }

    @Nullable
    private List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProcess(final File targetDir, Project project, JComponent parentComponent) {
        final Ref localFiles = Ref.create(null);
        final Ref exceptionRef = Ref.create(null);
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    localFiles.set(FileDownloaderImpl.this.download(targetDir));
                }
                catch (IOException e) {
                    exceptionRef.set((Object)e);
                }
            }
        }, this.myDialogTitle, true, project, parentComponent);
        if (!completed) {
            return null;
        }
        Exception exception = (Exception)exceptionRef.get();
        if (exception != null) {
            boolean tryAgain = IOExceptionDialog.showErrorDialog((String)this.myDialogTitle, (String)exception.getMessage());
            if (tryAgain) {
                return this.downloadWithProcess(targetDir, project, parentComponent);
            }
            return null;
        }
        return FileDownloaderImpl.findVirtualFiles((List)localFiles.get());
    }

    @NotNull
    public List<Pair<File, DownloadableFileDescription>> download(final @NotNull File targetDir) throws IOException {
        ArrayList<Pair<File, DownloadableFileDescription>> arrayList;
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/util/download/impl/FileDownloaderImpl", "download"));
        }
        final ArrayList<Pair<File, DownloadableFileDescription>> downloadedFiles = new ArrayList<Pair<File, DownloadableFileDescription>>();
        final ArrayList existingFiles = new ArrayList();
        ProgressIndicator parentIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (parentIndicator == null) {
            parentIndicator = new EmptyProgressIndicator();
        }
        try {
            final ConcurrentTasksProgressManager progressManager = new ConcurrentTasksProgressManager(parentIndicator, this.myFileDescriptions.size());
            parentIndicator.setText(IdeBundle.message((String)"progress.downloading.0.files.text", (Object[])new Object[]{this.myFileDescriptions.size()}));
            int maxParallelDownloads = Runtime.getRuntime().availableProcessors();
            LOG.debug("Downloading " + this.myFileDescriptions.size() + " files using " + maxParallelDownloads + " threads");
            long start = System.currentTimeMillis();
            BoundedTaskExecutor executor = new BoundedTaskExecutor((Executor)PooledThreadExecutor.INSTANCE, maxParallelDownloads);
            ArrayList<Future> results = new ArrayList<Future>();
            final AtomicLong totalSize = new AtomicLong();
            for (final DownloadableFileDescription downloadableFileDescription : this.myFileDescriptions) {
                results.add(executor.submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        SubTaskProgressIndicator indicator = progressManager.createSubTaskIndicator();
                        indicator.checkCanceled();
                        File existing = new File(targetDir, downloadableFileDescription.getDefaultFileName());
                        String url = downloadableFileDescription.getDownloadUrl();
                        if (url.startsWith(FileDownloaderImpl.LIB_SCHEMA)) {
                            String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)FileDownloaderImpl.LIB_SCHEMA));
                            File file = PathManager.findFileInLibDirectory((String)path);
                            existingFiles.add(Pair.create((Object)file, (Object)downloadableFileDescription));
                        } else if (url.startsWith("file://")) {
                            String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)"file://"));
                            File file = new File(path);
                            if (file.exists()) {
                                existingFiles.add(Pair.create((Object)file, (Object)downloadableFileDescription));
                            }
                        } else {
                            File downloaded;
                            try {
                                downloaded = FileDownloaderImpl.downloadFile(downloadableFileDescription, existing, indicator);
                            }
                            catch (IOException e) {
                                throw new IOException(IdeBundle.message((String)"error.file.download.failed", (Object[])new Object[]{downloadableFileDescription.getDownloadUrl(), e.getMessage()}), e);
                            }
                            if (FileUtil.filesEqual((File)downloaded, (File)existing)) {
                                existingFiles.add(Pair.create((Object)existing, (Object)downloadableFileDescription));
                            } else {
                                totalSize.addAndGet(downloaded.length());
                                downloadedFiles.add(Pair.create((Object)downloaded, (Object)downloadableFileDescription));
                            }
                        }
                        indicator.finished();
                        return null;
                    }
                }));
            }
            for (Future future : results) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ProcessCanceledException.class);
                    LOG.error((Throwable)e);
                }
            }
            long duration = System.currentTimeMillis() - start;
            LOG.debug("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration) + "(" + duration + "ms)");
            ArrayList<Pair<File, DownloadableFileDescription>> localFiles = new ArrayList<Pair<File, DownloadableFileDescription>>();
            localFiles.addAll(FileDownloaderImpl.moveToDir(downloadedFiles, targetDir));
            localFiles.addAll(existingFiles);
            arrayList = localFiles;
        }
        catch (ProcessCanceledException e) {
            FileDownloaderImpl.deleteFiles(downloadedFiles);
            throw e;
        }
        catch (IOException e) {
            FileDownloaderImpl.deleteFiles(downloadedFiles);
            throw e;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "download"));
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile chooseDirectoryForFiles(Project project, JComponent parentComponent) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(IdeBundle.message((String)"dialog.directory.for.downloaded.files.title", (Object[])new Object[0]));
        VirtualFile baseDir = project != null ? project.getBaseDir() : null;
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)parentComponent, (Project)project, (VirtualFile)baseDir);
    }

    private static List<Pair<File, DownloadableFileDescription>> moveToDir(List<Pair<File, DownloadableFileDescription>> downloadedFiles, final File targetDir) throws IOException {
        FileUtil.createDirectory((File)targetDir);
        ArrayList<Pair<File, DownloadableFileDescription>> result = new ArrayList<Pair<File, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : downloadedFiles) {
            DownloadableFileDescription description = (DownloadableFileDescription)pair.getSecond();
            String fileName = description.generateFileName((Condition)new Condition<String>(){

                public boolean value(String s) {
                    return !new File(targetDir, s).exists();
                }
            });
            File toFile = new File(targetDir, fileName);
            FileUtil.rename((File)((File)pair.getFirst()), (File)toFile);
            result.add((Pair<File, DownloadableFileDescription>)Pair.create((Object)toFile, (Object)description));
        }
        return result;
    }

    @NotNull
    private static List<Pair<VirtualFile, DownloadableFileDescription>> findVirtualFiles(List<Pair<File, DownloadableFileDescription>> ioFiles) {
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> result = new ArrayList<Pair<VirtualFile, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : ioFiles) {
            final File ioFile = (File)pair.getFirst();
            VirtualFile libraryRootFile = (VirtualFile)new WriteAction<VirtualFile>(){

                protected void run(Result<VirtualFile> result) {
                    String url = VfsUtil.getUrlForLibraryRoot((File)ioFile);
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
                    result.setResult((Object)VirtualFileManager.getInstance().refreshAndFindFileByUrl(url));
                }
            }.execute().getResultObject();
            if (libraryRootFile == null) continue;
            result.add((Pair<VirtualFile, DownloadableFileDescription>)Pair.create((Object)libraryRootFile, (Object)pair.getSecond()));
        }
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "findVirtualFiles"));
        }
        return arrayList;
    }

    private static void deleteFiles(List<Pair<File, DownloadableFileDescription>> pairs) {
        for (Pair<File, DownloadableFileDescription> pair : pairs) {
            FileUtil.delete((File)((File)pair.getFirst()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static File downloadFile(@NotNull DownloadableFileDescription fileDescription, @NotNull File existingFile, @NotNull ProgressIndicator indicator) throws IOException {
        File file;
        File tempFile;
        boolean deleteFile;
        FilterOutputStream output;
        HttpURLConnection connection;
        block18: {
            int size;
            InputStream input;
            String presentableUrl;
            block16: {
                File file2;
                block17: {
                    if (fileDescription == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDescription", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
                    }
                    if (existingFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingFile", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
                    }
                    presentableUrl = fileDescription.getPresentableDownloadUrl();
                    indicator.setText2(IdeBundle.message((String)"progress.connecting.to.download.file.text", (Object[])new Object[]{presentableUrl}));
                    indicator.setIndeterminate(true);
                    connection = (HttpURLConnection)new URL(fileDescription.getDownloadUrl()).openConnection();
                    connection.setConnectTimeout(60000);
                    connection.setReadTimeout(60000);
                    input = null;
                    output = null;
                    deleteFile = true;
                    tempFile = null;
                    try {
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 200) {
                            throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
                        }
                        size = connection.getContentLength();
                        if (!existingFile.exists() || (long)size != existingFile.length()) break block16;
                        file2 = existingFile;
                        if (input == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                        if (deleteFile && tempFile != null) {
                            FileUtil.delete(tempFile);
                        }
                        connection.disconnect();
                        throw throwable;
                    }
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                if (deleteFile && tempFile != null) {
                    FileUtil.delete((File)tempFile);
                }
                connection.disconnect();
                File file3 = file2;
                if (file3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
                }
                return file3;
            }
            tempFile = FileUtil.createTempFile((String)"downloaded", (String)"file");
            input = UrlConnectionUtil.getConnectionInputStreamWithException(connection, indicator);
            output = new BufferedOutputStream(new FileOutputStream(tempFile));
            indicator.setText2(IdeBundle.message((String)"progress.download.file.text", (Object[])new Object[]{fileDescription.getPresentableFileName(), presentableUrl}));
            indicator.setIndeterminate(size == -1);
            NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)input, (OutputStream)output, (int)size);
            deleteFile = false;
            file = tempFile;
            if (input == null) break block18;
            input.close();
        }
        if (output != null) {
            output.close();
        }
        if (deleteFile && tempFile != null) {
            FileUtil.delete((File)tempFile);
        }
        connection.disconnect();
        File file4 = file;
        if (file4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
        }
        return file4;
    }

    @NotNull
    public FileDownloader toDirectory(@NotNull String directoryForDownloadedFilesPath) {
        if (directoryForDownloadedFilesPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryForDownloadedFilesPath", "com/intellij/util/download/impl/FileDownloaderImpl", "toDirectory"));
        }
        this.myDirectoryForDownloadedFilesPath = directoryForDownloadedFilesPath;
        FileDownloaderImpl fileDownloaderImpl = this;
        if (fileDownloaderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "toDirectory"));
        }
        return fileDownloaderImpl;
    }

    @Nullable
    public VirtualFile[] download() {
        List<VirtualFile> files = this.downloadFilesWithProgress(this.myDirectoryForDownloadedFilesPath, this.myProject, this.myParentComponent);
        return files != null ? VfsUtilCore.toVirtualFileArray(files) : null;
    }

    @Nullable
    public List<Pair<VirtualFile, DownloadableFileDescription>> downloadAndReturnWithDescriptions() {
        return this.downloadWithProgress(this.myDirectoryForDownloadedFilesPath, this.myProject, this.myParentComponent);
    }

    private static class SubTaskProgressIndicator
    extends SensitiveProgressWrapper {
        private final AtomicDouble myFraction;
        private final ConcurrentTasksProgressManager myProgressManager;

        private SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager) {
            super(progressManager.myParent);
            this.myProgressManager = progressManager;
            this.myFraction = new AtomicDouble();
        }

        @Override
        public void setFraction(double newValue) {
            double oldValue = this.myFraction.getAndSet(newValue);
            this.myProgressManager.updateFraction(newValue - oldValue);
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
            if (this.myProgressManager.myTasksCount > 1) {
                return;
            }
            super.setIndeterminate(indeterminate);
        }

        @Override
        public void setText2(String text) {
            this.myProgressManager.setText2(this, text);
        }

        @Override
        public double getFraction() {
            return this.myFraction.get();
        }

        public void finished() {
            this.setFraction(1.0);
            this.myProgressManager.setText2(this, null);
        }
    }

    private static class ConcurrentTasksProgressManager {
        private final ProgressIndicator myParent;
        private final int myTasksCount;
        private final AtomicDouble myTotalFraction;
        private final Object myLock = new Object();
        private final LinkedHashMap<SubTaskProgressIndicator, String> myText2Stack = new LinkedHashMap();

        private ConcurrentTasksProgressManager(ProgressIndicator parent, int tasksCount) {
            this.myParent = parent;
            this.myTasksCount = tasksCount;
            this.myTotalFraction = new AtomicDouble();
        }

        public void updateFraction(double delta) {
            this.myTotalFraction.addAndGet(delta / (double)this.myTasksCount);
            this.myParent.setFraction(this.myTotalFraction.get());
        }

        public SubTaskProgressIndicator createSubTaskIndicator() {
            return new SubTaskProgressIndicator(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable String text) {
            if (subTask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subTask", "com/intellij/util/download/impl/FileDownloaderImpl$ConcurrentTasksProgressManager", "setText2"));
            }
            if (text != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.put((Object)subTask, (Object)text);
                }
                this.myParent.setText2(text);
            } else {
                String prev;
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.remove((Object)subTask);
                    prev = (String)this.myText2Stack.getLastValue();
                }
                if (prev != null) {
                    this.myParent.setText2(prev);
                }
            }
        }
    }
}

