/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.EmptyVisibleGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VisiblePack
implements VcsLogDataPack {
    public static final VisiblePack EMPTY = new VisiblePack(DataPack.EMPTY, EmptyVisibleGraph.getInstance(), false);
    @NotNull
    private final DataPack myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;

    VisiblePack(@NotNull DataPack dataPack, @NotNull VisibleGraph<Integer> graph, boolean canRequestMore) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePack", "<init>"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/data/VisiblePack", "<init>"));
        }
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph;
        this.myCanRequestMore = canRequestMore;
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.myVisibleGraph;
        if (visibleGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePack", "getVisibleGraph"));
        }
        return visibleGraph;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map = this.myDataPack.getLogProviders();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePack", "getLogProviders"));
        }
        return map;
    }

    @NotNull
    public VcsLogRefs getRefs() {
        VcsLogRefs vcsLogRefs = this.myDataPack.getRefs();
        if (vcsLogRefs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePack", "getRefs"));
        }
        return vcsLogRefs;
    }

    @NotNull
    public RefsModel getRefsModel() {
        RefsModel refsModel = this.myDataPack.getRefsModel();
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePack", "getRefsModel"));
        }
        return refsModel;
    }

    @NotNull
    public PermanentGraph<Integer> getPermanentGraph() {
        PermanentGraph<Integer> permanentGraph = this.myDataPack.getPermanentGraph();
        if (permanentGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePack", "getPermanentGraph"));
        }
        return permanentGraph;
    }
}

