/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.SimplePrintElement;
import com.intellij.vcs.log.graph.api.PrintedLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import com.intellij.vcs.log.graph.impl.print.elements.EdgePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.SimplePrintElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPrintElementGenerator
implements PrintElementGenerator {
    @NotNull
    protected final PrintedLinearGraph myPrintedLinearGraph;
    @NotNull
    protected final PrintElementsManager myPrintElementsManager;

    protected AbstractPrintElementGenerator(@NotNull PrintedLinearGraph printedLinearGraph, @NotNull PrintElementsManager printElementsManager) {
        if (printedLinearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printedLinearGraph", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "<init>"));
        }
        if (printElementsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementsManager", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "<init>"));
        }
        this.myPrintedLinearGraph = printedLinearGraph;
        this.myPrintElementsManager = printElementsManager;
    }

    @Override
    @NotNull
    public Collection<PrintElement> getPrintElements(int rowIndex) {
        ArrayList<PrintElement> result = new ArrayList<PrintElement>();
        if (rowIndex < this.myPrintedLinearGraph.nodesCount() - 1) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex)) {
                result.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.DOWN));
            }
        }
        if (rowIndex > 0) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex - 1)) {
                result.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.UP));
            }
        }
        for (SimpleRowElement rowElement : this.getSimpleRowElements(rowIndex)) {
            result.add(this.createSimplePrintElement(rowIndex, rowElement));
        }
        ArrayList<PrintElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "getPrintElements"));
        }
        return arrayList;
    }

    private SimplePrintElementImpl createSimplePrintElement(int rowIndex, SimpleRowElement rowElement) {
        return new SimplePrintElementImpl(rowIndex, rowElement.myPosition, rowElement.myType, rowElement.myElement, this.myPrintElementsManager);
    }

    private EdgePrintElementImpl createEdgePrintElement(int rowIndex, @NotNull ShortEdge shortEdge, @NotNull EdgePrintElement.Type type) {
        int positionInOtherRow;
        int positionInCurrentRow;
        if (shortEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortEdge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createEdgePrintElement"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "createEdgePrintElement"));
        }
        if (type == EdgePrintElement.Type.DOWN) {
            positionInCurrentRow = shortEdge.myUpPosition;
            positionInOtherRow = shortEdge.myDownPosition;
        } else {
            positionInCurrentRow = shortEdge.myDownPosition;
            positionInOtherRow = shortEdge.myUpPosition;
        }
        return new EdgePrintElementImpl(rowIndex, positionInCurrentRow, positionInOtherRow, type, shortEdge.myEdge, this.myPrintElementsManager);
    }

    @Override
    @NotNull
    public PrintElementWithGraphElement toPrintElementWithGraphElement(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
        }
        if (printElement instanceof PrintElementWithGraphElement) {
            PrintElementWithGraphElement printElementWithGraphElement = (PrintElementWithGraphElement)printElement;
            if (printElementWithGraphElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
            }
            return printElementWithGraphElement;
        }
        int rowIndex = printElement.getRowIndex();
        if (printElement instanceof SimplePrintElement) {
            for (SimpleRowElement rowElement : this.getSimpleRowElements(rowIndex)) {
                if (rowElement.myPosition != printElement.getPositionInCurrentRow()) continue;
                SimplePrintElementImpl simplePrintElementImpl = this.createSimplePrintElement(rowIndex, rowElement);
                if (simplePrintElementImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
                }
                return simplePrintElementImpl;
            }
        }
        if (printElement instanceof EdgePrintElement) {
            EdgePrintElement edgePrintElement = (EdgePrintElement)printElement;
            if (edgePrintElement.getType() == EdgePrintElement.Type.DOWN) {
                for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex)) {
                    if (shortEdge.myUpPosition != edgePrintElement.getPositionInCurrentRow() || shortEdge.myDownPosition != edgePrintElement.getPositionInOtherRow()) continue;
                    EdgePrintElementImpl edgePrintElementImpl = this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.DOWN);
                    if (edgePrintElementImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
                    }
                    return edgePrintElementImpl;
                }
            }
            if (edgePrintElement.getType() == EdgePrintElement.Type.UP) {
                for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex - 1)) {
                    if (shortEdge.myDownPosition != edgePrintElement.getPositionInCurrentRow() || shortEdge.myUpPosition != edgePrintElement.getPositionInOtherRow()) continue;
                    EdgePrintElementImpl edgePrintElementImpl = this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.UP);
                    if (edgePrintElementImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator", "toPrintElementWithGraphElement"));
                    }
                    return edgePrintElementImpl;
                }
            }
        }
        throw new IllegalStateException("Not found graphElement for this printElement: " + printElement);
    }

    @NotNull
    protected abstract Collection<ShortEdge> getDownShortEdges(int var1);

    @NotNull
    protected abstract Collection<SimpleRowElement> getSimpleRowElements(int var1);

    protected static class SimpleRowElement {
        @NotNull
        public final GraphElement myElement;
        @NotNull
        public final SimplePrintElement.Type myType;
        public final int myPosition;

        public SimpleRowElement(@NotNull GraphElement element, @NotNull SimplePrintElement.Type type, int position) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$SimpleRowElement", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$SimpleRowElement", "<init>"));
            }
            this.myElement = element;
            this.myPosition = position;
            this.myType = type;
        }
    }

    protected static class ShortEdge {
        @NotNull
        public final GraphEdge myEdge;
        public final int myUpPosition;
        public final int myDownPosition;

        public ShortEdge(@NotNull GraphEdge edge, int upPosition, int downPosition) {
            if (edge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$ShortEdge", "<init>"));
            }
            this.myEdge = edge;
            this.myUpPosition = upPosition;
            this.myDownPosition = downPosition;
        }
    }
}

