/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.vcs.log.Hash;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class HashImpl
implements Hash {
    private static final int SHORT_HASH_LENGTH = 7;
    @NotNull
    private final byte[] myData;
    private final int myHashCode;

    @NotNull
    public static Hash build(@NotNull String inputStr) {
        if (inputStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStr", "com/intellij/vcs/log/impl/HashImpl", "build"));
        }
        byte[] data = HashImpl.buildData(inputStr);
        HashImpl hashImpl = new HashImpl(data);
        if (hashImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/HashImpl", "build"));
        }
        return hashImpl;
    }

    @NotNull
    private static byte[] buildData(@NotNull String inputStr) {
        if (inputStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStr", "com/intellij/vcs/log/impl/HashImpl", "buildData"));
        }
        int length = inputStr.length();
        byte even = (byte)(length % 2);
        byte[] data = new byte[length / 2 + 1 + even];
        data[0] = even;
        try {
            for (int i = 0; i < length / 2; ++i) {
                int k = Integer.parseInt(inputStr.substring(2 * i, 2 * i + 2), 16);
                data[i + 1] = (byte)(k - 128);
            }
            if (even == 1) {
                int k = Integer.parseInt(inputStr.substring(length - 1), 16);
                data[length / 2 + 1] = (byte)(k - 128);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad hash string: " + inputStr);
        }
        if (data == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/HashImpl", "buildData"));
        }
        return data;
    }

    private HashImpl(@NotNull byte[] hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/HashImpl", "<init>"));
        }
        this.myData = hash;
        this.myHashCode = Arrays.hashCode(hash);
    }

    @NotNull
    public String asString() {
        assert (this.myData.length > 0) : "bad length Hash.data";
        byte even = this.myData[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < this.myData.length; ++i) {
            int k1 = (this.myData[i] + 128) / 16;
            int k2 = (this.myData[i] + 128) % 16;
            char c1 = Character.forDigit(k1, 16);
            char c2 = Character.forDigit(k2, 16);
            if (i == this.myData.length - 1 && even == 1) {
                sb.append(c2);
                continue;
            }
            sb.append(c1).append(c2);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/HashImpl", "asString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashImpl that = (HashImpl)o;
        return this.myHashCode == that.myHashCode && Arrays.equals(this.myData, that.myData);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public String toString() {
        return this.asString();
    }

    @NotNull
    public String toShortString() {
        String s = this.asString();
        String string = s.substring(0, Math.min(s.length(), 7));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/HashImpl", "toShortString"));
        }
        return string;
    }
}

