/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.logProvider");
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogSettings mySettings;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    private VcsLogRefresher myLogRefresher;
    private volatile VcsLogUiImpl myUi;

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        this.myProject = project;
        this.mySettings = settings;
        this.myUiProperties = uiProperties;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    @NotNull
    public JComponent initContent(@NotNull Collection<VcsRoot> roots, @Nullable String contentTabName) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogManager", "initContent"));
        }
        Map<VirtualFile, VcsLogProvider> logProviders = this.findLogProviders(roots);
        Consumer<VisiblePack> visiblePackConsumer = new Consumer<VisiblePack>(){

            public void consume(final VisiblePack pack) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!Disposer.isDisposed((Disposable)VcsLogManager.this.myUi)) {
                            VcsLogManager.this.myUi.setVisiblePack(pack);
                        }
                    }
                });
            }
        };
        final VcsLogDataHolder logDataHolder = new VcsLogDataHolder(this.myProject, this, logProviders, this.mySettings, this.myUiProperties, visiblePackConsumer);
        this.myUi = new VcsLogUiImpl(logDataHolder, this.myProject, this.mySettings, new VcsLogColorManagerImpl(logProviders.keySet()), this.myUiProperties, logDataHolder.getFilterer());
        this.myUi.addLogListener(logDataHolder.getContainingBranchesGetter());
        this.myLogRefresher = contentTabName != null ? new PostponeableLogRefresher(this.myProject, logDataHolder, contentTabName) : new VcsLogRefresher(){

            public void refresh(@NotNull VirtualFile root) {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogManager$2", "refresh"));
                }
                logDataHolder.refresh(Collections.singletonList(root));
            }
        };
        this.refreshLogOnVcsEvents(logProviders);
        logDataHolder.initialize();
        final VcsLogGraphTable graphTable = this.myUi.getTable();
        if (graphTable.getRowCount() > 0) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    graphTable.setRowSelectionInterval(0, 0);
                }
            });
        }
        JComponent jComponent = this.myUi.getMainFrame().getMainComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "initContent"));
        }
        return jComponent;
    }

    private void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/impl/VcsLogManager", "refreshLogOnVcsEvents"));
        }
        MultiMap providers2roots = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            providers2roots.putValue((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : providers2roots.entrySet()) {
            ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), this.myLogRefresher);
        }
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogManager", "findLogProviders"));
        }
        HashMap logProviders = ContainerUtil.newHashMap();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])Extensions.getExtensions(LOG_PROVIDER_EP, (AreaInstance)this.myProject);
        block0: for (VcsRoot root : roots) {
            AbstractVcs vcs = root.getVcs();
            VirtualFile path = root.getPath();
            if (vcs == null || path == null) {
                LOG.error("Skipping invalid VCS root: " + root);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path, provider);
                continue block0;
            }
        }
        HashMap hashMap = logProviders;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "findLogProviders"));
        }
        return hashMap;
    }

    @Nullable
    public VcsLogUiImpl getLogUi() {
        return this.myUi;
    }

    public void dispose() {
    }

    private static class PostponeableLogRefresher
    implements VcsLogRefresher,
    Disposable {
        private static final String TOOLWINDOW_ID = ChangesViewContentManager.TOOLWINDOW_ID;
        @NotNull
        private final VcsLogDataHolder myDataHolder;
        @NotNull
        private final ToolWindowManagerImpl myToolWindowManager;
        @NotNull
        private final ToolWindowImpl myToolWindow;
        @NotNull
        private final String myTabName;
        @NotNull
        private final MyRefreshPostponedEventsListener myPostponedEventsListener;
        @NotNull
        private final Set<VirtualFile> myRootsToRefresh;

        public PostponeableLogRefresher(@NotNull Project project, @NotNull VcsLogDataHolder dataHolder, @NotNull String contentTabName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "<init>"));
            }
            if (dataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "<init>"));
            }
            if (contentTabName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTabName", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "<init>"));
            }
            this.myRootsToRefresh = new ConcurrentHashSet();
            this.myDataHolder = dataHolder;
            this.myToolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project);
            this.myToolWindow = (ToolWindowImpl)this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID);
            this.myTabName = contentTabName;
            Disposer.register((Disposable)this.myToolWindow.getContentManager(), (Disposable)this);
            this.myPostponedEventsListener = new MyRefreshPostponedEventsListener();
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            this.myToolWindowManager.addToolWindowManagerListener(this.myPostponedEventsListener);
        }

        public void refresh(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher", "refresh"));
            }
            if (this.isOurContentPaneShowing()) {
                this.myDataHolder.refresh(Collections.singleton(root));
            } else {
                this.myRootsToRefresh.add(root);
            }
        }

        public void dispose() {
            this.myToolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            this.myToolWindowManager.removeToolWindowManagerListener(this.myPostponedEventsListener);
        }

        private boolean isOurContentPaneShowing() {
            if (this.myToolWindowManager.isToolWindowRegistered(TOOLWINDOW_ID) && this.myToolWindow.isVisible()) {
                Content content = this.myToolWindow.getContentManager().getSelectedContent();
                return content != null && content.getTabName().equals(this.myTabName);
            }
            return false;
        }

        private void refreshPostponedRoots() {
            HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>(this.myRootsToRefresh);
            this.myRootsToRefresh.removeAll(toRefresh);
            this.myDataHolder.refresh(toRefresh);
        }

        private class MyRefreshPostponedEventsListener
        extends ContentManagerAdapter
        implements ToolWindowManagerListener {
            private MyRefreshPostponedEventsListener() {
            }

            public void selectionChanged(ContentManagerEvent event) {
                this.refreshRootsIfNeeded();
            }

            @Override
            public void stateChanged() {
                this.refreshRootsIfNeeded();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/impl/VcsLogManager$PostponeableLogRefresher$MyRefreshPostponedEventsListener", "toolWindowRegistered"));
                }
            }

            private void refreshRootsIfNeeded() {
                if (PostponeableLogRefresher.this.isOurContentPaneShowing()) {
                    PostponeableLogRefresher.this.refreshPostponedRoots();
                }
            }
        }
    }
}

