/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterPopupComponent<Filter extends VcsLogFilter>
extends JPanel {
    protected static final String ALL = "All";
    private static final int GAP_BEFORE_ARROW = 3;
    private static final int BORDER_SIZE = 2;
    private static final Border INNER_MARGIN_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Border FOCUSED_BORDER = FilterPopupComponent.createFocusedBorder();
    private static final Border UNFOCUSED_BORDER = FilterPopupComponent.createUnfocusedBorder();
    @NotNull
    private final JLabel myFilterNameLabel;
    @NotNull
    private final JLabel myFilterValueLabel;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;

    FilterPopupComponent(@NotNull VcsLogClassicFilterUi filterUi, @NotNull String filterName) {
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "<init>"));
        }
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "<init>"));
        }
        this.myFilterUi = filterUi;
        this.myFilterNameLabel = new JLabel(filterName + ": ");
        this.myFilterValueLabel = new JLabel(ALL);
        this.setDefaultForeground();
        this.setFocusable(true);
        this.setBorder(UNFOCUSED_BORDER);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myFilterNameLabel);
        this.add(this.myFilterValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        this.indicateHovering();
        this.indicateFocusing();
    }

    private static Border createFocusedBorder() {
        return BorderFactory.createCompoundBorder((Border)new RoundedLineBorder(UIUtil.getHeaderActiveColor(), 10, 2), INNER_MARGIN_BORDER);
    }

    private static Border createUnfocusedBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), INNER_MARGIN_BORDER);
    }

    protected abstract ActionGroup createActionGroup();

    @Nullable
    protected abstract Filter getFilter();

    protected void setValue(@NotNull String newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "setValue"));
        }
        this.setValue(newValue, newValue);
    }

    protected void setValue(@NotNull String value, @NotNull String tooltip) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "setValue"));
        }
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "setValue"));
        }
        this.myFilterValueLabel.setText(value);
        this.setToolTipText(tooltip.equals(value) ? null : tooltip);
    }

    @NotNull
    public String getValue() {
        String string = this.myFilterValueLabel.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "getValue"));
        }
        return string;
    }

    protected void applyFilters() {
        this.myFilterUi.applyFilters();
    }

    @NotNull
    protected AnAction createAllAction() {
        AllAction allAction = new AllAction(this);
        if (allAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "createAllAction"));
        }
        return allAction;
    }

    private void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FilterPopupComponent.this.setBorder(FOCUSED_BORDER);
            }

            @Override
            public void focusLost(FocusEvent e) {
                FilterPopupComponent.this.setBorder(UNFOCUSED_BORDER);
            }
        });
    }

    private void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    FilterPopupComponent.this.showPopupMenu();
                }
            }
        });
    }

    private void showPopupMenuOnClick() {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$3", "onClick"));
                }
                FilterPopupComponent.this.showPopupMenu();
                return true;
            }
        }.installOn((Component)this);
    }

    private void indicateHovering() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FilterPopupComponent.this.setOnHoverForeground();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FilterPopupComponent.this.setDefaultForeground();
            }
        });
    }

    private void setDefaultForeground() {
        this.myFilterNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
        this.myFilterValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor().darker().darker());
    }

    private void setOnHoverForeground() {
        this.myFilterNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        this.myFilterValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private void showPopupMenu() {
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        popup.showUnderneathOf((Component)this);
    }

    protected static class SetValueAction
    extends DumbAwareAction {
        private final String myValue;
        private final FilterPopupComponent myFilterComponent;

        SetValueAction(String value, FilterPopupComponent filterComponent) {
            super(value);
            this.myValue = value;
            this.myFilterComponent = filterComponent;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myFilterComponent.setValue(this.myValue);
            this.myFilterComponent.applyFilters();
        }
    }

    private static class AllAction
    extends SetValueAction {
        AllAction(@NotNull FilterPopupComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$AllAction", "<init>"));
            }
            super(FilterPopupComponent.ALL, component);
        }
    }
}

