/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerTreeActionBase
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        String nodeName;
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        if (node != null && (nodeName = node.getName()) != null) {
            this.perform(node, nodeName, e);
        }
    }

    protected abstract void perform(XValueNodeImpl var1, @NotNull String var2, AnActionEvent var3);

    public void update(AnActionEvent e) {
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        e.getPresentation().setEnabled(node != null && this.isEnabled(node, e));
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "isEnabled"));
        }
        return node.getName() != null;
    }

    @Nullable
    public static XValueNodeImpl getSelectedNode(DataContext dataContext) {
        XDebuggerTree tree = XDebuggerTree.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        return node instanceof XValueNodeImpl ? (XValueNodeImpl)node : null;
    }

    @Nullable
    public static XValue getSelectedValue(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase", "getSelectedValue"));
        }
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(dataContext);
        return node != null ? (XValue)node.getValueContainer() : null;
    }
}

