/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ExpectedHighlightingData;
import java.io.File;
import java.io.IOException;

public class DumpCleanHighlightingTestdataAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + DumpCleanHighlightingTestdataAction.class));

    public DumpCleanHighlightingTestdataAction() {
        super("Dump highlighting-markup-free data");
    }

    public void actionPerformed(AnActionEvent event) {
        VirtualFile virtualFile;
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                ExpectedHighlightingData data = new ExpectedHighlightingData(document, true, true);
                data.init();
            }
            return;
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle("Choose Directory");
        descriptor.setDescription("Directory containing highlighting test data");
        VirtualFile dirToProcess = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (dirToProcess != null) {
            LOG.assertTrue(project != null);
            FileChooserDescriptor targetDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            targetDescriptor.setTitle("Choose Directory");
            targetDescriptor.setDescription("Directory where highlighting-markup-free copies would be placed");
            VirtualFile destinationFolder = FileChooser.chooseFile((FileChooserDescriptor)targetDescriptor, (Project)project, null);
            if (dirToProcess.equals(destinationFolder)) {
                Messages.showErrorDialog((Project)project, (String)"Source and destination roots should differ", (String)"Reject to Proceed");
                return;
            }
            if (destinationFolder != null) {
                VirtualFile[] files;
                File destination = VfsUtilCore.virtualToIoFile((VirtualFile)destinationFolder);
                for (VirtualFile virtualFile2 : files = dirToProcess.getChildren()) {
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
                    if (document == null) continue;
                    ExpectedHighlightingData data = new ExpectedHighlightingData(document, true, true);
                    data.init();
                    File file = new File(destination, virtualFile2.getName());
                    try {
                        FileUtil.writeToFile((File)file, (String)document.getText());
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(CommonDataKeys.PROJECT.getData(e.getDataContext()) != null);
    }
}

