/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class RightMarginForm {
    private JTextField myRightMarginField;
    private JCheckBox myDefaultGeneralCheckBox;
    private JPanel myTopPanel;
    private final Language myLanguage;
    private final int myDefaultRightMargin;

    public RightMarginForm(@NotNull Language language, @NotNull CodeStyleSettings settings) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/RightMarginForm", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "<init>"));
        }
        this.myLanguage = language;
        this.$$$setupUI$$$();
        this.myDefaultRightMargin = settings.getDefaultRightMargin();
        this.myDefaultGeneralCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RightMarginForm.this.myDefaultGeneralCheckBox.isSelected()) {
                    RightMarginForm.this.myRightMarginField.setText(Integer.toString(RightMarginForm.this.myDefaultRightMargin));
                    RightMarginForm.this.myRightMarginField.setEnabled(false);
                } else {
                    RightMarginForm.this.myRightMarginField.setEnabled(true);
                }
            }
        });
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "reset"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        if (langSettings != settings && langSettings.RIGHT_MARGIN >= 0) {
            this.myDefaultGeneralCheckBox.setSelected(false);
            this.myRightMarginField.setText(Integer.toString(langSettings.RIGHT_MARGIN));
        } else {
            this.myDefaultGeneralCheckBox.setSelected(true);
            this.myRightMarginField.setText(Integer.toString(settings.getDefaultRightMargin()));
            if (langSettings == settings) {
                this.myDefaultGeneralCheckBox.setEnabled(false);
                this.myRightMarginField.setEnabled(false);
            }
        }
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "apply"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        if (langSettings != settings) {
            langSettings.RIGHT_MARGIN = this.myDefaultGeneralCheckBox.isSelected() ? -1 : this.getFieldRightMargin(settings.getDefaultRightMargin());
        }
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "isModified"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        if (this.myDefaultGeneralCheckBox.isSelected()) {
            return langSettings.RIGHT_MARGIN >= 0;
        }
        return langSettings.RIGHT_MARGIN != this.getFieldRightMargin(settings.getDefaultRightMargin());
    }

    private int getFieldRightMargin(int fallBackValue) {
        String strValue = this.myRightMarginField.getText();
        if (!strValue.trim().isEmpty()) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                this.myRightMarginField.setText(Integer.toString(fallBackValue));
            }
        }
        return fallBackValue;
    }

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.right.margin.columns"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRightMarginField = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(2);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myDefaultGeneralCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.default.general"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

