/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontPanelFactoryEx;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.ConsoleFontOptions;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.FileStatusColorsPageFactory;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.application.options.colors.ScopeColorsPageFactory;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.settings.DiffOptionsPanel;
import com.intellij.openapi.diff.impl.settings.DiffPreviewPanel;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontOptions
extends SearchableConfigurable.Parent.Abstract
implements EditorOptionsProvider {
    public static final String ID = "reference.settingsdialog.IDE.editor.colors";
    private HashMap<String, MyColorScheme> mySchemes;
    private MyColorScheme mySelectedScheme;
    public static final String DIFF_GROUP = ApplicationBundle.message((String)"title.diff", (Object[])new Object[0]);
    public static final String FILE_STATUS_GROUP = ApplicationBundle.message((String)"title.file.status", (Object[])new Object[0]);
    public static final String SCOPES_GROUP = ApplicationBundle.message((String)"title.scope.based", (Object[])new Object[0]);
    private boolean mySomeSchemesDeleted = false;
    private Map<ColorAndFontPanelFactory, InnerSearchableConfigurable> mySubPanelFactories;
    private SchemesPanel myRootSchemesPanel;
    private boolean myInitResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertChangesCompleted = false;
    private boolean myApplyCompleted = false;
    private boolean myDisposeCompleted = false;
    private final Disposable myDisposable = Disposer.newDisposable();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.colors.ColorAndFontOptions");
    private boolean myIsReset = false;

    public boolean isModified() {
        boolean listModified = this.isSchemeListModified();
        boolean schemeModified = this.isSomeSchemeModified();
        if (listModified || schemeModified) {
            this.myApplyCompleted = false;
        }
        return listModified;
    }

    private boolean isSchemeListModified() {
        if (this.mySomeSchemesDeleted) {
            return true;
        }
        if (!this.mySelectedScheme.getName().equals(EditorColorsManager.getInstance().getGlobalScheme().getName())) {
            return true;
        }
        for (MyColorScheme scheme : this.mySchemes.values()) {
            if (!scheme.isNew()) continue;
            return true;
        }
        return false;
    }

    private boolean isSomeSchemeModified() {
        for (MyColorScheme scheme : this.mySchemes.values()) {
            if (!scheme.isModified()) continue;
            return true;
        }
        return false;
    }

    public EditorColorsScheme selectScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions", "selectScheme"));
        }
        this.mySelectedScheme = this.getScheme(name);
        return this.mySelectedScheme;
    }

    private MyColorScheme getScheme(String name) {
        return (MyColorScheme)this.mySchemes.get((Object)name);
    }

    public EditorColorsScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public EditorColorsScheme getOriginalSelectedScheme() {
        return this.mySelectedScheme == null ? null : this.mySelectedScheme.getOriginalScheme();
    }

    public EditorSchemeAttributeDescriptor[] getCurrentDescriptions() {
        return this.mySelectedScheme.getDescriptors();
    }

    public static boolean isReadOnly(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "isReadOnly"));
        }
        return ((MyColorScheme)scheme).isReadOnly();
    }

    @NotNull
    public String[] getSchemeNames() {
        ArrayList schemes = new ArrayList(this.mySchemes.values());
        Collections.sort(schemes, new Comparator<MyColorScheme>(){

            @Override
            public int compare(@NotNull MyColorScheme o1, @NotNull MyColorScheme o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/application/options/colors/ColorAndFontOptions$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/application/options/colors/ColorAndFontOptions$1", "compare"));
                }
                if (ColorAndFontOptions.isReadOnly(o1) && !ColorAndFontOptions.isReadOnly(o2)) {
                    return -1;
                }
                if (!ColorAndFontOptions.isReadOnly(o1) && ColorAndFontOptions.isReadOnly(o2)) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        ArrayList<String> names = new ArrayList<String>(schemes.size());
        for (MyColorScheme scheme : schemes) {
            names.add(scheme.getName());
        }
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getSchemeNames"));
        }
        return stringArray;
    }

    @NotNull
    public Collection<EditorColorsScheme> getSchemes() {
        ArrayList<EditorColorsScheme> arrayList = new ArrayList<EditorColorsScheme>(this.mySchemes.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getSchemes"));
        }
        return arrayList;
    }

    public void saveSchemeAs(String name) {
        MyColorScheme scheme = this.mySelectedScheme;
        if (scheme == null) {
            return;
        }
        EditorColorsScheme clone = (EditorColorsScheme)scheme.getOriginalScheme().clone();
        scheme.apply(clone);
        clone.setName(name);
        MyColorScheme newScheme = new MyColorScheme(clone);
        ColorAndFontOptions.initScheme(newScheme);
        newScheme.setIsNew();
        this.mySchemes.put((Object)name, (Object)newScheme);
        this.selectScheme(newScheme.getName());
        this.resetSchemesCombo(null);
    }

    public void addImportedScheme(@NotNull EditorColorsScheme imported) {
        if (imported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imported", "com/intellij/application/options/colors/ColorAndFontOptions", "addImportedScheme"));
        }
        MyColorScheme newScheme = new MyColorScheme(imported);
        ColorAndFontOptions.initScheme(newScheme);
        this.mySchemes.put((Object)imported.getName(), (Object)newScheme);
        this.selectScheme(newScheme.getName());
        this.resetSchemesCombo(null);
    }

    public void removeScheme(String name) {
        if (this.mySelectedScheme.getName().equals(name)) {
            this.selectScheme("Default");
        }
        boolean deletedNewlyCreated = false;
        MyColorScheme toDelete = (MyColorScheme)this.mySchemes.get((Object)name);
        if (toDelete != null) {
            deletedNewlyCreated = toDelete.isNew();
        }
        this.mySchemes.remove((Object)name);
        this.resetSchemesCombo(null);
        this.mySomeSchemesDeleted = this.mySomeSchemesDeleted || !deletedNewlyCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (this.myApplyCompleted) {
            return;
        }
        try {
            int ok;
            EditorColorsManager myColorsManager = EditorColorsManager.getInstance();
            myColorsManager.removeAllSchemes();
            for (MyColorScheme scheme : this.mySchemes.values()) {
                if (scheme.isDefault()) continue;
                scheme.apply();
                myColorsManager.addColorsScheme(scheme.getOriginalScheme());
            }
            EditorColorsScheme originalScheme = this.mySelectedScheme.getOriginalScheme();
            myColorsManager.setGlobalScheme(originalScheme);
            if (originalScheme != null && "Darcula".equals(originalScheme.getName()) && !UIUtil.isUnderDarcula() && (ok = Messages.showYesNoDialog((String)"Darcula color scheme has been set for editors. Would you like to set Darcula as default Look and Feel?", (String)"Darcula Look and Feel", (Icon)Messages.getQuestionIcon())) == 0) {
                LafManager.getInstance().setCurrentLookAndFeel((UIManager.LookAndFeelInfo)new DarculaLookAndFeelInfo());
                DarculaInstaller.install();
            }
            this.reset();
        }
        finally {
            this.myApplyCompleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSchemesCombo(Object source) {
        this.myIsReset = true;
        try {
            this.myRootSchemesPanel.resetSchemesCombo(source);
            if (this.mySubPanelFactories != null) {
                for (NewColorAndFontPanel subPartialConfigurable : this.getPanels()) {
                    subPartialConfigurable.reset(source);
                }
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public JComponent createComponent() {
        if (this.myRootSchemesPanel == null) {
            this.ensureSchemesPanel();
        }
        return this.myRootSchemesPanel;
    }

    public boolean hasOwnContent() {
        return true;
    }

    @NotNull
    public Configurable[] buildConfigurables() {
        this.myDisposeCompleted = false;
        this.initAll();
        List<ColorAndFontPanelFactory> panelFactories = this.createPanelFactories();
        ArrayList<InnerSearchableConfigurable> result = new ArrayList<InnerSearchableConfigurable>();
        this.mySubPanelFactories = new LinkedHashMap<ColorAndFontPanelFactory, InnerSearchableConfigurable>(panelFactories.size());
        for (ColorAndFontPanelFactory panelFactory : panelFactories) {
            this.mySubPanelFactories.put(panelFactory, new InnerSearchableConfigurable(panelFactory));
        }
        result.addAll(new ArrayList<InnerSearchableConfigurable>(this.mySubPanelFactories.values()));
        Configurable[] configurableArray = result.toArray(new Configurable[result.size()]);
        if (configurableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "buildConfigurables"));
        }
        return configurableArray;
    }

    @NotNull
    private Set<NewColorAndFontPanel> getPanels() {
        HashSet<NewColorAndFontPanel> result = new HashSet<NewColorAndFontPanel>();
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            NewColorAndFontPanel panel = configurable.getSubPanelIfInitialized();
            if (panel == null) continue;
            result.add(panel);
        }
        HashSet<NewColorAndFontPanel> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getPanels"));
        }
        return hashSet;
    }

    protected List<ColorAndFontPanelFactory> createPanelFactories() {
        ColorSettingsPage[] pages;
        ArrayList<ColorAndFontPanelFactory> result = new ArrayList<ColorAndFontPanelFactory>();
        result.add(new FontConfigurableFactory());
        ArrayList<ColorAndFontPanelFactoryEx> extensions = new ArrayList<ColorAndFontPanelFactoryEx>();
        extensions.add(new ConsoleFontConfigurableFactory());
        for (final ColorSettingsPage page : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            extensions.add(new ColorAndFontPanelFactoryEx(){

                @Override
                @NotNull
                public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                    if (options == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$2", "createPanel"));
                    }
                    SimpleEditorPreview preview = new SimpleEditorPreview(options, page);
                    NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create(preview, page.getDisplayName(), options, null, page);
                    if (newColorAndFontPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$2", "createPanel"));
                    }
                    return newColorAndFontPanel;
                }

                @Override
                @NotNull
                public String getPanelDisplayName() {
                    String string = page.getDisplayName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$2", "getPanelDisplayName"));
                    }
                    return string;
                }

                public DisplayPriority getPriority() {
                    if (page instanceof DisplayPrioritySortable) {
                        return ((DisplayPrioritySortable)page).getPriority();
                    }
                    return DisplayPriority.LANGUAGE_SETTINGS;
                }
            });
        }
        Collections.addAll(extensions, Extensions.getExtensions(ColorAndFontPanelFactory.EP_NAME));
        Collections.sort(extensions, new Comparator<ColorAndFontPanelFactory>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int compare(ColorAndFontPanelFactory f1, ColorAndFontPanelFactory f2) {
                if (f1 instanceof DisplayPrioritySortable) {
                    if (!(f2 instanceof DisplayPrioritySortable)) return 1;
                    int result = ((DisplayPrioritySortable)f1).getPriority().compareTo((Enum)((DisplayPrioritySortable)f2).getPriority());
                    if (result == 0) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
                    return result;
                }
                if (!(f2 instanceof DisplayPrioritySortable)) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
                return -1;
            }
        });
        result.addAll(extensions);
        result.add(new DiffColorsPageFactory());
        result.add(new FileStatusColorsPageFactory());
        result.add(new ScopeColorsPageFactory());
        return result;
    }

    private void initAll() {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme[] allSchemes = colorsManager.getAllSchemes();
        this.mySchemes = new HashMap();
        for (EditorColorsScheme allScheme : allSchemes) {
            MyColorScheme schemeDelegate = new MyColorScheme(allScheme);
            ColorAndFontOptions.initScheme(schemeDelegate);
            this.mySchemes.put((Object)schemeDelegate.getName(), (Object)schemeDelegate);
        }
        this.mySelectedScheme = (MyColorScheme)this.mySchemes.get((Object)EditorColorsManager.getInstance().getGlobalScheme().getName());
        assert (this.mySelectedScheme != null) : EditorColorsManager.getInstance().getGlobalScheme().getName() + "; myschemes=" + this.mySchemes;
    }

    private static void initScheme(@NotNull MyColorScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initScheme"));
        }
        ArrayList<EditorSchemeAttributeDescriptor> descriptions = new ArrayList<EditorSchemeAttributeDescriptor>();
        ColorAndFontOptions.initPluggedDescriptions(descriptions, scheme);
        ColorAndFontOptions.initDiffDescriptors(descriptions, scheme);
        ColorAndFontOptions.initFileStatusDescriptors(descriptions, scheme);
        ColorAndFontOptions.initScopesDescriptors(descriptions, scheme);
        scheme.setDescriptors(descriptions.toArray(new EditorSchemeAttributeDescriptor[descriptions.size()]));
    }

    private static void initPluggedDescriptions(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme) {
        ColorSettingsPage[] pages;
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initPluggedDescriptions"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initPluggedDescriptions"));
        }
        for (ColorSettingsPage colorSettingsPage : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)colorSettingsPage, descriptions, scheme);
        }
        for (ColorSettingsPage colorSettingsPage : (ColorAndFontDescriptorsProvider[])Extensions.getExtensions((ExtensionPointName)ColorAndFontDescriptorsProvider.EP_NAME)) {
            ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)colorSettingsPage, descriptions, scheme);
        }
    }

    private static void initDescriptions(@NotNull ColorAndFontDescriptorsProvider provider, @NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme) {
        ColorDescriptor[] colorDescriptors;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/application/options/colors/ColorAndFontOptions", "initDescriptions"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initDescriptions"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initDescriptions"));
        }
        String group = provider.getDisplayName();
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors(provider);
        for (AttributesDescriptor descriptor : attributeDescriptors) {
            ColorAndFontOptions.addSchemedDescription(descriptions, descriptor.getDisplayName(), group, descriptor.getKey(), scheme, null, null);
        }
        for (ColorDescriptor descriptor : colorDescriptors = provider.getColorDescriptors()) {
            ColorKey back = descriptor.getKind() == ColorDescriptor.Kind.BACKGROUND ? descriptor.getKey() : null;
            ColorKey fore = descriptor.getKind() == ColorDescriptor.Kind.FOREGROUND ? descriptor.getKey() : null;
            ColorAndFontOptions.addEditorSettingDescription(descriptions, descriptor.getDisplayName(), group, back, fore, scheme);
        }
    }

    private static void initDiffDescriptors(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme) {
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initDiffDescriptors"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initDiffDescriptors"));
        }
        DiffOptionsPanel.addSchemeDescriptions(descriptions, scheme);
    }

    private static void initFileStatusDescriptors(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, MyColorScheme scheme) {
        FileStatus[] statuses;
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initFileStatusDescriptors"));
        }
        for (FileStatus fileStatus : statuses = FileStatusFactory.getInstance().getAllFileStatuses()) {
            ColorAndFontOptions.addEditorSettingDescription(descriptions, fileStatus.getText(), FILE_STATUS_GROUP, null, fileStatus.getColorKey(), scheme);
        }
    }

    private static void initScopesDescriptors(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme) {
        Project[] projects;
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/application/options/colors/ColorAndFontOptions", "initScopesDescriptors"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "initScopesDescriptors"));
        }
        THashSet namedScopes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<NamedScope, NamedScopesHolder>>(){

            public int computeHashCode(@NotNull Pair<NamedScope, NamedScopesHolder> object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/application/options/colors/ColorAndFontOptions$4", "computeHashCode"));
                }
                return ((NamedScope)object.getFirst()).getName().hashCode();
            }

            public boolean equals(@NotNull Pair<NamedScope, NamedScopesHolder> o1, @NotNull Pair<NamedScope, NamedScopesHolder> o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/application/options/colors/ColorAndFontOptions$4", "equals"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/application/options/colors/ColorAndFontOptions$4", "equals"));
                }
                return ((NamedScope)o1.getFirst()).getName().equals(((NamedScope)o2.getFirst()).getName());
            }
        });
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)project);
            List<Pair<NamedScope, NamedScopesHolder>> cachedScopes = validationManager.getScopeBasedHighlightingCachedScopes();
            namedScopes.addAll(cachedScopes);
        }
        ArrayList list = new ArrayList(namedScopes);
        Collections.sort(list, new Comparator<Pair<NamedScope, NamedScopesHolder>>(){

            @Override
            public int compare(@NotNull Pair<NamedScope, NamedScopesHolder> o1, @NotNull Pair<NamedScope, NamedScopesHolder> o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/application/options/colors/ColorAndFontOptions$5", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/application/options/colors/ColorAndFontOptions$5", "compare"));
                }
                return ((NamedScope)o1.getFirst()).getName().compareToIgnoreCase(((NamedScope)o2.getFirst()).getName());
            }
        });
        for (Pair pair : list) {
            NamedScope namedScope = (NamedScope)pair.getFirst();
            String name = namedScope.getName();
            TextAttributesKey textAttributesKey = ScopeAttributesUtil.getScopeTextAttributeKey(name);
            if (scheme.getAttributes(textAttributesKey) == null) {
                scheme.setAttributes(textAttributesKey, new TextAttributes());
            }
            NamedScopesHolder holder = (NamedScopesHolder)pair.getSecond();
            PackageSet value = namedScope.getValue();
            String toolTip = holder.getDisplayName() + (value == null ? "" : ": " + value.getText());
            ColorAndFontOptions.addSchemedDescription(descriptions, name, SCOPES_GROUP, textAttributesKey, scheme, holder.getIcon(), toolTip);
        }
    }

    private static void addEditorSettingDescription(@NotNull List<EditorSchemeAttributeDescriptor> array, String name, String group, @Nullable ColorKey backgroundKey, @Nullable ColorKey foregroundKey, EditorColorsScheme scheme) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/application/options/colors/ColorAndFontOptions", "addEditorSettingDescription"));
        }
        String type = null;
        if (foregroundKey != null) {
            type = foregroundKey.getExternalName();
        } else if (backgroundKey != null) {
            type = backgroundKey.getExternalName();
        }
        EditorSettingColorDescription descr = new EditorSettingColorDescription(name, group, backgroundKey, foregroundKey, type, scheme);
        array.add(descr);
    }

    private static void addSchemedDescription(@NotNull List<EditorSchemeAttributeDescriptor> array, String name, String group, @NotNull TextAttributesKey key, @NotNull MyColorScheme scheme, Icon icon, String toolTip) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/application/options/colors/ColorAndFontOptions", "addSchemedDescription"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/application/options/colors/ColorAndFontOptions", "addSchemedDescription"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions", "addSchemedDescription"));
        }
        SchemeTextAttributesDescription descr = new SchemeTextAttributesDescription(name, group, key, scheme, icon, toolTip);
        array.add(descr);
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertChanges() {
        if (this.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertChangesCompleted = false;
        }
        if (!this.myRevertChangesCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertChangesCompleted = true;
            }
        }
    }

    private void resetImpl() {
        this.mySomeSchemesDeleted = false;
        this.initAll();
        this.resetSchemesCombo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                super.reset();
                if (this.myInitResetCompleted) return;
                this.ensureSchemesPanel();
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myInitResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revertChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetFromChild() {
        if (!this.myInitResetCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myInitResetCompleted = true;
            }
        }
    }

    private void ensureSchemesPanel() {
        if (this.myRootSchemesPanel == null) {
            this.myRootSchemesPanel = new SchemesPanel(this);
            this.myRootSchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                @Override
                public void schemeChanged(Object source) {
                    if (!ColorAndFontOptions.this.myIsReset) {
                        ColorAndFontOptions.this.resetSchemesCombo(source);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeUIResources() {
        block6: {
            try {
                if (this.myDisposeCompleted) break block6;
                try {
                    super.disposeUIResources();
                    Disposer.dispose((Disposable)this.myDisposable);
                }
                finally {
                    this.myDisposeCompleted = true;
                }
            }
            finally {
                this.mySubPanelFactories = null;
                this.myInitResetCompleted = false;
                this.myInitResetInvoked = false;
                this.myRevertChangesCompleted = false;
                this.myApplyCompleted = false;
                this.myRootSchemesPanel = null;
            }
        }
    }

    public boolean currentSchemeIsReadOnly() {
        return ColorAndFontOptions.isReadOnly(this.mySelectedScheme);
    }

    public boolean currentSchemeIsShared() {
        return ColorSettingsUtil.isSharedScheme(this.mySelectedScheme);
    }

    @NotNull
    public String getHelpTopic() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getHelpTopic"));
        }
        return ID;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public InnerSearchableConfigurable findSubConfigurable(@NotNull Class pageClass) {
        if (pageClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageClass", "com/intellij/application/options/colors/ColorAndFontOptions", "findSubConfigurable"));
        }
        if (this.mySubPanelFactories == null) {
            this.buildConfigurables();
        }
        for (Map.Entry<ColorAndFontPanelFactory, InnerSearchableConfigurable> entry : this.mySubPanelFactories.entrySet()) {
            if (!pageClass.isInstance(entry.getValue().createPanel().getSettingsPage())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public NewColorAndFontPanel findPage(String pageName) {
        if (this.mySubPanelFactories == null) {
            this.buildConfigurables();
        }
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            if (!configurable.getDisplayName().equals(pageName)) continue;
            return configurable.createPanel();
        }
        return null;
    }

    private class InnerSearchableConfigurable
    implements SearchableConfigurable,
    OptionsContainingConfigurable,
    Configurable.NoScroll {
        private NewColorAndFontPanel mySubPanel;
        private boolean mySubInitInvoked;
        @NotNull
        private final ColorAndFontPanelFactory myFactory;

        private InnerSearchableConfigurable(ColorAndFontPanelFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "<init>"));
            }
            this.mySubInitInvoked = false;
            this.myFactory = factory;
        }

        @NotNull
        @Nls
        public String getDisplayName() {
            String string = this.myFactory.getPanelDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "getDisplayName"));
            }
            return string;
        }

        public NewColorAndFontPanel getSubPanelIfInitialized() {
            return this.mySubPanel;
        }

        private NewColorAndFontPanel createPanel() {
            if (this.mySubPanel == null) {
                this.mySubPanel = this.myFactory.createPanel(ColorAndFontOptions.this);
                this.mySubPanel.reset(this);
                this.mySubPanel.addSchemesListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void schemeChanged(Object source) {
                        if (!ColorAndFontOptions.this.myIsReset) {
                            ColorAndFontOptions.this.resetSchemesCombo(source);
                        }
                    }
                });
                this.mySubPanel.addDescriptionListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void fontChanged() {
                        for (NewColorAndFontPanel panel : ColorAndFontOptions.this.getPanels()) {
                            panel.updatePreview();
                        }
                    }
                });
            }
            return this.mySubPanel;
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return this.createPanel().getPanel();
        }

        public boolean isModified() {
            this.createPanel();
            for (MyColorScheme scheme : ColorAndFontOptions.this.mySchemes.values()) {
                if (this.mySubPanel.containsFontOptions()) {
                    if (!scheme.isFontModified() && !scheme.isConsoleFontModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
                for (EditorSchemeAttributeDescriptor descriptor : scheme.getDescriptors()) {
                    if (!this.mySubPanel.contains(descriptor) || !descriptor.isModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
            }
            return false;
        }

        public void apply() throws ConfigurationException {
            ColorAndFontOptions.this.apply();
        }

        public void reset() {
            if (!this.mySubInitInvoked) {
                if (!ColorAndFontOptions.this.myInitResetCompleted) {
                    ColorAndFontOptions.this.resetFromChild();
                }
                this.mySubInitInvoked = true;
            } else {
                ColorAndFontOptions.this.revertChanges();
            }
        }

        public void disposeUIResources() {
            if (this.mySubPanel != null) {
                this.mySubPanel.disposeUIResources();
                this.mySubPanel = null;
            }
        }

        @NotNull
        public String getId() {
            String string = ColorAndFontOptions.this.getId() + "." + this.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "getId"));
            }
            return string;
        }

        public Runnable enableSearch(String option) {
            return this.createPanel().showOption(option);
        }

        @Override
        @NotNull
        public Set<String> processListOptions() {
            Set<String> set = this.createPanel().processListOptions();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "processListOptions"));
            }
            return set;
        }

        @NotNull
        @NonNls
        public String toString() {
            String string = "Color And Fonts for " + this.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable", "toString"));
            }
            return string;
        }
    }

    private static class MyColorScheme
    extends EditorColorsSchemeImpl {
        private EditorSchemeAttributeDescriptor[] myDescriptors;
        private String myName;
        private boolean myIsNew;

        private MyColorScheme(@NotNull EditorColorsScheme parentScheme) {
            if (parentScheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScheme", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "<init>"));
            }
            super(parentScheme, DefaultColorSchemesManager.getInstance());
            this.myIsNew = false;
            parentScheme.getFontPreferences().copyTo(this.getFontPreferences());
            this.setLineSpacing(parentScheme.getLineSpacing());
            parentScheme.getConsoleFontPreferences().copyTo(this.getConsoleFontPreferences());
            this.setConsoleLineSpacing(parentScheme.getConsoleLineSpacing());
            this.setQuickDocFontSize(parentScheme.getQuickDocFontSize());
            this.myName = parentScheme.getName();
            if (parentScheme instanceof ExternalizableScheme) {
                this.getExternalInfo().copy(((ExternalizableScheme)parentScheme).getExternalInfo());
            }
            this.initFonts();
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "setName"));
            }
            this.myName = name;
        }

        public void setDescriptors(EditorSchemeAttributeDescriptor[] descriptors) {
            this.myDescriptors = descriptors;
        }

        public EditorSchemeAttributeDescriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        public boolean isDefault() {
            return this.myParentScheme instanceof DefaultColorsScheme;
        }

        public boolean isReadOnly() {
            return this.myParentScheme instanceof ReadOnlyColorsScheme;
        }

        public boolean isModified() {
            if (this.isFontModified() || this.isConsoleFontModified()) {
                return true;
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                return true;
            }
            return false;
        }

        private boolean isFontModified() {
            if (!this.getFontPreferences().equals((Object)this.myParentScheme.getFontPreferences())) {
                return true;
            }
            if (this.getLineSpacing() != this.myParentScheme.getLineSpacing()) {
                return true;
            }
            return this.getQuickDocFontSize() != this.myParentScheme.getQuickDocFontSize();
        }

        private boolean isConsoleFontModified() {
            if (!this.getConsoleFontPreferences().equals((Object)this.myParentScheme.getConsoleFontPreferences())) {
                return true;
            }
            return this.getConsoleLineSpacing() != this.myParentScheme.getConsoleLineSpacing();
        }

        public void apply() {
            this.apply(this.myParentScheme);
        }

        public void apply(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "apply"));
            }
            scheme.setFontPreferences(this.getFontPreferences());
            scheme.setLineSpacing(this.myLineSpacing);
            scheme.setQuickDocFontSize(this.getQuickDocFontSize());
            scheme.setConsoleFontPreferences(this.getConsoleFontPreferences());
            scheme.setConsoleLineSpacing(this.getConsoleLineSpacing());
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                descriptor.apply(scheme);
            }
        }

        @Override
        public Object clone() {
            return null;
        }

        public EditorColorsScheme getOriginalScheme() {
            return this.myParentScheme;
        }

        public void setIsNew() {
            this.myIsNew = true;
        }

        public boolean isNew() {
            return this.myIsNew;
        }

        @Override
        @NotNull
        public String toString() {
            String string = "temporary scheme for " + this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme", "toString"));
            }
            return string;
        }
    }

    private static class EditorSettingColorDescription
    extends ColorAndFontDescription {
        private GetSetColor myGetSetForeground;
        private GetSetColor myGetSetBackground;

        private EditorSettingColorDescription(String name, String group, ColorKey backgroundKey, ColorKey foregroundKey, String type, EditorColorsScheme scheme) {
            super(name, group, type, scheme, null, null);
            if (backgroundKey != null) {
                this.myGetSetBackground = new GetSetColor(backgroundKey, scheme);
            }
            if (foregroundKey != null) {
                this.myGetSetForeground = new GetSetColor(foregroundKey, scheme);
            }
            this.initCheckedStatus();
        }

        @Override
        public int getFontType() {
            return 0;
        }

        @Override
        public void setFontType(int type) {
        }

        @Override
        public Color getExternalEffectColor() {
            return null;
        }

        @Override
        public void setExternalEffectColor(Color color) {
        }

        @Override
        public void setExternalEffectType(EffectType type) {
        }

        @Override
        @NotNull
        public EffectType getExternalEffectType() {
            EffectType effectType = EffectType.LINE_UNDERSCORE;
            if (effectType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$EditorSettingColorDescription", "getExternalEffectType"));
            }
            return effectType;
        }

        @Override
        public Color getExternalForeground() {
            if (this.myGetSetForeground == null) {
                return null;
            }
            return this.myGetSetForeground.getColor();
        }

        @Override
        public void setExternalForeground(Color col) {
            if (this.myGetSetForeground == null) {
                return;
            }
            this.myGetSetForeground.setColor(col);
        }

        @Override
        public Color getExternalBackground() {
            if (this.myGetSetBackground == null) {
                return null;
            }
            return this.myGetSetBackground.getColor();
        }

        @Override
        public void setExternalBackground(Color col) {
            if (this.myGetSetBackground == null) {
                return;
            }
            this.myGetSetBackground.setColor(col);
        }

        @Override
        public Color getExternalErrorStripe() {
            return null;
        }

        @Override
        public void setExternalErrorStripe(Color col) {
        }

        @Override
        public boolean isFontEnabled() {
            return false;
        }

        @Override
        public boolean isForegroundEnabled() {
            return this.myGetSetForeground != null;
        }

        @Override
        public boolean isBackgroundEnabled() {
            return this.myGetSetBackground != null;
        }

        @Override
        public boolean isEffectsColorEnabled() {
            return false;
        }

        @Override
        public boolean isModified() {
            return this.myGetSetBackground != null && this.myGetSetBackground.isModified() || this.myGetSetForeground != null && this.myGetSetForeground.isModified();
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
            if (this.myGetSetBackground != null) {
                this.myGetSetBackground.apply(scheme);
            }
            if (this.myGetSetForeground != null) {
                this.myGetSetForeground.apply(scheme);
            }
        }
    }

    private static class GetSetColor {
        private final ColorKey myKey;
        private final EditorColorsScheme myScheme;
        private boolean isModified = false;
        private Color myColor;

        private GetSetColor(ColorKey key, EditorColorsScheme scheme) {
            this.myKey = key;
            this.myScheme = scheme;
            this.myColor = this.myScheme.getColor(this.myKey);
        }

        public Color getColor() {
            return this.myColor;
        }

        public void setColor(Color col) {
            if (this.getColor() == null || !this.getColor().equals(col)) {
                this.isModified = true;
                this.myColor = col;
            }
        }

        public void apply(EditorColorsScheme scheme) {
            if (scheme == null) {
                scheme = this.myScheme;
            }
            scheme.setColor(this.myKey, this.myColor);
        }

        public boolean isModified() {
            return this.isModified;
        }
    }

    private static class SchemeTextAttributesDescription
    extends TextAttributesDescription {
        @NotNull
        private final TextAttributes myAttributesToApply;
        @NotNull
        private final TextAttributesKey key;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorSettingsPage, AttributesDescriptor> myBaseAttributeDescriptor;
        private boolean myIsInheritedInitial;

        private SchemeTextAttributesDescription(String name, String group, @NotNull TextAttributesKey key, @NotNull MyColorScheme scheme, Icon icon, String toolTip) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "<init>"));
            }
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "<init>"));
            }
            super(name, group, SchemeTextAttributesDescription.getInitialAttributes(scheme, key).clone(), key, scheme, icon, toolTip);
            this.myIsInheritedInitial = false;
            this.key = key;
            this.myAttributesToApply = SchemeTextAttributesDescription.getInitialAttributes(scheme, key);
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null) {
                this.myFallbackAttributes = scheme.getAttributes(fallbackKey);
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getAttributeDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    this.myBaseAttributeDescriptor = new Pair(null, (Object)new AttributesDescriptor(fallbackKey.getExternalName(), fallbackKey));
                }
            }
            this.myIsInheritedInitial = this.isInherited(scheme);
            this.setInherited(this.myIsInheritedInitial);
            this.initCheckedStatus();
        }

        @NotNull
        private static TextAttributes getInitialAttributes(@NotNull MyColorScheme scheme, @NotNull TextAttributesKey key) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "getInitialAttributes"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "getInitialAttributes"));
            }
            TextAttributes attributes = scheme.getAttributes(key);
            TextAttributes textAttributes = attributes != null ? attributes : new TextAttributes();
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "getInitialAttributes"));
            }
            return textAttributes;
        }

        private boolean isInherited(@NotNull MyColorScheme scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription", "isInherited"));
            }
            TextAttributes attributes = scheme.getAttributes(this.key);
            TextAttributesKey fallbackKey = this.key.getFallbackAttributeKey();
            if (fallbackKey != null && !scheme.containsKey(this.key)) {
                TextAttributes fallbackAttributes = scheme.getAttributes(fallbackKey);
                if (attributes != null && attributes == fallbackAttributes) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
            if (scheme == null) {
                scheme = this.getScheme();
            }
            scheme.setAttributes(this.key, this.isInherited() ? new TextAttributes() : this.getTextAttributes());
        }

        @Override
        public boolean isModified() {
            return !Comparing.equal((Object)this.myAttributesToApply, (Object)this.getTextAttributes()) || this.myIsInheritedInitial != this.isInherited();
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        @Override
        @Nullable
        public Pair<ColorSettingsPage, AttributesDescriptor> getBaseAttributeDescriptor() {
            return this.myBaseAttributeDescriptor;
        }

        @Override
        public void setInherited(boolean isInherited) {
            super.setInherited(isInherited);
        }
    }

    private class DiffColorsPageFactory
    implements ColorAndFontPanelFactory {
        private DiffColorsPageFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            PreviewPanel previewPanel;
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$DiffColorsPageFactory", "createPanel"));
            }
            final DiffOptionsPanel optionsPanel = new DiffOptionsPanel(options);
            SchemesPanel schemesPanel = new SchemesPanel(options);
            try {
                final DiffPreviewPanel diffPreviewPanel = new DiffPreviewPanel(ColorAndFontOptions.this.myDisposable);
                diffPreviewPanel.setMergeRequest(null);
                schemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void schemeChanged(Object source) {
                        diffPreviewPanel.setColorScheme(ColorAndFontOptions.this.getSelectedScheme());
                        optionsPanel.updateOptionsList();
                        diffPreviewPanel.updateView();
                    }
                });
                previewPanel = diffPreviewPanel;
            }
            catch (FilesTooBigForDiffException e) {
                LOG.info((Throwable)e);
                previewPanel = new PreviewPanel.Empty();
            }
            NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, DIFF_GROUP, null, null);
            if (newColorAndFontPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$DiffColorsPageFactory", "createPanel"));
            }
            return newColorAndFontPanel;
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            String string = DIFF_GROUP;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$DiffColorsPageFactory", "getPanelDisplayName"));
            }
            return string;
        }
    }

    private static class ConsoleFontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private ConsoleFontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "createPanel"));
            }
            FontEditorPreview previewPanel = new FontEditorPreview(options, false){

                @Override
                protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
                    return ConsoleViewUtil.updateConsoleColorScheme(selectedScheme);
                }
            };
            NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(new SchemesPanel(options), new ConsoleFontOptions(options), previewPanel, "Font", null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
            if (newColorAndFontPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "createPanel"));
            }
            return newColorAndFontPanel;
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            if ("Console Font" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "getPanelDisplayName"));
            }
            return "Console Font";
        }

        @NotNull
        public DisplayPriority getPriority() {
            DisplayPriority displayPriority = DisplayPriority.COMMON_SETTINGS;
            if (displayPriority == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory", "getPriority"));
            }
            return displayPriority;
        }
    }

    private static class FontConfigurableFactory
    implements ColorAndFontPanelFactory {
        private FontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory", "createPanel"));
            }
            FontEditorPreview previewPanel = new FontEditorPreview(options, true);
            NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(new SchemesPanel(options), new FontOptions(options), previewPanel, "Font", null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
            if (newColorAndFontPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory", "createPanel"));
            }
            return newColorAndFontPanel;
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            if ("Font" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory", "getPanelDisplayName"));
            }
            return "Font";
        }
    }
}

