/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.Java15CompletionData;
import com.intellij.codeInsight.completion.JavaCompletionData;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;

public class Java18CompletionData
extends Java15CompletionData {
    private static final PsiElementPattern<PsiElement, ?> AFTER_DOUBLE_COLON = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaTokenType.DOUBLE_COLON));

    @Override
    public void fillCompletions(CompletionParameters parameters, CompletionResultSet result) {
        PsiElement position = parameters.getPosition();
        if (!Java18CompletionData.inComment(position)) {
            if (AFTER_DOUBLE_COLON.accepts((Object)position)) {
                PsiMethodReferenceExpression parent = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiMethodReferenceExpression.class);
                TailType tail = parent != null && !LambdaHighlightingUtil.insertSemicolon(parent.getParent()) ? TailType.SEMICOLON : TailType.NONE;
                result.addElement((LookupElement)new JavaCompletionData.OverrideableSpace(Java18CompletionData.createKeyword(position, "new"), tail));
                return;
            }
            if (Java18CompletionData.isSuitableForClass(position)) {
                for (PsiElement scope = position.getParent(); scope != null && !(scope instanceof PsiFile); scope = scope.getParent()) {
                    if (!(scope instanceof PsiClass) || !((PsiClass)scope).isInterface()) continue;
                    result.addElement((LookupElement)new JavaCompletionData.OverrideableSpace(Java18CompletionData.createKeyword(position, "default"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                    break;
                }
            }
        }
        super.fillCompletions(parameters, result);
    }

    private static boolean inComment(PsiElement position) {
        return PsiTreeUtil.getParentOfType((PsiElement)position, PsiComment.class, (boolean)false) != null;
    }
}

