/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncreaseLanguageLevelFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + IncreaseLanguageLevelFix.class.getName()));
    private final LanguageLevel myLevel;

    public IncreaseLanguageLevelFix(@NotNull LanguageLevel targetLevel) {
        if (targetLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLevel", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "<init>"));
        }
        this.myLevel = targetLevel;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"set.language.level.to.0", (Object[])new Object[]{this.myLevel.getPresentableText()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"set.language.level", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "getFamilyName"));
        }
        return string;
    }

    private static boolean isJdkSupportsLevel(@Nullable Sdk jdk, @NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "isJdkSupportsLevel"));
        }
        if (jdk == null) {
            return true;
        }
        String versionString = jdk.getVersionString();
        JavaSdkVersion version = versionString == null ? null : JdkVersionUtil.getVersion((String)versionString);
        return version != null && version.getMaxLanguageLevel().isAtLeast(level);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "isAvailable"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        return IncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, this.myLevel);
    }

    private static boolean isLanguageLevelAcceptable(@NotNull Project project, Module module, @NotNull LanguageLevel level) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "isLanguageLevelAcceptable"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "isLanguageLevelAcceptable"));
        }
        return IncreaseLanguageLevelFix.isJdkSupportsLevel(IncreaseLanguageLevelFix.getRelevantJdk(project, module), level);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        LanguageLevel moduleLevel;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "invoke"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        LanguageLevel languageLevel = moduleLevel = module == null ? null : LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        if (moduleLevel != null && IncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, this.myLevel)) {
            final ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLevel);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    rootModel.commit();
                }
            });
        } else {
            LanguageLevelProjectExtension.getInstance((Project)project).setLanguageLevel(this.myLevel);
            ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(EmptyRunnable.INSTANCE, false, true);
        }
    }

    @Nullable
    private static Sdk getRelevantJdk(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix", "getRelevantJdk"));
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk moduleJdk = module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        return moduleJdk == null ? projectJdk : moduleJdk;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

