/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackspaceHandler
extends EditorWriteActionHandler {
    protected final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        if (!this.handleBackspace(editor, dataContext, false)) {
            this.myOriginalHandler.execute(editor, dataContext);
        }
    }

    protected boolean handleBackspace(Editor editor, DataContext dataContext, boolean toWordStart) {
        int injectedOffset;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file == null) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset < 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        char c = chars.charAt(offset);
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(c, editor, file);
        Editor originalEditor = editor;
        if (injectedEditor != editor && BackspaceHandler.isOffsetInsideInjected(injectedEditor, injectedOffset = injectedEditor.getCaretModel().getOffset())) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(injectedEditor.getDocument());
            editor = injectedEditor;
            offset = injectedOffset - 1;
        }
        BackspaceHandlerDelegate[] delegates = (BackspaceHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)BackspaceHandlerDelegate.EP_NAME);
        if (!toWordStart) {
            for (BackspaceHandlerDelegate delegate : delegates) {
                delegate.beforeCharDeleted(c, file, editor);
            }
        }
        FileType fileType = file.getFileType();
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file, editor);
        HighlighterIterator hiterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean wasClosingQuote = quoteHandler != null && quoteHandler.isClosingQuote(hiterator, offset);
        this.myOriginalHandler.execute(originalEditor, dataContext);
        if (!toWordStart) {
            for (BackspaceHandlerDelegate delegate : delegates) {
                if (!delegate.charDeleted(c, file, editor)) continue;
                return true;
            }
        }
        if (offset >= editor.getDocument().getTextLength()) {
            return true;
        }
        chars = editor.getDocument().getCharsSequence();
        if (c == '(' || c == '[' || c == '{') {
            boolean matched;
            char c1 = chars.charAt(offset);
            if (c1 != BackspaceHandler.getRightChar(c)) {
                return true;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            if (!braceMatcher.isLBraceToken(iterator, chars, fileType) && !braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                return true;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen(iterator, iterator.getTokenType(), chars, fileType);
            if (rparenOffset >= 0 && (matched = BraceMatchingUtil.matchBrace(chars, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(rparenOffset), false))) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        } else if (c == '\"' || c == '\'' || c == '`') {
            char c1 = chars.charAt(offset);
            if (c1 != c) {
                return true;
            }
            if (wasClosingQuote) {
                return true;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            if (quoteHandler == null || !quoteHandler.isOpeningQuote(iterator, offset)) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        }
        return true;
    }

    public static char getRightChar(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        assert (false);
        return c;
    }

    private static boolean isOffsetInsideInjected(Editor injectedEditor, int injectedOffset) {
        TextRange rangeToEdit;
        if (injectedOffset == 0 || injectedOffset >= injectedEditor.getDocument().getTextLength()) {
            return false;
        }
        PsiFile injectedFile = ((EditorWindow)injectedEditor).getInjectedFile();
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)injectedFile.getProject());
        List editables = ilm.intersectWithAllEditableFragments(injectedFile, rangeToEdit = new TextRange(injectedOffset - 1, injectedOffset + 1));
        return editables.size() == 1 && ((TextRange)editables.get(0)).equals((Object)rangeToEdit);
    }

    @Nullable
    public static LogicalPosition getBackspaceUnindentPosition(PsiFile file, Editor editor) {
        if (editor.getSelectionModel().hasSelection()) {
            return null;
        }
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        if (caretPos.column == 0) {
            return null;
        }
        if (!BackspaceHandler.isWhitespaceBeforeCaret(editor)) {
            return null;
        }
        int indent = CodeStyleSettingsManager.getSettings((Project)file.getProject()).getIndentOptionsByFile((PsiFile)file).INDENT_SIZE;
        int column = (caretPos.column - 1) / indent * indent;
        if (column < 0) {
            column = 0;
        }
        return new LogicalPosition(caretPos.line, column);
    }

    public static void deleteToTargetPosition(@NotNull Editor editor, @NotNull LogicalPosition pos) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/BackspaceHandler", "deleteToTargetPosition"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/codeInsight/editorActions/BackspaceHandler", "deleteToTargetPosition"));
        }
        int offset = editor.getCaretModel().getOffset();
        int targetOffset = editor.logicalPositionToOffset(pos);
        editor.getSelectionModel().setSelection(targetOffset, offset);
        EditorModificationUtil.deleteSelectedText((Editor)editor);
        editor.getCaretModel().moveToLogicalPosition(pos);
    }

    public static boolean isWhitespaceBeforeCaret(Editor editor) {
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        CharSequence charSeq = editor.getDocument().getCharsSequence();
        for (int pos = 0; pos < caretPos.column; ++pos) {
            char c;
            LogicalPosition checkPos = new LogicalPosition(caretPos.line, pos);
            int offset = editor.logicalPositionToOffset(checkPos);
            if (offset >= charSeq.length() || (c = charSeq.charAt(offset)) == '\t' || c == ' ' || c == '\n') continue;
            return false;
        }
        return true;
    }
}

