/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.CustomPopupFullValueEvaluator;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.rt.debugger.ImageSerializer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImageObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    public ImageObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Image", null, null);
        this.setClassName("java.awt.Image");
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        String res = this.calcToStringLabel(descriptor, evaluationContext, listener);
        if (res != null) {
            return res;
        }
        return super.calcLabel(descriptor, evaluationContext, listener);
    }

    @Override
    @NotNull
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        CustomPopupFullValueEvaluator customPopupFullValueEvaluator = new CustomPopupFullValueEvaluator(" (Show image)", evaluationContext){

            @Override
            protected JComponent createComponent() {
                return new JBScrollPane((Component)new JBLabel((Icon)ImageObjectRenderer.getIcon(this.myEvaluationContext, valueDescriptor.getValue(), "imageToBytes")));
            }
        };
        if (customPopupFullValueEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/ImageObjectRenderer", "getFullValueEvaluator"));
        }
        return customPopupFullValueEvaluator;
    }

    @Nullable
    static ImageIcon getIcon(EvaluationContext evaluationContext, Value obj, String methodName) {
        try {
            Value bytes = ImageObjectRenderer.getImageBytes(evaluationContext, obj, methodName);
            byte[] data = ImageObjectRenderer.readBytes(bytes);
            if (data != null) {
                return new ImageIcon(data);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static Value getImageBytes(EvaluationContext evaluationContext, Value obj, String methodName) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        List<Method> methods;
        DebugProcess process = evaluationContext.getDebugProcess();
        ClassType cls = (ClassType)process.findClass(evaluationContext, ImageSerializer.class.getName(), evaluationContext.getClassLoader());
        if (cls != null && !(methods = cls.methodsByName(methodName)).isEmpty()) {
            return process.invokeMethod(evaluationContext, cls, methods.get(0), Collections.singletonList(obj));
        }
        return null;
    }

    private static byte[] readBytes(Value bytes) {
        if (bytes instanceof ArrayReference) {
            List<Value> values = ((ArrayReference)bytes).getValues();
            byte[] res = new byte[values.size()];
            int idx = 0;
            for (Value value : values) {
                if (value instanceof ByteValue) {
                    res[idx++] = ((ByteValue)value).value();
                    continue;
                }
                return null;
            }
            return res;
        }
        return null;
    }
}

