/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class MethodReturnValueDescriptorImpl
extends ValueDescriptorImpl {
    private final Method myMethod;
    private final Value myValue;

    public MethodReturnValueDescriptorImpl(Project project, Method method, Value value) {
        super(project);
        this.myMethod = method;
        this.myValue = value;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.myValue;
    }

    @Override
    public String getName() {
        return this.myMethod.toString();
    }

    @Override
    public Type getType() {
        if (this.myValue == null) {
            try {
                return this.myMethod.returnType();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                // empty catch block
            }
        }
        return super.getType();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        throw new EvaluateException("Evaluation not supported for method return value");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

