/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.ExtensionPoints;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.Developer;
import com.intellij.diagnostic.DevelopersLoader;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.JetBrainsAccountDialog;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.errordialog.AttachmentsTabForm;
import com.intellij.diagnostic.errordialog.CommentsTabForm;
import com.intellij.diagnostic.errordialog.DetailsTabForm;
import com.intellij.diagnostic.errordialog.DisablePluginWarningDialog;
import com.intellij.diagnostic.errordialog.LabeledTextComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.HeaderlessTabbedPane;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeErrorsDialog
extends DialogWrapper
implements MessagePoolListener,
TypeSafeDataProvider {
    private static final Logger LOG = Logger.getInstance((String)IdeErrorsDialog.class.getName());
    private final boolean myInternalMode;
    @NonNls
    private static final String ACTIVE_TAB_OPTION = IdeErrorsDialog.class.getName() + "activeTab";
    public static DataKey<String> CURRENT_TRACE_KEY = DataKey.create((String)"current_stack_trace_key");
    public static final int COMPONENTS_WIDTH = 670;
    public static Collection<Developer> ourDevelopersList = Collections.emptyList();
    private JPanel myContentPane;
    private JPanel myBackButtonPanel;
    private HyperlinkLabel.Croppable myInfoLabel;
    private JPanel myNextButtonPanel;
    private JPanel myTabsPanel;
    private JLabel myCountLabel;
    private HyperlinkLabel.Croppable myForeignPluginWarningLabel;
    private HyperlinkLabel.Croppable myDisableLink;
    private JPanel myCredentialsPanel;
    private HyperlinkLabel myCredentialsLabel;
    private JPanel myForeignPluginWarningPanel;
    private JPanel myAttachmentWarningPanel;
    private HyperlinkLabel myAttachmentWarningLabel;
    private int myIndex = 0;
    private final List<ArrayList<AbstractMessage>> myMergedMessages;
    private List<AbstractMessage> myRawMessages;
    private final MessagePool myMessagePool;
    private HeaderlessTabbedPane myTabs;
    @Nullable
    private CommentsTabForm myCommentsTabForm;
    private DetailsTabForm myDetailsTabForm;
    private AttachmentsTabForm myAttachmentsTabForm;
    private ClearFatalsAction myClearAction;
    private BlameAction myBlameAction;
    @Nullable
    private AnalyzeAction myAnalyzeAction;
    private boolean myMute;

    public IdeErrorsDialog(MessagePool messagePool, @Nullable LogMessage defaultMessage) {
        super((Component)JOptionPane.getRootFrame(), false);
        this.$$$setupUI$$$();
        this.myMergedMessages = new ArrayList<ArrayList<AbstractMessage>>();
        this.myClearAction = new ClearFatalsAction();
        this.myMessagePool = messagePool;
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        this.myInternalMode = app != null && app.isInternal();
        this.setTitle(DiagnosticBundle.message("error.list.title", new Object[0]));
        this.init();
        this.rebuildHeaders();
        if (defaultMessage == null || !this.moveSelectionToMessage(defaultMessage)) {
            this.moveSelectionToEarliestMessage();
        }
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        this.setModal(false);
        if (this.myInternalMode) {
            if (ourDevelopersList.isEmpty()) {
                this.loadDevelopersAsynchronously();
            } else {
                this.myDetailsTabForm.setDevelopers(ourDevelopersList);
            }
        }
    }

    private void loadDevelopersAsynchronously() {
        Task.Backgroundable task = new Task.Backgroundable(null, "Loading developers list", true){
            private final Collection[] myDevelopers;
            {
                this.myDevelopers = new Collection[]{Collections.emptyList()};
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/IdeErrorsDialog$1", "run"));
                }
                try {
                    this.myDevelopers[0] = DevelopersLoader.fetchDevelopers(indicator);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void onSuccess() {
                Collection developers = this.myDevelopers[0];
                IdeErrorsDialog.this.myDetailsTabForm.setDevelopers(developers);
                ourDevelopersList = developers;
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private boolean moveSelectionToMessage(LogMessage defaultMessage) {
        int index = -1;
        for (int i = 0; i < this.myMergedMessages.size(); ++i) {
            AbstractMessage each = this.getMessageAt(i);
            if (each != defaultMessage) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.myIndex = index;
            this.updateControls();
            return true;
        }
        return false;
    }

    @Override
    public void newEntryAdded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeErrorsDialog.this.rebuildHeaders();
                IdeErrorsDialog.this.updateControls();
            }
        });
    }

    @Override
    public void poolCleared() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeErrorsDialog.this.doOKAction();
            }
        });
    }

    @Override
    public void entryWasRead() {
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getCancelAction(), this.myClearAction, this.myBlameAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/IdeErrorsDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myClearAction, this.myBlameAction, this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/IdeErrorsDialog", "createActions"));
        }
        return actionArray;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myBlameAction = new BlameAction();
        this.myBlameAction.putValue("DefaultAction", true);
    }

    protected JComponent createCenterPanel() {
        DefaultActionGroup goBack = new DefaultActionGroup();
        BackAction back = new BackAction();
        goBack.add((AnAction)back);
        ActionToolbar backToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)goBack, true);
        backToolbar.getComponent().setBorder(IdeBorderFactory.createEmptyBorder());
        backToolbar.setLayoutPolicy(0);
        this.myBackButtonPanel.add((Component)backToolbar.getComponent(), "Center");
        DefaultActionGroup goForward = new DefaultActionGroup();
        ForwardAction forward = new ForwardAction();
        goForward.add((AnAction)forward);
        ActionToolbar forwardToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)goForward, true);
        forwardToolbar.setLayoutPolicy(0);
        forwardToolbar.getComponent().setBorder(IdeBorderFactory.createEmptyBorder());
        this.myNextButtonPanel.add((Component)forwardToolbar.getComponent(), "Center");
        this.myTabs = new HeaderlessTabbedPane(this.getDisposable());
        LabeledTextComponent.TextListener commentsListener = new LabeledTextComponent.TextListener(){

            @Override
            public void textChanged(String newText) {
                if (IdeErrorsDialog.this.myMute) {
                    return;
                }
                AbstractMessage message = IdeErrorsDialog.this.getSelectedMessage();
                if (message != null) {
                    message.setAdditionalInfo(newText);
                }
            }
        };
        if (!this.myInternalMode) {
            this.myDetailsTabForm = new DetailsTabForm(null, this.myInternalMode);
            this.myCommentsTabForm = new CommentsTabForm();
            this.myCommentsTabForm.addCommentsListener(commentsListener);
            this.myTabs.addTab(DiagnosticBundle.message("error.comments.tab.title", new Object[0]), this.myCommentsTabForm.getContentPane());
            this.myDetailsTabForm.setCommentsAreaVisible(false);
        } else {
            AnAction analyzePlatformAction = ActionManager.getInstance().getAction("AnalyzeStacktraceOnError");
            if (analyzePlatformAction != null) {
                this.myAnalyzeAction = new AnalyzeAction(analyzePlatformAction);
            }
            this.myDetailsTabForm = new DetailsTabForm(this.myAnalyzeAction, this.myInternalMode);
            this.myDetailsTabForm.setCommentsAreaVisible(true);
            this.myDetailsTabForm.addCommentsListener(commentsListener);
        }
        this.myTabs.addTab(DiagnosticBundle.message("error.details.tab.title", new Object[0]), this.myDetailsTabForm.getContentPane());
        this.myAttachmentsTabForm = new AttachmentsTabForm();
        this.myAttachmentsTabForm.addInclusionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IdeErrorsDialog.this.updateAttachmentWarning(IdeErrorsDialog.this.getSelectedMessage());
            }
        });
        int activeTabIndex = Integer.parseInt(PropertiesComponent.getInstance().getValue(ACTIVE_TAB_OPTION, "0"));
        if (activeTabIndex >= this.myTabs.getTabCount() || activeTabIndex < 0) {
            activeTabIndex = 0;
        }
        this.myTabs.setSelectedIndex(activeTabIndex);
        this.myTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JComponent c = IdeErrorsDialog.this.getPreferredFocusedComponent();
                if (c != null) {
                    IdeFocusManager.findInstanceByComponent((Component)IdeErrorsDialog.this.myContentPane).requestFocus((Component)c, true);
                }
            }
        });
        this.myTabsPanel.add((Component)this.myTabs, "Center");
        this.myDisableLink.setHyperlinkText(UIUtil.removeMnemonic((String)DiagnosticBundle.message("error.list.disable.plugin", new Object[0])));
        this.myDisableLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    IdeErrorsDialog.this.disablePlugin();
                }
            }
        });
        this.myCredentialsLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    new JetBrainsAccountDialog(IdeErrorsDialog.this.getRootPane()).show();
                    IdeErrorsDialog.this.updateCredentialsPane(IdeErrorsDialog.this.getSelectedMessage());
                }
            }
        });
        this.myAttachmentWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myAttachmentWarningLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    IdeErrorsDialog.this.myTabs.setSelectedIndex(IdeErrorsDialog.this.myTabs.indexOfComponent(IdeErrorsDialog.this.myAttachmentsTabForm.getContentPane()));
                    IdeErrorsDialog.this.myAttachmentsTabForm.selectFirstIncludedAttachment();
                }
            }
        });
        this.myDetailsTabForm.addAssigneeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IdeErrorsDialog.this.myMute) {
                    return;
                }
                AbstractMessage message = IdeErrorsDialog.this.getSelectedMessage();
                if (message != null) {
                    message.setAssigneeId(IdeErrorsDialog.this.myDetailsTabForm.getAssigneeId());
                }
            }
        });
        return this.myContentPane;
    }

    private void moveSelectionToEarliestMessage() {
        this.myIndex = 0;
        for (int i = 0; i < this.myMergedMessages.size(); ++i) {
            AbstractMessage each = this.getMessageAt(i);
            if (each.isRead()) continue;
            this.myIndex = i;
            break;
        }
        this.updateControls();
    }

    private void disablePlugin() {
        PluginId pluginId = IdeErrorsDialog.findPluginId(this.getSelectedMessage().getThrowable());
        if (pluginId == null) {
            return;
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        final Ref hasDependants = new Ref((Object)false);
        PluginManager.checkDependants(plugin, new Function<PluginId, IdeaPluginDescriptor>(){

            public IdeaPluginDescriptor fun(PluginId pluginId) {
                return PluginManager.getPlugin(pluginId);
            }
        }, new Condition<PluginId>(){

            public boolean value(PluginId pluginId) {
                if ("com.intellij".equals(pluginId.getIdString())) {
                    return true;
                }
                hasDependants.set((Object)true);
                return false;
            }
        });
        Application app = ApplicationManager.getApplication();
        DisablePluginWarningDialog d = new DisablePluginWarningDialog(this.getRootPane(), plugin.getName(), (Boolean)hasDependants.get(), app.isRestartCapable());
        d.show();
        switch (d.getExitCode()) {
            case 1: {
                return;
            }
            case 0: {
                PluginManager.disablePlugin(pluginId.getIdString());
                break;
            }
            case 2: {
                PluginManager.disablePlugin(pluginId.getIdString());
                app.restart();
            }
        }
    }

    private void goBack() {
        --this.myIndex;
        this.updateControls();
    }

    private void goForward() {
        ++this.myIndex;
        this.updateControls();
    }

    private void updateControls() {
        this.updateCountLabel();
        AbstractMessage message = this.getSelectedMessage();
        this.updateInfoLabel(message);
        this.updateCredentialsPane(message);
        this.updateAssigneePane(message);
        this.updateAttachmentWarning(message);
        this.myDisableLink.setVisible(IdeErrorsDialog.canDisablePlugin(message));
        this.updateForeignPluginLabel(message != null ? message : null);
        this.updateTabs();
        this.myClearAction.update();
        this.myBlameAction.update();
        if (this.myAnalyzeAction != null) {
            this.myAnalyzeAction.update();
        }
    }

    private void updateAttachmentWarning(AbstractMessage message) {
        List includedAttachments = ContainerUtil.filter(message.getAttachments(), (Condition)new Condition<Attachment>(){

            public boolean value(Attachment attachment) {
                return attachment.isIncluded();
            }
        });
        if (!includedAttachments.isEmpty()) {
            this.myAttachmentWarningPanel.setVisible(true);
            if (includedAttachments.size() == 1) {
                this.myAttachmentWarningLabel.setHtmlText(DiagnosticBundle.message("diagnostic.error.report.include.attachment.warning", ((Attachment)includedAttachments.get(0)).getName()));
            } else {
                this.myAttachmentWarningLabel.setHtmlText(DiagnosticBundle.message("diagnostic.error.report.include.attachments.warning", includedAttachments.size()));
            }
        } else {
            this.myAttachmentWarningPanel.setVisible(false);
        }
    }

    private static boolean canDisablePlugin(AbstractMessage message) {
        if (message == null) {
            return false;
        }
        PluginId pluginId = IdeErrorsDialog.findPluginId(message.getThrowable());
        return pluginId != null;
    }

    private void updateCountLabel() {
        if (this.myMergedMessages.isEmpty()) {
            this.myCountLabel.setText(DiagnosticBundle.message("error.list.empty", new Object[0]));
        } else {
            this.myCountLabel.setText(DiagnosticBundle.message("error.list.message.index.count", Integer.toString(this.myIndex + 1), this.myMergedMessages.size()));
        }
    }

    private void updateCredentialsPane(AbstractMessage message) {
        ErrorReportSubmitter submitter;
        if (message != null && (submitter = IdeErrorsDialog.getSubmitter(message.getThrowable())) instanceof ITNReporter) {
            this.myCredentialsPanel.setVisible(true);
            String userName = ErrorReportConfigurable.getInstance().ITN_LOGIN;
            if (StringUtil.isEmpty((String)userName)) {
                this.myCredentialsLabel.setHtmlText(DiagnosticBundle.message("diagnostic.error.report.submit.error.anonymously", new Object[0]));
            } else {
                this.myCredentialsLabel.setHtmlText(DiagnosticBundle.message("diagnostic.error.report.submit.report.as", userName));
            }
            return;
        }
        this.myCredentialsPanel.setVisible(false);
    }

    private void updateAssigneePane(AbstractMessage message) {
        ErrorReportSubmitter submitter = message != null ? IdeErrorsDialog.getSubmitter(message.getThrowable()) : null;
        this.myDetailsTabForm.setAssigneeVisible(submitter instanceof ITNReporter && this.myInternalMode);
    }

    private void updateInfoLabel(AbstractMessage message) {
        if (message == null) {
            this.myInfoLabel.setText("");
            return;
        }
        Throwable throwable = message.getThrowable();
        if (throwable instanceof MessagePool.TooManyErrorsException) {
            this.myInfoLabel.setText("");
            return;
        }
        StringBuilder text = new StringBuilder();
        PluginId pluginId = IdeErrorsDialog.findPluginId(throwable);
        if (pluginId == null) {
            if (throwable instanceof AbstractMethodError) {
                text.append(DiagnosticBundle.message("error.list.message.blame.unknown.plugin", new Object[0]));
            } else {
                text.append(DiagnosticBundle.message("error.list.message.blame.core", ApplicationNamesInfo.getInstance().getProductName()));
            }
        } else {
            text.append(DiagnosticBundle.message("error.list.message.blame.plugin", PluginManager.getPlugin(pluginId).getName()));
        }
        text.append(" ").append(DiagnosticBundle.message("error.list.message.info", DateFormatUtil.formatPrettyDateTime((Date)message.getDate()), this.myMergedMessages.get(this.myIndex).size()));
        String url = null;
        if (message.isSubmitted()) {
            SubmittedReportInfo info = message.getSubmissionInfo();
            url = info.getURL();
            IdeErrorsDialog.appendSubmissionInformation(info, text);
            text.append(". ");
        } else if (message.isSubmitting()) {
            text.append(" Submitting...");
        } else if (!message.isRead()) {
            text.append(" ").append(DiagnosticBundle.message("error.list.message.unread", new Object[0]));
        }
        this.myInfoLabel.setHtmlText(XmlStringUtil.wrapInHtml((CharSequence)text));
        this.myInfoLabel.setHyperlinkTarget(url);
    }

    public static void appendSubmissionInformation(SubmittedReportInfo info, StringBuilder out) {
        if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.FAILED) {
            out.append(" ").append(DiagnosticBundle.message("error.list.message.submission.failed", new Object[0]));
        } else if (info.getURL() != null && info.getLinkText() != null) {
            out.append(" ").append(DiagnosticBundle.message("error.list.message.submitted.as.link", info.getURL(), info.getLinkText()));
            if (info.getStatus() == SubmittedReportInfo.SubmissionStatus.DUPLICATE) {
                out.append(" ").append(DiagnosticBundle.message("error.list.message.duplicate", new Object[0]));
            }
        } else {
            out.append(DiagnosticBundle.message("error.list.message.submitted", new Object[0]));
        }
    }

    private void updateForeignPluginLabel(AbstractMessage message) {
        Throwable throwable;
        ErrorReportSubmitter submitter;
        if (message != null && (submitter = IdeErrorsDialog.getSubmitter(throwable = message.getThrowable())) == null) {
            PluginId pluginId = IdeErrorsDialog.findPluginId(throwable);
            IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
            if (plugin == null || PluginManagerMain.isJetBrainsPlugin(plugin)) {
                this.myForeignPluginWarningPanel.setVisible(false);
                return;
            }
            this.myForeignPluginWarningPanel.setVisible(true);
            String vendor = plugin.getVendor();
            String contactInfo = plugin.getVendorUrl();
            if (StringUtil.isEmpty((String)contactInfo)) {
                contactInfo = plugin.getVendorEmail();
            }
            if (StringUtil.isEmpty((String)vendor)) {
                if (StringUtil.isEmpty((String)contactInfo)) {
                    this.myForeignPluginWarningLabel.setText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.text", new Object[0]));
                } else {
                    this.myForeignPluginWarningLabel.setHyperlinkText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.text.vendor", new Object[0]) + " ", contactInfo, ".");
                    this.myForeignPluginWarningLabel.setHyperlinkTarget(contactInfo);
                }
            } else if (StringUtil.isEmpty((String)contactInfo)) {
                this.myForeignPluginWarningLabel.setText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.text.vendor", new Object[0]) + " " + vendor + ".");
            } else {
                this.myForeignPluginWarningLabel.setHyperlinkText(DiagnosticBundle.message("error.dialog.foreign.plugin.warning.text.vendor", new Object[0]) + " " + vendor + " (", contactInfo, ").");
                this.myForeignPluginWarningLabel.setHyperlinkTarget(contactInfo);
            }
            this.myForeignPluginWarningPanel.setVisible(true);
            return;
        }
        this.myForeignPluginWarningPanel.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTabs() {
        this.myMute = true;
        try {
            List<Object> attachments;
            if (this.myInternalMode) {
                boolean hasAttachment = false;
                for (ArrayList<AbstractMessage> merged : this.myMergedMessages) {
                    AbstractMessage message = merged.get(0);
                    if (message.getAttachments().isEmpty()) continue;
                    hasAttachment = true;
                    break;
                }
                this.myTabs.setHeaderVisible(hasAttachment);
            }
            AbstractMessage message = this.getSelectedMessage();
            if (this.myCommentsTabForm != null) {
                if (message != null) {
                    String msg = message.getMessage();
                    int i = msg.indexOf("\n");
                    if (i != -1) {
                        msg = msg.substring(0, i);
                    }
                    this.myCommentsTabForm.setErrorText(msg);
                } else {
                    this.myCommentsTabForm.setErrorText(null);
                }
                if (message != null) {
                    this.myCommentsTabForm.setCommentText(message.getAdditionalInfo());
                    this.myCommentsTabForm.setCommentsTextEnabled(true);
                } else {
                    this.myCommentsTabForm.setCommentText(null);
                    this.myCommentsTabForm.setCommentsTextEnabled(false);
                }
            }
            this.myDetailsTabForm.setDetailsText(message != null ? IdeErrorsDialog.getDetailsText(message) : null);
            if (message != null) {
                this.myDetailsTabForm.setCommentsText(message.getAdditionalInfo());
                this.myDetailsTabForm.setCommentsTextEnabled(true);
            } else {
                this.myDetailsTabForm.setCommentsText(null);
                this.myDetailsTabForm.setCommentsTextEnabled(false);
            }
            this.myDetailsTabForm.setAssigneeId(message == null ? null : message.getAssigneeId());
            List<Object> list = attachments = message != null ? message.getAttachments() : Collections.emptyList();
            if (!attachments.isEmpty()) {
                if (this.myTabs.indexOfComponent(this.myAttachmentsTabForm.getContentPane()) == -1) {
                    this.myTabs.addTab(DiagnosticBundle.message("error.attachments.tab.title", new Object[0]), this.myAttachmentsTabForm.getContentPane());
                }
                this.myAttachmentsTabForm.setAttachments(attachments);
            } else {
                int index = this.myTabs.indexOfComponent(this.myAttachmentsTabForm.getContentPane());
                if (index != -1) {
                    this.myTabs.removeTabAt(index);
                }
            }
        }
        finally {
            this.myMute = false;
        }
    }

    private static String getDetailsText(AbstractMessage message) {
        Throwable throwable = message.getThrowable();
        if (throwable instanceof MessagePool.TooManyErrorsException) {
            return throwable.getMessage();
        }
        return new StringBuffer().append(message.getMessage()).append("\n").append(message.getThrowableText()).toString();
    }

    private void rebuildHeaders() {
        this.myMergedMessages.clear();
        this.myRawMessages = this.myMessagePool.getFatalErrors(true, true);
        Map<String, ArrayList<AbstractMessage>> hash2Messages = IdeErrorsDialog.mergeMessages(this.myRawMessages);
        for (ArrayList<AbstractMessage> abstractMessages : hash2Messages.values()) {
            this.myMergedMessages.add(abstractMessages);
        }
    }

    private void markAllAsRead() {
        for (AbstractMessage each : this.myRawMessages) {
            each.setRead(true);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        int selectedIndex = this.myTabs.getSelectedIndex();
        JComponent result = selectedIndex == 0 ? (this.myInternalMode ? this.myDetailsTabForm.getPreferredFocusedComponent() : this.myCommentsTabForm.getPreferredFocusedComponent()) : (selectedIndex == 1 ? (this.myInternalMode ? this.myAttachmentsTabForm.getPreferredFocusedComponent() : this.myDetailsTabForm.getPreferredFocusedComponent()) : this.myAttachmentsTabForm.getPreferredFocusedComponent());
        return result != null ? result : super.getPreferredFocusedComponent();
    }

    private static Map<String, ArrayList<AbstractMessage>> mergeMessages(List<AbstractMessage> aErrors) {
        LinkedHashMap<String, ArrayList<AbstractMessage>> hash2Messages = new LinkedHashMap<String, ArrayList<AbstractMessage>>();
        for (AbstractMessage each : aErrors) {
            ArrayList list;
            String hashCode = IdeErrorsDialog.getThrowableHashCode(each.getThrowable());
            if (hash2Messages.containsKey(hashCode)) {
                list = (ArrayList)hash2Messages.get(hashCode);
            } else {
                list = new ArrayList();
                hash2Messages.put(hashCode, list);
            }
            list.add(0, each);
        }
        return hash2Messages;
    }

    private AbstractMessage getSelectedMessage() {
        return this.getMessageAt(this.myIndex);
    }

    private AbstractMessage getMessageAt(int idx) {
        if (idx < 0 || idx >= this.myMergedMessages.size()) {
            return null;
        }
        return this.myMergedMessages.get(idx).get(0);
    }

    @Nullable
    public static PluginId findPluginId(Throwable t) {
        String className;
        if (t instanceof PluginException) {
            return ((PluginException)t).getPluginId();
        }
        HashSet visitedClassNames = ContainerUtil.newHashSet();
        for (StackTraceElement element : t.getStackTrace()) {
            String className2;
            if (element == null || !visitedClassNames.add(className2 = element.getClassName()) || !PluginManagerCore.isPluginClass(className2)) continue;
            PluginId id = PluginManagerCore.getPluginByClassName(className2);
            if (LOG.isDebugEnabled()) {
                LOG.debug(IdeErrorsDialog.diagnosePluginDetection(className2, id));
            }
            return id;
        }
        if (t instanceof NoSuchMethodException) {
            if (t.getMessage() != null) {
                className = "";
                StringTokenizer tok = new StringTokenizer(t.getMessage(), ".");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token.length() <= 0 || !Character.isJavaIdentifierStart(token.charAt(0))) continue;
                    className = className + token;
                }
                if (PluginManager.isPluginClass(className)) {
                    return PluginManager.getPluginByClassName(className);
                }
            }
        } else if (t instanceof ClassNotFoundException) {
            if (t.getMessage() != null && PluginManager.isPluginClass(className = t.getMessage())) {
                return PluginManager.getPluginByClassName(className);
            }
        } else if (t instanceof AbstractMethodError && t.getMessage() != null) {
            String s = t.getMessage();
            int pos = s.indexOf(40);
            if (pos >= 0 && (pos = (s = s.substring(0, pos)).lastIndexOf(46)) >= 0 && PluginManager.isPluginClass(s = s.substring(0, pos))) {
                return PluginManager.getPluginByClassName(s);
            }
        } else if (t instanceof ExtensionException && PluginManager.isPluginClass(className = ((ExtensionException)t).getExtensionClass().getName())) {
            return PluginManager.getPluginByClassName(className);
        }
        return null;
    }

    @NotNull
    private static String diagnosePluginDetection(String className, PluginId id) {
        String msg = "Detected plugin " + id + " by class " + className;
        IdeaPluginDescriptor descriptor = PluginManager.getPlugin(id);
        if (descriptor != null) {
            msg = msg + "; ideaLoader=" + descriptor.getUseIdeaClassLoader();
            ClassLoader loader = descriptor.getPluginClassLoader();
            msg = msg + "; loader=" + loader;
            if (loader instanceof PluginClassLoader) {
                msg = msg + "; loaded class: " + ((PluginClassLoader)((Object)loader)).hasLoadedClass(className);
            }
        }
        String string = msg;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/IdeErrorsDialog", "diagnosePluginDetection"));
        }
        return string;
    }

    protected void updateOnSubmit() {
        this.updateControls();
    }

    public void calcData(DataKey key, DataSink sink) {
        AbstractMessage message;
        if (CURRENT_TRACE_KEY == key && (message = this.getSelectedMessage()) != null) {
            sink.put(CURRENT_TRACE_KEY, (Object)IdeErrorsDialog.getDetailsText(message));
        }
    }

    @Nullable
    public static ErrorReportSubmitter getSubmitter(Throwable throwable) {
        ErrorReportSubmitter[] reporters;
        if (throwable instanceof MessagePool.TooManyErrorsException || throwable instanceof AbstractMethodError) {
            return null;
        }
        PluginId pluginId = IdeErrorsDialog.findPluginId(throwable);
        try {
            reporters = (ErrorReportSubmitter[])Extensions.getExtensions((ExtensionPointName)ExtensionPoints.ERROR_HANDLER_EP);
        }
        catch (Throwable t) {
            return null;
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        if (plugin == null || PluginManagerMain.isJetBrainsPlugin(plugin)) {
            return IdeErrorsDialog.getCorePluginSubmitter(reporters);
        }
        for (ErrorReportSubmitter reporter : reporters) {
            PluginDescriptor descriptor = reporter.getPluginDescriptor();
            if (descriptor == null || !Comparing.equal((Object)pluginId, (Object)descriptor.getPluginId())) continue;
            return reporter;
        }
        return null;
    }

    @Nullable
    private static ErrorReportSubmitter getCorePluginSubmitter(ErrorReportSubmitter[] reporters) {
        for (ErrorReportSubmitter reporter : reporters) {
            PluginDescriptor descriptor = reporter.getPluginDescriptor();
            if (descriptor != null && PluginId.getId((String)"com.intellij") != descriptor.getPluginId()) continue;
            return reporter;
        }
        return null;
    }

    public void doOKAction() {
        this.onClose();
        super.doOKAction();
    }

    private void onClose() {
        this.markAllAsRead();
        PropertiesComponent.getInstance().setValue(ACTIVE_TAB_OPTION, String.valueOf(this.myTabs.getSelectedIndex()));
    }

    public void doCancelAction() {
        this.onClose();
        super.doCancelAction();
    }

    protected String getDimensionServiceKey() {
        return "IdeErrosDialog";
    }

    private static String getThrowableHashCode(Throwable exception) {
        try {
            return IdeErrorsDialog.md5(StringUtil.getThrowableText((Throwable)exception), "stack-trace");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    private static String md5(String buffer, @NonNls String key) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buffer.getBytes());
        byte[] code = md5.digest(key.getBytes());
        BigInteger bi = new BigInteger(code).abs();
        return bi.abs().toString(16);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JLabel jLabel;
        JPanel jPanel5;
        HyperlinkLabel.Croppable croppable;
        JPanel jPanel6;
        HyperlinkLabel.Croppable croppable2;
        HyperlinkLabel.Croppable croppable3;
        JPanel jPanel7;
        this.myContentPane = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel9, "North");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 3));
        jPanel9.add((Component)jPanel10, "Center");
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), null, 0, 0, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel11, "Center");
        this.myInfoLabel = croppable3 = new HyperlinkLabel.Croppable();
        jPanel11.add((Component)croppable3, "West");
        this.myDisableLink = croppable2 = new HyperlinkLabel.Croppable();
        jPanel11.add((Component)croppable2, "Center");
        this.myForeignPluginWarningPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel6, "South");
        this.myForeignPluginWarningLabel = croppable = new HyperlinkLabel.Croppable();
        jPanel6.add((Component)croppable, "Center");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new FlowLayout(1, 5, 5));
        jPanel9.add((Component)jPanel12, "West");
        this.myBackButtonPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        Component component = jPanel12.add(jPanel5);
        this.myCountLabel = jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(0);
        jLabel.setText("1 of 3");
        jLabel.setHorizontalAlignment(0);
        Component component2 = jPanel12.add(jLabel);
        this.myNextButtonPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        Component component3 = jPanel12.add(jPanel4);
        this.myTabsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel3, "Center");
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel13, "South");
        this.myCredentialsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel13.add((Component)jPanel2, "North");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), null, 0, 0, null, null));
        this.myCredentialsLabel = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel2.add((Component)hyperlinkLabel2, "East");
        this.myAttachmentWarningPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel13.add((Component)jPanel, "South");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), null, 0, 0, null, null));
        this.myAttachmentWarningLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, "East");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class AnalyzeAction
    extends AbstractAction {
        private final AnAction myAnalyze;

        public AnalyzeAction(AnAction analyze) {
            super(analyze.getTemplatePresentation().getText());
            this.putValue("MnemonicKey", analyze.getTemplatePresentation().getMnemonic());
            this.myAnalyze = analyze;
        }

        public void update() {
            this.setEnabled(IdeErrorsDialog.this.getSelectedMessage() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataContext dataContext = ((DataManagerImpl)DataManager.getInstance()).getDataContextTest((Component)e.getSource());
            AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", this.myAnalyze.getTemplatePresentation(), ActionManager.getInstance(), e.getModifiers());
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project != null) {
                this.myAnalyze.actionPerformed(event);
                IdeErrorsDialog.this.doOKAction();
            }
        }
    }

    private class BlameAction
    extends AbstractAction {
        protected BlameAction() {
            super(DiagnosticBundle.message("error.report.to.jetbrains.action", new Object[0]));
        }

        public void update() {
            ErrorReportSubmitter submitter;
            AbstractMessage logMessage = IdeErrorsDialog.this.getSelectedMessage();
            if (logMessage != null && (submitter = IdeErrorsDialog.getSubmitter(logMessage.getThrowable())) != null) {
                this.putValue("Name", submitter.getReportActionText());
                this.setEnabled(!logMessage.isSubmitting() && !logMessage.isSubmitted());
                return;
            }
            this.putValue("Name", DiagnosticBundle.message("error.report.to.jetbrains.action", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean closeDialog = IdeErrorsDialog.this.myMergedMessages.size() == 1;
            AbstractMessage logMessage = IdeErrorsDialog.this.getSelectedMessage();
            boolean reportingStarted = this.reportMessage(logMessage, closeDialog);
            if (closeDialog) {
                if (reportingStarted) {
                    IdeErrorsDialog.this.doOKAction();
                }
            } else {
                IdeErrorsDialog.this.rebuildHeaders();
                IdeErrorsDialog.this.updateControls();
            }
        }

        private boolean reportMessage(final AbstractMessage logMessage, final boolean dialogClosed) {
            Container parentComponent;
            ErrorReportSubmitter submitter = IdeErrorsDialog.getSubmitter(logMessage.getThrowable());
            if (submitter == null) {
                return false;
            }
            logMessage.setSubmitting(true);
            if (!dialogClosed) {
                IdeErrorsDialog.this.updateControls();
            }
            if (dialogClosed) {
                IdeFrame ideFrame = (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)IdeErrorsDialog.this.getContentPane());
                parentComponent = ideFrame.getComponent();
            } else {
                parentComponent = IdeErrorsDialog.this.getContentPane();
            }
            return submitter.submit(this.getEvents(logMessage), logMessage.getAdditionalInfo(), (Component)parentComponent, (Consumer)new Consumer<SubmittedReportInfo>(){

                public void consume(SubmittedReportInfo submittedReportInfo) {
                    logMessage.setSubmitting(false);
                    logMessage.setSubmitted(submittedReportInfo);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!dialogClosed) {
                                IdeErrorsDialog.this.updateOnSubmit();
                            }
                        }
                    });
                }
            });
        }

        private IdeaLoggingEvent[] getEvents(AbstractMessage logMessage) {
            if (logMessage instanceof GroupedLogMessage) {
                List<AbstractMessage> messages = ((GroupedLogMessage)logMessage).getMessages();
                IdeaLoggingEvent[] res = new IdeaLoggingEvent[messages.size()];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = this.getEvent(messages.get(i));
                }
                return res;
            }
            return new IdeaLoggingEvent[]{this.getEvent(logMessage)};
        }

        private IdeaLoggingEvent getEvent(final AbstractMessage logMessage) {
            if (logMessage instanceof LogMessageEx) {
                return ((LogMessageEx)logMessage).toEvent();
            }
            return new IdeaLoggingEvent(logMessage.getMessage(), logMessage.getThrowable()){

                public AbstractMessage getData() {
                    return logMessage;
                }
            };
        }
    }

    private class ClearFatalsAction
    extends AbstractAction {
        protected ClearFatalsAction() {
            super(DiagnosticBundle.message("error.dialog.clear.action", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeErrorsDialog.this.myMessagePool.clearFatals();
            IdeErrorsDialog.this.doOKAction();
        }

        public void update() {
            this.putValue("Name", DiagnosticBundle.message(IdeErrorsDialog.this.myMergedMessages.size() > 1 ? "error.dialog.clear.all.action" : "error.dialog.clear.action", new Object[0]));
            this.setEnabled(!IdeErrorsDialog.this.myMergedMessages.isEmpty());
        }
    }

    private class BackAction
    extends AnAction
    implements DumbAware {
        public BackAction() {
            super("Previous", null, AllIcons.Actions.Back);
            AnAction back = ActionManager.getInstance().getAction("Back");
            if (back != null) {
                this.registerCustomShortcutSet(back.getShortcutSet(), IdeErrorsDialog.this.getRootPane(), IdeErrorsDialog.this.getDisposable());
            }
        }

        public void actionPerformed(AnActionEvent e) {
            IdeErrorsDialog.this.goBack();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(IdeErrorsDialog.this.myIndex > 0);
        }
    }

    private class ForwardAction
    extends AnAction
    implements DumbAware {
        public ForwardAction() {
            super("Next", null, AllIcons.Actions.Forward);
            AnAction forward = ActionManager.getInstance().getAction("Forward");
            if (forward != null) {
                this.registerCustomShortcutSet(forward.getShortcutSet(), IdeErrorsDialog.this.getRootPane(), IdeErrorsDialog.this.getDisposable());
            }
        }

        public void actionPerformed(AnActionEvent e) {
            IdeErrorsDialog.this.goForward();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(IdeErrorsDialog.this.myIndex < IdeErrorsDialog.this.myMergedMessages.size() - 1);
        }
    }
}

