/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsole;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ConsoleHistoryModel;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleExecuteAction
extends DumbAwareAction {
    static final String CONSOLE_EXECUTE_ACTION_ID = "Console.Execute";
    private final LanguageConsoleView myConsoleView;
    private final LanguageConsole myConsole;
    final ConsoleExecuteActionHandler myExecuteActionHandler;
    private final Condition<LanguageConsole> myEnabledCondition;

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, (Condition<LanguageConsole>)Conditions.alwaysTrue());
    }

    public static ConsoleExecuteAction createAction(final @NotNull LanguageConsole languageConsole, @NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (languageConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageConsole", "com/intellij/execution/console/ConsoleExecuteAction", "createAction"));
        }
        if (consoleExecuteActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleExecuteActionHandler", "com/intellij/execution/console/ConsoleExecuteAction", "createAction"));
        }
        final ProcessBackedConsoleExecuteActionHandler handler = consoleExecuteActionHandler;
        return new ConsoleExecuteAction(languageConsole, new ConsoleExecuteActionHandler(handler.myPreserveMarkup){

            @Override
            void doExecute(@NotNull String text, @NotNull LanguageConsole console, @Nullable LanguageConsoleView consoleView) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/ConsoleExecuteAction$1", "doExecute"));
                }
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction$1", "doExecute"));
                }
                handler.doExecute(text, languageConsole, null);
            }
        }, (Condition<LanguageConsole>)consoleExecuteActionHandler);
    }

    ConsoleExecuteAction(@NotNull LanguageConsole console, @NotNull ConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsole> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console, null, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsole> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console.getConsole(), console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String emptyExecuteActionId, @NotNull Condition<LanguageConsole> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (emptyExecuteActionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyExecuteActionId", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (enabledCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enabledCondition", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        this(console.getConsole(), console, executeActionHandler, emptyExecuteActionId, enabledCondition);
    }

    private ConsoleExecuteAction(@NotNull LanguageConsole console, @Nullable LanguageConsoleView consoleView, @NotNull ConsoleExecuteActionHandler executeActionHandler, @NotNull String emptyExecuteActionId, @Nullable Condition<LanguageConsole> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        if (emptyExecuteActionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyExecuteActionId", "com/intellij/execution/console/ConsoleExecuteAction", "<init>"));
        }
        super(null, null, AllIcons.Actions.Execute);
        this.myConsole = console;
        this.myConsoleView = consoleView;
        this.myExecuteActionHandler = executeActionHandler;
        this.myEnabledCondition = enabledCondition == null ? Conditions.alwaysTrue() : enabledCondition;
        EmptyAction.setupAction((AnAction)this, (String)emptyExecuteActionId, null);
    }

    public final void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/ConsoleExecuteAction", "update"));
        }
        EditorEx editor = this.myConsole.getConsoleEditor();
        boolean bl = enabled = !editor.isRendererMode() && this.isEnabled() && (this.myExecuteActionHandler.isEmptyCommandExecutionAllowed() || !StringUtil.isEmptyOrSpaces((CharSequence)editor.getDocument().getCharsSequence()));
        if (enabled) {
            LookupEx lookup = LookupManager.getActiveLookup(editor);
            enabled = lookup == null || !lookup.isCompletion() || lookup.getCurrentItem() == null;
        }
        e.getPresentation().setEnabled(enabled);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/ConsoleExecuteAction", "actionPerformed"));
        }
        this.myExecuteActionHandler.runExecuteAction(this.myConsole, this.myConsoleView);
    }

    public boolean isEnabled() {
        return this.myEnabledCondition.value((Object)this.myConsole);
    }

    public void execute(@Nullable TextRange range, @NotNull String text, @Nullable EditorEx editor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/ConsoleExecuteAction", "execute"));
        }
        if (range == null) {
            ((LanguageConsoleImpl)this.myConsole).doAddPromptToHistory();
            DocumentEx document = this.myConsole.getHistoryViewer().getDocument();
            document.insertString(document.getTextLength(), text);
            if (!text.endsWith("\n")) {
                document.insertString(document.getTextLength(), "\n");
            }
        } else {
            assert (editor != null);
            ((LanguageConsoleImpl)this.myConsole).addTextRangeToHistory(range, editor, this.myExecuteActionHandler.myPreserveMarkup);
        }
        this.myExecuteActionHandler.addToCommandHistoryAndExecute(this.myConsole, this.myConsoleView, text);
    }

    public static abstract class ConsoleExecuteActionHandler {
        private final ConsoleHistoryModel myCommandHistoryModel = new ConsoleHistoryModel();
        private boolean myAddToHistory = true;
        final boolean myPreserveMarkup;
        boolean myUseProcessStdIn;

        public ConsoleExecuteActionHandler(boolean preserveMarkup) {
            this.myPreserveMarkup = preserveMarkup;
        }

        public ConsoleHistoryModel getConsoleHistoryModel() {
            return this.myCommandHistoryModel;
        }

        public boolean isEmptyCommandExecutionAllowed() {
            return true;
        }

        public final void setAddCurrentToHistory(boolean addCurrentToHistory) {
            this.myAddToHistory = addCurrentToHistory;
        }

        protected void beforeExecution(@NotNull LanguageConsole console) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "beforeExecution"));
            }
        }

        protected void runExecuteAction(@NotNull LanguageConsole console, @Nullable LanguageConsoleView consoleView) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "runExecuteAction"));
            }
            if (!this.myUseProcessStdIn) {
                this.beforeExecution(console);
            }
            String text = ((LanguageConsoleImpl)console).prepareExecuteAction(this.myAddToHistory && !this.myUseProcessStdIn, this.myPreserveMarkup, true);
            ((UndoManagerImpl)UndoManager.getInstance((Project)console.getProject())).invalidateActionsFor(DocumentReferenceManager.getInstance().create(console.getCurrentEditor().getDocument()));
            if (this.myUseProcessStdIn) {
                assert (consoleView != null);
                consoleView.print(text, ConsoleViewContentType.USER_INPUT);
                consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            } else {
                this.addToCommandHistoryAndExecute(console, consoleView, text);
            }
        }

        private void addToCommandHistoryAndExecute(@NotNull LanguageConsole console, @Nullable LanguageConsoleView consoleView, @NotNull String text) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "addToCommandHistoryAndExecute"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/ConsoleExecuteAction$ConsoleExecuteActionHandler", "addToCommandHistoryAndExecute"));
            }
            this.myCommandHistoryModel.addToHistory(text);
            this.doExecute(text, console, consoleView);
        }

        abstract void doExecute(@NotNull String var1, @NotNull LanguageConsole var2, @Nullable LanguageConsoleView var3);
    }
}

