/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.RunIdeConsoleAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeConsoleRootType
extends ConsoleRootType {
    IdeConsoleRootType() {
        super("ide", "IDE Scripting");
    }

    @NotNull
    public static IdeConsoleRootType getInstance() {
        IdeConsoleRootType ideConsoleRootType = IdeConsoleRootType.findByClass(IdeConsoleRootType.class);
        if (ideConsoleRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/IdeConsoleRootType", "getInstance"));
        }
        return ideConsoleRootType;
    }

    @Override
    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/IdeConsoleRootType", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/IdeConsoleRootType", "substituteLanguage"));
        }
        FileType fileType = IdeConsoleRootType.getFileType(file);
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/IdeConsoleRootType", "substituteIcon"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/IdeConsoleRootType", "substituteIcon"));
        }
        return AllIcons.Debugger.ToolConsole;
    }

    @Override
    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/IdeConsoleRootType", "fileOpened"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/IdeConsoleRootType", "fileOpened"));
        }
        RunIdeConsoleAction.configureConsole(file, source);
    }

    @Nullable
    private static FileType getFileType(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/IdeConsoleRootType", "getFileType"));
        }
        String extension = file.getExtension();
        if (extension == null) {
            return null;
        }
        return FileTypeManager.getInstance().getFileTypeByExtension(extension);
    }
}

