/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.IdeConsoleRootType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunIdeConsoleAction
extends DumbAwareAction {
    private static final String DEFAULT_FILE_NAME = "ide-scripting";
    private static final Key<WeakReference<ConsoleView>> CONSOLE_VIEW_KEY = Key.create((String)"CONSOLE_VIEW_KEY");
    private static final Key<ConsoleHistoryController> HISTORY_CONTROLLER_KEY = Key.create((String)"HISTORY_CONTROLLER_KEY");

    public void update(AnActionEvent e) {
        boolean enabled = !Engines.ourEngines.isEmpty() && e.getProject() != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        if (Engines.ourEngines.size() == 1) {
            this.runConsole(e, Engines.ourEngines.values().iterator().next());
        } else {
            DefaultActionGroup actions = new DefaultActionGroup(ContainerUtil.map(Engines.ourEngines.values(), (Function)new NotNullFunction<ScriptEngineFactory, AnAction>(){

                @NotNull
                public AnAction fun(final ScriptEngineFactory engine) {
                    AnAction anAction = new AnAction(engine.getLanguageName()){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/RunIdeConsoleAction$1$1", "actionPerformed"));
                            }
                            RunIdeConsoleAction.this.runConsole(e, engine);
                        }
                    };
                    if (anAction == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction$1", "fun"));
                    }
                    return anAction;
                }
            }));
            JBPopupFactory.getInstance().createActionGroupPopup("Script Engine", (ActionGroup)actions, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false).showInBestPositionFor(e.getDataContext());
        }
    }

    protected void runConsole(@NotNull AnActionEvent e, @NotNull ScriptEngineFactory engine) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/console/RunIdeConsoleAction", "runConsole"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "runConsole"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        List<String> extensions = engine.getExtensions();
        try {
            String pathName = PathUtil.makeFileName((String)DEFAULT_FILE_NAME, (String)((String)ContainerUtil.getFirstItem(extensions)));
            VirtualFile virtualFile = IdeConsoleRootType.getInstance().findFile(project, pathName, ScratchFileService.Option.create_if_missing);
            if (virtualFile != null) {
                FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    public static void configureConsole(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "configureConsole"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/RunIdeConsoleAction", "configureConsole"));
        }
        ScriptEngine engine = RunIdeConsoleAction.findScriptEngine(file);
        if (engine == null) {
            return;
        }
        MyRunAction runAction = new MyRunAction(engine);
        for (FileEditor fileEditor : source.getEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            runAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, editor.getComponent());
        }
    }

    @Nullable
    private static ScriptEngine findScriptEngine(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "findScriptEngine"));
        }
        for (ScriptEngineFactory factory : Engines.ourEngines.values()) {
            if (!factory.getExtensions().contains(file.getExtension())) continue;
            return factory.getScriptEngine();
        }
        return null;
    }

    private static void executeQuery(@NotNull Project project, @NotNull VirtualFile file, @NotNull Editor editor, @NotNull ScriptEngine engine) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "executeQuery"));
        }
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode(editor);
        Document document = editor.getDocument();
        if (selectedRange.getLength() == 0) {
            int line = document.getLineNumber(selectedRange.getStartOffset());
            selectedRange = TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
        }
        String command = document.getText(selectedRange);
        ConsoleView consoleView = RunIdeConsoleAction.getConsoleView(project, file, engine);
        try {
            consoleView.print("> " + command, ConsoleViewContentType.USER_INPUT);
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            class IDE {
                final /* synthetic */ ConsoleView val$consoleView;

                IDE(ConsoleView consoleView) {
                    this.val$consoleView = consoleView;
                }

                public void print(String s) {
                    this.val$consoleView.print(s + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
                }

                public void error(String s) {
                    this.val$consoleView.print(s + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
            }
            engine.getBindings(100).put("IDE", (Object)new IDE(consoleView));
            Object o = engine.eval(command);
            consoleView.print("=> " + o, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        catch (Exception e) {
            consoleView.print(e.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        ((ConsoleViewImpl)consoleView).scrollToEnd();
    }

    @NotNull
    private static ConsoleView getConsoleView(@NotNull Project project, @NotNull VirtualFile file, @NotNull ScriptEngine engine) {
        ConsoleView existing;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        WeakReference ref = psiFile == null ? null : (WeakReference)psiFile.getCopyableUserData(CONSOLE_VIEW_KEY);
        ConsoleView consoleView = existing = ref == null ? null : (ConsoleView)ref.get();
        if (existing != null && !Disposer.isDisposed((Disposable)existing)) {
            ConsoleView consoleView2 = existing;
            if (consoleView2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
            }
            return consoleView2;
        }
        ConsoleView consoleView3 = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        if (psiFile != null) {
            psiFile.putCopyableUserData(CONSOLE_VIEW_KEY, new WeakReference<ConsoleView>(consoleView3));
        }
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel consoleComponent = new JPanel(new BorderLayout());
        consoleComponent.add((Component)consoleView3.getComponent(), "Center");
        consoleComponent.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false).getComponent(), "West");
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView3, null, consoleComponent, file.getName()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor, project));
        for (AnAction action : consoleView3.createConsoleActions()) {
            toolbarActions.add(action);
        }
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(executor, descriptor);
        ConsoleView consoleView4 = consoleView3;
        if (consoleView4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/RunIdeConsoleAction", "getConsoleView"));
        }
        return consoleView4;
    }

    private static class MyRunAction
    extends DumbAwareAction {
        private final ScriptEngine myEngine;

        public MyRunAction(ScriptEngine engine) {
            this.myEngine = engine;
        }

        public void update(AnActionEvent e) {
            Project project = e.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            e.getPresentation().setEnabledAndVisible(project != null && editor != null && virtualFile != null);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (project == null || editor == null || virtualFile == null) {
                return;
            }
            RunIdeConsoleAction.executeQuery(project, virtualFile, editor, this.myEngine);
        }
    }

    static class Engines {
        static final Map<String, ScriptEngineFactory> ourEngines = ContainerUtil.newLinkedHashMap();

        Engines() {
        }

        static {
            for (ScriptEngineFactory factory : new ScriptEngineManager().getEngineFactories()) {
                ourEngines.put(factory.getLanguageName(), factory);
            }
        }
    }
}

