/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestTreeViewAction;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ViewAssertEqualsDiffAction
extends AnAction
implements TestTreeViewAction {
    @NonNls
    public static final String ACTION_ID = "openAssertEqualsDiff";

    public void actionPerformed(AnActionEvent e) {
        if (!ViewAssertEqualsDiffAction.openDiff(e.getDataContext(), null)) {
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            Messages.showInfoMessage((Component)component, (String)"Comparison error was not found", (String)"No Comparison Data Found");
        }
    }

    public static boolean openDiff(DataContext context, @Nullable DiffHyperlink currentHyperlink) {
        DiffHyperlink diffViewerProvider;
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(context);
        if (testProxy != null && (diffViewerProvider = testProxy.getDiffViewerProvider()) != null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            List<DiffHyperlink> providers = ViewAssertEqualsDiffAction.collectAvailableProviders((TestFrameworkRunningModel)TestTreeView.MODEL_DATA_KEY.getData(context));
            if (providers.size() > 1) {
                new MyAssertEqualsDiffChain(providers, diffViewerProvider, currentHyperlink).openMultiDiff(project);
            } else {
                diffViewerProvider.openDiff(project);
            }
            return true;
        }
        return false;
    }

    private static List<DiffHyperlink> collectAvailableProviders(TestFrameworkRunningModel model) {
        ArrayList<DiffHyperlink> providers = new ArrayList<DiffHyperlink>();
        if (model != null) {
            AbstractTestProxy root = model.getRoot();
            List<? extends AbstractTestProxy> allTests = root.getAllTests();
            for (AbstractTestProxy abstractTestProxy : allTests) {
                DiffHyperlink provider;
                if (!abstractTestProxy.isLeaf() || (provider = abstractTestProxy.getDiffViewerProvider()) == null) continue;
                providers.add(provider);
            }
        }
        return providers;
    }

    public void update(AnActionEvent e) {
        AbstractTestProxy test;
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        boolean enabled = CommonDataKeys.PROJECT.getData(dataContext) == null ? false : ((test = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext)) != null ? (test.isLeaf() ? test.getDiffViewerProvider() != null : test.isDefect()) : false);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    private static class MyAssertEqualsDiffChain
    implements AbstractTestProxy.AssertEqualsDiffChain {
        private final List<DiffHyperlink> myProviders;
        private DiffHyperlink myProvider;

        public MyAssertEqualsDiffChain(List<DiffHyperlink> providers, DiffHyperlink provider, DiffHyperlink hyperlink) {
            this.myProviders = providers;
            if (hyperlink != null) {
                for (DiffHyperlink viewProvider : providers) {
                    if (!hyperlink.equals(viewProvider)) continue;
                    provider = viewProvider;
                    break;
                }
            }
            this.myProvider = provider;
        }

        @Override
        public DiffHyperlink getPrevious() {
            int prevIdx = (this.myProviders.size() + this.myProviders.indexOf(this.myProvider) - 1) % this.myProviders.size();
            return this.myProviders.get(prevIdx);
        }

        @Override
        public DiffHyperlink getCurrent() {
            return this.myProvider;
        }

        @Override
        public DiffHyperlink getNext() {
            int nextIdx = (this.myProviders.indexOf(this.myProvider) + 1) % this.myProviders.size();
            return this.myProviders.get(nextIdx);
        }

        @Override
        public void setCurrent(DiffHyperlink provider) {
            this.myProvider = provider;
        }

        public void openMultiDiff(Project project) {
            this.myProvider.openMultiDiff(project, this);
        }
    }
}

