/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchComponent;
import com.intellij.find.editorHeaderActions.EditorHeaderAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Getter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class ShowHistoryAction
extends EditorHeaderAction
implements DumbAware {
    private final Getter<JTextComponent> myTextField;

    public JTextComponent getTextField() {
        return (JTextComponent)this.myTextField.get();
    }

    public ShowHistoryAction(Getter<JTextComponent> textField, EditorSearchComponent editorSearchComponent) {
        super(editorSearchComponent);
        this.myTextField = textField;
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Search);
        String s = this.getTextField() == this.getEditorSearchComponent().getSearchField() ? "Search" : "Replace";
        this.getTemplatePresentation().setDescription(s + " history");
        this.getTemplatePresentation().setText(s + " History");
        ArrayList<KeyboardShortcut> shortcuts = new ArrayList<KeyboardShortcut>();
        if (this.getTextField() == this.getEditorSearchComponent().getSearchField()) {
            ContainerUtil.addAll(shortcuts, (Object[])ActionManager.getInstance().getAction("IncrementalSearch").getShortcutSet().getShortcuts());
        }
        shortcuts.add(new KeyboardShortcut(KeyStroke.getKeyStroke(72, 128), null));
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()])), this.getTextField());
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(this.getEditorSearchComponent().getFindModel().isMultiline());
    }

    public void actionPerformed(AnActionEvent e) {
        this.getEditorSearchComponent().showHistory(e.getInputEvent() instanceof MouseEvent, this.getTextField());
    }
}

