/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectSubViewSelectInTarget;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewSelectInTarget
extends SelectInTargetPsiWrapper
implements CompositeSelectInTarget {
    private String mySubId;

    protected ProjectViewSelectInTarget(Project project) {
        super(project);
    }

    @Override
    protected final void select(Object selector, VirtualFile virtualFile, boolean requestFocus) {
        ProjectViewSelectInTarget.select(this.myProject, selector, this.getMinorViewId(), this.mySubId, virtualFile, requestFocus);
    }

    @NotNull
    public static ActionCallback select(@NotNull Project project, final Object toSelect, final @Nullable String viewId, final @Nullable String subviewId, final VirtualFile virtualFile, final boolean requestFocus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectViewSelectInTarget", "select"));
        }
        final ActionCallback result = new ActionCallback();
        final ProjectView projectView = ProjectView.getInstance(project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractProjectViewPane pane = projectView.getProjectViewPaneById("ProjectPane");
            pane.select(toSelect, virtualFile, requestFocus);
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectViewSelectInTarget", "select"));
            }
            return actionCallback;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow projectViewToolWindow = windowManager.getToolWindow(ToolWindowId.PROJECT_VIEW);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        projectView.selectCB(toSelect, virtualFile, requestFocus).notify(result);
                    }
                };
                if (requestFocus) {
                    projectView.changeViewCB((String)ObjectUtils.chooseNotNull((Object)viewId, (Object)"ProjectPane"), subviewId).doWhenProcessed(r);
                } else {
                    r.run();
                }
            }
        };
        if (requestFocus) {
            projectViewToolWindow.activate(runnable, false);
        } else {
            projectViewToolWindow.show(runnable);
        }
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectViewSelectInTarget", "select"));
        }
        return actionCallback;
    }

    @NotNull
    public Collection<SelectInTarget> getSubTargets(@NotNull SelectInContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/ProjectViewSelectInTarget", "getSubTargets"));
        }
        ArrayList<SelectInTarget> result = new ArrayList<SelectInTarget>();
        AbstractProjectViewPane pane = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        int index = 0;
        for (String subId : pane.getSubIds()) {
            result.add(new ProjectSubViewSelectInTarget(this, subId, index++));
        }
        ArrayList<SelectInTarget> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectViewSelectInTarget", "getSubTargets"));
        }
        return arrayList;
    }

    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return false;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file) {
        return true;
    }

    public String getSubIdPresentableName(String subId) {
        AbstractProjectViewPane pane = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        return pane.getPresentableSubIdName(subId);
    }

    @Override
    public void select(PsiElement element, boolean requestFocus) {
        PsiElement toSelect = null;
        for (TreeStructureProvider provider : this.getProvidersDumbAware()) {
            if (provider instanceof SelectableTreeStructureProvider) {
                toSelect = ((SelectableTreeStructureProvider)provider).getTopLevelElement(element);
            }
            if (toSelect != null) break;
        }
        if (toSelect == null) {
            if (element instanceof PsiFile || element instanceof PsiDirectory) {
                toSelect = element;
            } else {
                PsiFile containingFile = element.getContainingFile();
                if (containingFile == null) {
                    return;
                }
                FileViewProvider viewProvider = containingFile.getViewProvider();
                toSelect = viewProvider.getPsi(viewProvider.getBaseLanguage());
            }
        }
        if (toSelect == null) {
            return;
        }
        PsiElement originalElement = toSelect.getOriginalElement();
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)originalElement);
        this.select(originalElement, virtualFile, requestFocus);
    }

    private TreeStructureProvider[] getProvidersDumbAware() {
        List<Object> allProviders = Arrays.asList(Extensions.getExtensions((ExtensionPointName)TreeStructureProvider.EP_NAME, (AreaInstance)this.myProject));
        List dumbAware = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(allProviders);
        return dumbAware.toArray(new TreeStructureProvider[dumbAware.size()]);
    }

    public final String getToolWindowId() {
        return ToolWindowId.PROJECT_VIEW;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return true;
    }

    public final void setSubId(String subId) {
        this.mySubId = subId;
    }

    public final String getSubId() {
        return this.mySubId;
    }
}

