/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScratchFileService {
    public static ScratchFileService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileService", "getInstance"));
        }
        return (ScratchFileService)ServiceManager.getService((Project)project, ScratchFileService.class);
    }

    public static ScratchFileService getInstance() {
        return (ScratchFileService)ServiceManager.getService(ScratchFileService.class);
    }

    @NotNull
    public abstract String getRootPath(@NotNull RootType var1);

    @Nullable
    public abstract RootType getRootType(@NotNull VirtualFile var1);

    public abstract VirtualFile findFile(@NotNull RootType var1, @NotNull String var2, Option var3) throws IOException;

    @Nullable
    public abstract VirtualFile createScratchFile(@NotNull Project var1, @NotNull Language var2, @NotNull String var3);

    @NotNull
    public abstract PerFileMappings<Language> getScratchesMapping();

    public static enum Option {
        existing_only,
        create_if_missing,
        create_new_always;

    }
}

