/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public ScratchProjectViewPane(Project project) {
        super(project);
    }

    @Override
    public String getTitle() {
        return ID;
    }

    @Override
    public Icon getIcon() {
        return super.getIcon();
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchProjectViewPane", "getId"));
        }
        return ID;
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new MyTreeStructure(this.myProject);
    }

    @Override
    public int getWeight() {
        return 11;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file) {
                if (!super.canSelect(file)) {
                    return false;
                }
                VirtualFile vFile = file.getVirtualFile();
                if (vFile == null || !vFile.isValid()) {
                    return false;
                }
                return ScratchFileService.getInstance(this.myProject).getRootType(file.getVirtualFile()) != null;
            }

            @Override
            protected boolean canWorkWithCustomObjects() {
                return false;
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
    }

    @Override
    @Nullable
    protected PsiElement getPSIElement(@Nullable Object element) {
        return element instanceof RootType ? ScratchProjectViewPane.getDirectory(this.myProject, (RootType)element) : super.getPSIElement(element);
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project, @NotNull RootType rootId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchProjectViewPane", "getDirectory"));
        }
        if (rootId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootId", "com/intellij/ide/scratch/ScratchProjectViewPane", "getDirectory"));
        }
        String path = ScratchFileService.getInstance().getRootPath(rootId);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile == null ? null : PsiManager.getInstance((Project)project).findDirectory(virtualFile);
    }

    private static class MyPsiNode
    extends BasePsiNode<PsiFileSystemItem>
    implements NavigatableWithText {
        private final RootType myRootType;

        MyPsiNode(@NotNull Project project, RootType rootId, @NotNull PsiFileSystemItem value) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchProjectViewPane$MyPsiNode", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/scratch/ScratchProjectViewPane$MyPsiNode", "<init>"));
            }
            super(project, value, ViewSettings.DEFAULT);
            this.myRootType = rootId;
        }

        public boolean isAlwaysLeaf() {
            PsiFileSystemItem value = (PsiFileSystemItem)this.getValue();
            return value != null && !value.isDirectory();
        }

        @Override
        @Nullable
        protected Collection<AbstractTreeNode> getChildrenImpl() {
            if (this.isAlwaysLeaf()) {
                return Collections.emptyList();
            }
            final ArrayList list = ContainerUtil.newArrayList();
            PsiFileSystemItem value = (PsiFileSystemItem)this.getValue();
            if (value != null) {
                value.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchProjectViewPane$MyPsiNode$1", "execute"));
                        }
                        list.add(new MyPsiNode(MyPsiNode.this.getProject(), MyPsiNode.this.myRootType, element));
                        return true;
                    }
                });
            }
            return list;
        }

        @Override
        protected void updateImpl(PresentationData data) {
            VirtualFile virtualFile;
            PsiFileSystemItem value = (PsiFileSystemItem)this.getValue();
            VirtualFile virtualFile2 = virtualFile = value == null ? null : value.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                data.setIcon(value.getIcon(0));
                data.setPresentableText((String)ObjectUtils.chooseNotNull((Object)this.myRootType.substituteName(this.getProject(), virtualFile), (Object)virtualFile.getName()));
            }
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return null;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchProjectViewPane$MyPsiNode", "contains"));
            }
            PsiFileSystemItem value = (PsiFileSystemItem)this.getValue();
            if (!(value instanceof PsiDirectory)) {
                return super.contains(file);
            }
            PsiDirectory dir = (PsiDirectory)value;
            return VfsUtilCore.isAncestor((VirtualFile)dir.getVirtualFile(), (VirtualFile)file, (boolean)false) && !FileTypeRegistry.getInstance().isFileIgnored(file);
        }
    }

    private static class MyRootNode
    extends AbstractTreeNode<RootType> {
        MyRootNode(Project project, RootType type) {
            super(project, (Object)type);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            RootType rootType = (RootType)this.getValue();
            PsiDirectory directory = ScratchProjectViewPane.getDirectory(this.getProject(), rootType);
            if (directory == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode", "getChildren"));
                }
                return list;
            }
            Collection<AbstractTreeNode> collection = new MyPsiNode(this.getProject(), rootType, (PsiFileSystemItem)directory).getChildren();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode", "getChildren"));
            }
            return collection;
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            presentation.setPresentableText(((RootType)this.getValue()).getDisplayName());
        }
    }

    private static class MyProjectNode
    extends AbstractTreeNode<Project> {
        MyProjectNode(Project project) {
            super(project, (Object)project);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList list = ContainerUtil.newArrayList();
            for (RootType rootId : RootType.getAllRootIds()) {
                if (rootId.isHidden()) continue;
                list.add(new MyRootNode(this.getProject(), rootId));
            }
            ArrayList arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode", "getChildren"));
            }
            return arrayList;
        }

        protected void update(PresentationData presentation) {
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(Project project) {
            super(project, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
            return new MyProjectNode(project);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }
    }
}

