/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.ui.laf.DarculaMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import sun.awt.AppContext;

public class DarculaLaf
extends BasicLookAndFeel {
    public static final String NAME = "Darcula";
    BasicLookAndFeel base;

    public DarculaLaf() {
        try {
            if (SystemInfo.isWindows || SystemInfo.isLinux) {
                this.base = new IdeaLaf();
            } else {
                String name = UIManager.getSystemLookAndFeelClassName();
                this.base = (BasicLookAndFeel)Class.forName(name).newInstance();
            }
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    private void callInit(String method, UIDefaults defaults) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, UIDefaults.class);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults);
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    private static void log(Exception e) {
    }

    @Override
    public UIDefaults getDefaults() {
        try {
            Font font;
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("getDefaults", new Class[0]);
            superMethod.setAccessible(true);
            UIDefaults metalDefaults = (UIDefaults)superMethod.invoke((Object)new MetalLookAndFeel(), new Object[0]);
            UIDefaults defaults = (UIDefaults)superMethod.invoke((Object)this.base, new Object[0]);
            if (SystemInfo.isLinux && !Registry.is((String)"darcula.use.native.fonts.on.linux") && (font = DarculaLaf.findFont("DejaVu Sans")) != null) {
                for (Object key : defaults.keySet()) {
                    if (!(key instanceof String) || !((String)key).endsWith(".font")) continue;
                    defaults.put(key, new FontUIResource(font.deriveFont(13.0f)));
                }
            }
            LafManagerImpl.initInputMapDefaults(defaults);
            this.initIdeaDefaults(defaults);
            this.patchStyledEditorKit(defaults);
            DarculaLaf.patchComboBox(metalDefaults, defaults);
            defaults.remove("Spinner.arrowButtonBorder");
            defaults.put("Spinner.arrowButtonSize", new Dimension(16, 5));
            MetalLookAndFeel.setCurrentTheme(this.createMetalTheme());
            if (SystemInfo.isWindows) {
                // empty if block
            }
            defaults.put("EditorPane.font", defaults.getFont("TextField.font"));
            return defaults;
        }
        catch (Exception e) {
            DarculaLaf.log(e);
            return super.getDefaults();
        }
    }

    protected DefaultMetalTheme createMetalTheme() {
        return new DarculaMetalTheme();
    }

    private static Font findFont(String name) {
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!font.getName().equals(name)) continue;
            return font;
        }
        return null;
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    private void patchStyledEditorKit(UIDefaults defaults) {
        URL url = this.getClass().getResource(this.getPrefix() + ".css");
        StyleSheet styleSheet = UIUtil.loadStyleSheet((URL)url);
        defaults.put("StyledEditorKit.JBDefaultStyle", styleSheet);
        try {
            Field keyField = HTMLEditorKit.class.getDeclaredField("DEFAULT_STYLES_KEY");
            keyField.setAccessible(true);
            AppContext.getAppContext().put(keyField.get(null), UIUtil.loadStyleSheet((URL)url));
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    protected String getPrefix() {
        return "darcula";
    }

    private void call(String method) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, new Class[0]);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, new Object[0]);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public void initComponentDefaults(UIDefaults defaults) {
        this.callInit("initComponentDefaults", defaults);
    }

    protected void initIdeaDefaults(UIDefaults defaults) {
        this.loadDefaults(defaults);
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "meta A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}));
    }

    protected void loadDefaults(UIDefaults defaults) {
        Properties properties = new Properties();
        String osSuffix = SystemInfo.isMac ? "mac" : (SystemInfo.isWindows ? "windows" : "linux");
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.getPrefix() + ".properties");
            properties.load(stream);
            stream.close();
            stream = this.getClass().getResourceAsStream(this.getPrefix() + "_" + osSuffix + ".properties");
            properties.load(stream);
            stream.close();
            HashMap darculaGlobalSettings = new HashMap();
            String prefix = this.getPrefix() + ".";
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith(prefix)) continue;
                darculaGlobalSettings.put((Object)key.substring(prefix.length()), this.parseValue(key, properties.getProperty(key)));
            }
            for (String key : defaults.keySet()) {
                String s;
                String darculaKey;
                if (!(key instanceof String) || !key.contains(".") || !darculaGlobalSettings.containsKey((Object)(darculaKey = (s = key).substring(s.lastIndexOf(46) + 1)))) continue;
                defaults.put(key, darculaGlobalSettings.get((Object)darculaKey));
            }
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                defaults.put(key, this.parseValue(key, value));
            }
        }
        catch (IOException e) {
            DarculaLaf.log(e);
        }
    }

    protected Object parseValue(String key, @NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/ui/laf/darcula/DarculaLaf", "parseValue"));
        }
        if ("null".equals(value)) {
            return null;
        }
        if (key.endsWith("Insets")) {
            return DarculaLaf.parseInsets(value);
        }
        if (key.endsWith("Border") || key.endsWith("border")) {
            try {
                if (StringUtil.split((String)value, (String)",").size() == 4) {
                    return new BorderUIResource.EmptyBorderUIResource(DarculaLaf.parseInsets(value));
                }
                return Class.forName(value).newInstance();
            }
            catch (Exception e) {
                DarculaLaf.log(e);
            }
        } else {
            Icon icon;
            Color color = DarculaLaf.parseColor(value);
            Integer invVal = DarculaLaf.getInteger(value);
            Boolean boolVal = "true".equals(value) ? Boolean.TRUE : ("false".equals(value) ? Boolean.FALSE : null);
            Icon icon2 = icon = value.startsWith("AllIcons.") ? IconLoader.getIcon((String)value) : null;
            if (icon == null && value.endsWith(".png")) {
                icon = IconLoader.findIcon((String)value, this.getClass(), (boolean)true);
            }
            if (color != null) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (icon != null) {
                return new IconUIResource(icon);
            }
            if (boolVal != null) {
                return boolVal;
            }
        }
        return value;
    }

    private static Insets parseInsets(String value) {
        List numbers = StringUtil.split((String)value, (String)",");
        return new InsetsUIResource(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2)), Integer.parseInt((String)numbers.get(3)));
    }

    private static Color parseColor(String value) {
        if (value != null && value.length() == 8) {
            Color color = ColorUtil.fromHex((String)value.substring(0, 6));
            if (color != null) {
                try {
                    int alpha = Integer.parseInt(value.substring(6, 8), 16);
                    return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        return ColorUtil.fromHex((String)value, null);
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return "IntelliJ Dark Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults defaults) {
        this.callInit("initSystemColorDefaults", defaults);
    }

    @Override
    protected void initClassDefaults(UIDefaults defaults) {
        this.callInit("initClassDefaults", defaults);
    }

    @Override
    public void initialize() {
        this.call("initialize");
    }

    @Override
    public void uninitialize() {
        this.call("uninitialize");
    }

    @Override
    protected void loadSystemColors(UIDefaults defaults, String[] systemColors, boolean useNative) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("loadSystemColors", UIDefaults.class, String[].class, Boolean.TYPE);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults, systemColors, useNative);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }
}

