/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class StateStorageManagerImpl
implements StateStorageManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(StateStorageManagerImpl.class);
    private static final boolean ourHeadlessEnvironment;
    private final Map<String, String> myMacros = new LinkedHashMap<String, String>();
    private final Lock myStorageLock = new ReentrantLock();
    private final Map<String, StateStorage> myStorages = new THashMap();
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    private final String myRootTagName;
    private final PicoContainer myPicoContainer;
    private StreamProvider myStreamProvider;
    private static final Pattern MACRO_PATTERN;

    public StateStorageManagerImpl(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, String rootTagName, @Nullable Disposable parentDisposable, PicoContainer picoContainer) {
        this.myPicoContainer = picoContainer;
        this.myRootTagName = rootTagName;
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    @Override
    public TrackingPathMacroSubstitutor getMacroSubstitutor() {
        return this.myPathMacroSubstitutor;
    }

    @Override
    public synchronized void addMacro(@NotNull String macro, @NotNull String expansion) {
        if (macro == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "addMacro"));
        }
        if (expansion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expansion", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "addMacro"));
        }
        assert (!macro.isEmpty());
        if (macro.charAt(0) != '$') {
            LOG.warn("Add macros instead of macro name: " + macro);
            expansion = '$' + macro + '$';
        }
        this.myMacros.put(macro, expansion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StateStorage getStateStorage(@NotNull Storage storageSpec) {
        if (storageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        String key = StateStorageManagerImpl.getStorageSpecId(storageSpec);
        this.myStorageLock.lock();
        StateStorage stateStorage = this.myStorages.get(key);
        if (stateStorage == null) {
            stateStorage = this.createStateStorage(storageSpec);
            this.myStorages.put(key, stateStorage);
        }
        StateStorage stateStorage2 = stateStorage;
        StateStorage stateStorage3 = stateStorage2;
        if (stateStorage3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        return stateStorage3;
        finally {
            this.myStorageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StateStorage getStateStorage(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStateStorage"));
        }
        this.myStorageLock.lock();
        try {
            StateStorage stateStorage = this.myStorages.get(fileSpec);
            if (stateStorage == null) {
                stateStorage = this.createFileStateStorage(fileSpec, roamingType);
                this.myStorages.put(fileSpec, stateStorage);
            }
            StateStorage stateStorage2 = stateStorage;
            return stateStorage2;
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Couple<Collection<FileBasedStorage>> getCachedFileStateStorages(@NotNull Collection<String> changed, @NotNull Collection<String> deleted) {
        if (changed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStateStorages"));
        }
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStateStorages"));
        }
        this.myStorageLock.lock();
        Couple couple = Couple.of(this.getCachedFileStorages(changed), this.getCachedFileStorages(deleted));
        Couple couple2 = couple;
        if (couple2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStateStorages"));
        }
        return couple2;
        finally {
            this.myStorageLock.unlock();
        }
    }

    @NotNull
    private Collection<FileBasedStorage> getCachedFileStorages(@NotNull Collection<String> fileSpecs) {
        if (fileSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpecs", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStorages"));
        }
        if (fileSpecs.isEmpty()) {
            List<FileBasedStorage> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStorages"));
            }
            return list;
        }
        SmartList result = null;
        for (String fileSpec : fileSpecs) {
            StateStorage storage = this.myStorages.get(fileSpec);
            if (!(storage instanceof FileBasedStorage)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((FileBasedStorage)storage);
        }
        List<FileBasedStorage> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getCachedFileStorages"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<String> getStorageFileNames() {
        this.myStorageLock.lock();
        Set<String> set = this.myStorages.keySet();
        Set<String> set2 = set;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getStorageFileNames"));
        }
        return set2;
        finally {
            this.myStorageLock.unlock();
        }
    }

    @NotNull
    private StateStorage createStateStorage(Storage storageSpec) {
        if (!storageSpec.storageClass().equals(StateStorage.class)) {
            String key = UUID.randomUUID().toString();
            ((MutablePicoContainer)this.myPicoContainer).registerComponentImplementation((Object)key, storageSpec.storageClass());
            StateStorage stateStorage = (StateStorage)this.myPicoContainer.getComponentInstance((Object)key);
            if (stateStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createStateStorage"));
            }
            return stateStorage;
        }
        if (!storageSpec.stateSplitter().equals(StateSplitter.class)) {
            StateSplitter splitter = (StateSplitter)ReflectionUtil.newInstance((Class)storageSpec.stateSplitter(), (Class[])new Class[0]);
            DirectoryBasedStorage directoryBasedStorage = new DirectoryBasedStorage(this.myPathMacroSubstitutor, this.expandMacros(storageSpec.file()), splitter, this, this.createStorageTopicListener());
            if (directoryBasedStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createStateStorage"));
            }
            return directoryBasedStorage;
        }
        StateStorage stateStorage = this.createFileStateStorage(storageSpec.file(), storageSpec.roamingType());
        if (stateStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createStateStorage"));
        }
        return stateStorage;
    }

    private static String getStorageSpecId(Storage storageSpec) {
        if (!storageSpec.storageClass().equals(StateStorage.class)) {
            return storageSpec.storageClass().getName();
        }
        return storageSpec.file();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStateStorage(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "clearStateStorage"));
        }
        this.myStorageLock.lock();
        try {
            this.myStorages.remove(file);
        }
        finally {
            this.myStorageLock.unlock();
        }
    }

    @NotNull
    private StateStorage createFileStateStorage(@NotNull String fileSpec, @Nullable RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createFileStateStorage"));
        }
        String filePath = this.expandMacros(fileSpec);
        if (!ourHeadlessEnvironment && PathUtilRt.getFileName((String)filePath).lastIndexOf(46) < 0) {
            throw new IllegalArgumentException("Extension is missing for storage file: " + filePath);
        }
        if (roamingType == RoamingType.PER_USER && fileSpec.equals("$WORKSPACE_FILE$")) {
            roamingType = RoamingType.DISABLED;
        }
        this.beforeFileBasedStorageCreate();
        FileBasedStorage fileBasedStorage = new FileBasedStorage(filePath, fileSpec, roamingType, this.getMacroSubstitutor(fileSpec), this.myRootTagName, this, this.createStorageTopicListener(), this.myStreamProvider){

            @Override
            @NotNull
            protected StorageData createStorageData() {
                StorageData storageData = StateStorageManagerImpl.this.createStorageData(this.myFileSpec, this.getFilePath());
                if (storageData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$1", "createStorageData"));
                }
                return storageData;
            }

            @Override
            protected boolean isUseXmlProlog() {
                return StateStorageManagerImpl.this.isUseXmlProlog();
            }
        };
        if (fileBasedStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "createFileStateStorage"));
        }
        return fileBasedStorage;
    }

    @Nullable
    protected StateStorage.Listener createStorageTopicListener() {
        MessageBus messageBus = (MessageBus)this.myPicoContainer.getComponentInstanceOfType(MessageBus.class);
        return messageBus == null ? null : (StateStorage.Listener)messageBus.syncPublisher(StateStorage.STORAGE_TOPIC);
    }

    protected boolean isUseXmlProlog() {
        return true;
    }

    protected void beforeFileBasedStorageCreate() {
    }

    @Override
    @Nullable
    public final StreamProvider getStreamProvider() {
        return this.myStreamProvider;
    }

    protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getMacroSubstitutor"));
        }
        return this.myPathMacroSubstitutor;
    }

    protected abstract StorageData createStorageData(@NotNull String var1, @NotNull String var2);

    @Override
    @NotNull
    public synchronized String expandMacros(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "expandMacros"));
        }
        Matcher matcher = MACRO_PATTERN.matcher(file);
        while (matcher.find()) {
            String m = matcher.group(1);
            if (this.myMacros.containsKey(m)) continue;
            throw new IllegalArgumentException("Unknown macro: " + m + " in storage file spec: " + file);
        }
        String expanded = file;
        for (String macro : this.myMacros.keySet()) {
            expanded = StringUtil.replace((String)expanded, (String)macro, (String)this.myMacros.get(macro));
        }
        String string = expanded;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "expandMacros"));
        }
        return string;
    }

    @Override
    @NotNull
    public String collapseMacros(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "collapseMacros"));
        }
        String result = path;
        for (String macro : this.myMacros.keySet()) {
            result = StringUtil.replace((String)result, (String)this.myMacros.get(macro), (String)macro);
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "collapseMacros"));
        }
        return string;
    }

    @Override
    @NotNull
    public StateStorageManager.ExternalizationSession startExternalization() {
        StateStorageManagerExternalizationSession stateStorageManagerExternalizationSession = new StateStorageManagerExternalizationSession();
        if (stateStorageManagerExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "startExternalization"));
        }
        return stateStorageManagerExternalizationSession;
    }

    @Override
    @Nullable
    public StateStorage getOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getOldStorage"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getOldStorage"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl", "getOldStorage"));
        }
        String oldStorageSpec = this.getOldStorageSpec(component, componentName, operation);
        return oldStorageSpec == null ? null : this.getStateStorage(oldStorageSpec, component instanceof RoamingTypeDisabled ? RoamingType.DISABLED : RoamingType.PER_USER);
    }

    @Nullable
    protected abstract String getOldStorageSpec(@NotNull Object var1, @NotNull String var2, @NotNull StateStorageOperation var3);

    public void dispose() {
    }

    @Override
    public void setStreamProvider(@Nullable StreamProvider streamProvider) {
        this.myStreamProvider = streamProvider;
    }

    static {
        Application app = ApplicationManager.getApplication();
        ourHeadlessEnvironment = app.isHeadlessEnvironment() || app.isUnitTestMode();
        MACRO_PATTERN = Pattern.compile("(\\$[^\\$]*\\$)");
    }

    protected class StateStorageManagerExternalizationSession
    implements StateStorageManager.ExternalizationSession {
        final Map<StateStorage, StateStorage.ExternalizationSession> mySessions = new LinkedHashMap<StateStorage, StateStorage.ExternalizationSession>();

        protected StateStorageManagerExternalizationSession() {
        }

        @Override
        public void setState(@NotNull Storage[] storageSpecs, @NotNull Object component, @NotNull String componentName, @NotNull Object state) {
            if (storageSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpecs", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setState"));
            }
            for (Storage storageSpec : storageSpecs) {
                StateStorage stateStorage = StateStorageManagerImpl.this.getStateStorage(storageSpec);
                StateStorage.ExternalizationSession session = this.getExternalizationSession(stateStorage);
                if (session == null) continue;
                session.setState(component, componentName, storageSpec.deprecated() ? new Element("empty") : state, storageSpec);
            }
        }

        @Override
        public void setStateInOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull Object state) {
            StateStorage.ExternalizationSession session;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setStateInOldStorage"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setStateInOldStorage"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "setStateInOldStorage"));
            }
            StateStorage stateStorage = StateStorageManagerImpl.this.getOldStorage(component, componentName, StateStorageOperation.WRITE);
            if (stateStorage != null && (session = this.getExternalizationSession(stateStorage)) != null) {
                session.setState(component, componentName, state, null);
            }
        }

        @Nullable
        private StateStorage.ExternalizationSession getExternalizationSession(@NotNull StateStorage stateStorage) {
            if (stateStorage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStorage", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "getExternalizationSession"));
            }
            StateStorage.ExternalizationSession session = this.mySessions.get(stateStorage);
            if (session == null && (session = stateStorage.startExternalization()) != null) {
                this.mySessions.put(stateStorage, session);
            }
            return session;
        }

        @Override
        @NotNull
        public List<StateStorage.SaveSession> createSaveSessions() {
            if (this.mySessions.isEmpty()) {
                List<StateStorage.SaveSession> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "createSaveSessions"));
                }
                return list;
            }
            List saveSessions = null;
            Collection<StateStorage.ExternalizationSession> externalizationSessions = this.mySessions.values();
            for (StateStorage.ExternalizationSession session : externalizationSessions) {
                StateStorage.SaveSession saveSession = session.createSaveSession();
                if (saveSession == null) continue;
                if (saveSessions == null) {
                    if (externalizationSessions.size() == 1) {
                        List<StateStorage.SaveSession> list = Collections.singletonList(saveSession);
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "createSaveSessions"));
                        }
                        return list;
                    }
                    saveSessions = new SmartList();
                }
                saveSessions.add(saveSession);
            }
            List list = ContainerUtil.notNullize(saveSessions);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StateStorageManagerImpl$StateStorageManagerExternalizationSession", "createSaveSessions"));
            }
            return list;
        }
    }
}

