/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.store.StateStorageBase;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementStorage
extends StateStorageBase<StorageData> {
    @NotNull
    protected final String myRootElementName;
    protected StorageData myLoadedData;
    protected final StreamProvider myStreamProvider;
    protected final String myFileSpec;
    protected boolean myBlockSavingTheContent;
    protected final RoamingType myRoamingType;

    protected XmlElementStorage(@NotNull String fileSpec, @Nullable RoamingType roamingType, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull String rootElementName, @Nullable StreamProvider streamProvider) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        super(pathMacroSubstitutor);
        this.myBlockSavingTheContent = false;
        this.myFileSpec = fileSpec;
        this.myRoamingType = roamingType == null ? RoamingType.PER_USER : roamingType;
        this.myRootElementName = rootElementName;
        this.myStreamProvider = this.myRoamingType == RoamingType.DISABLED ? null : streamProvider;
    }

    @Nullable
    protected abstract Element loadLocalData();

    @Override
    @Nullable
    protected Element getStateAndArchive(@NotNull StorageData storageData, @NotNull String componentName) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStateAndArchive"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStateAndArchive"));
        }
        return storageData.getStateAndArchive(componentName);
    }

    @Override
    @NotNull
    protected StorageData getStorageData(boolean reloadData) {
        if (this.myLoadedData != null && !reloadData) {
            StorageData storageData = this.myLoadedData;
            if (storageData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStorageData"));
            }
            return storageData;
        }
        StorageData storageData = this.myLoadedData = this.loadData(true);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStorageData"));
        }
        return storageData;
    }

    @NotNull
    protected StorageData loadData(boolean useProvidersData) {
        Element element;
        StorageData result = this.createStorageData();
        if (useProvidersData && this.myStreamProvider != null && this.myStreamProvider.isEnabled()) {
            StorageData storageData;
            try {
                Element element2 = this.loadDataFromStreamProvider();
                if (element2 != null) {
                    this.loadState(result, element2);
                }
                storageData = result;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            if (storageData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadData"));
            }
            return storageData;
        }
        if ((element = this.loadLocalData()) != null) {
            this.loadState(result, element);
        }
        StorageData storageData = result;
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadData"));
        }
        return storageData;
    }

    @Nullable
    protected final Element loadDataFromStreamProvider() throws IOException, JDOMException {
        assert (this.myStreamProvider != null);
        return JDOMUtil.load((InputStream)this.myStreamProvider.loadContent(this.myFileSpec, this.myRoamingType));
    }

    protected final void loadState(@NotNull StorageData result, @NotNull Element element) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadState"));
        }
        result.load(element, this.myPathMacroSubstitutor, true);
    }

    @NotNull
    protected StorageData createStorageData() {
        StorageData storageData = new StorageData(this.myRootElementName);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "createStorageData"));
        }
        return storageData;
    }

    public void setDefaultState(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "setDefaultState"));
        }
        this.myLoadedData = this.createStorageData();
        this.loadState(this.myLoadedData, element);
    }

    @Nullable
    public final XmlElementStorageSaveSession startExternalization() {
        return this.checkIsSavingDisabled() ? null : this.createSaveSession((StorageData)this.getStorageData());
    }

    protected abstract XmlElementStorageSaveSession createSaveSession(@NotNull StorageData var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Element getElement(@NotNull StorageData data, boolean collapsePaths, @NotNull Map<String, Element> newLiveStates) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getElement"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getElement"));
        }
        Element element = data.save(newLiveStates);
        if (element == null || JDOMUtil.isEmpty((Element)element)) {
            return null;
        }
        if (collapsePaths && this.myPathMacroSubstitutor != null) {
            try {
                this.myPathMacroSubstitutor.collapsePaths(element);
            }
            finally {
                this.myPathMacroSubstitutor.reset();
            }
        }
        return element;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Collection<VirtualFile> changedFiles, @NotNull Set<String> result) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        StorageData oldData = this.myLoadedData;
        StorageData newData = this.getStorageData(true);
        if (oldData == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("analyzeExternalChangesAndUpdateIfNeed: old data null, load new for " + this.toString());
            }
            result.addAll(newData.getComponentNames());
        } else {
            Set<String> changedComponentNames = oldData.getChangedComponentNames(newData, this.myPathMacroSubstitutor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("analyzeExternalChangesAndUpdateIfNeed: changedComponentNames + " + changedComponentNames + " for " + this.toString());
            }
            if (!ContainerUtil.isEmpty(changedComponentNames)) {
                result.addAll(changedComponentNames);
            }
        }
    }

    protected abstract class XmlElementStorageSaveSession
    implements StateStorage.SaveSession,
    StateStorage.ExternalizationSession {
        private final StorageData myOriginalStorageData;
        private StorageData myCopiedStorageData;
        private final Map<String, Element> myNewLiveStates;

        public XmlElementStorageSaveSession(StorageData storageData) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "<init>"));
            }
            this.myNewLiveStates = new THashMap();
            this.myOriginalStorageData = storageData;
        }

        @Nullable
        public final StateStorage.SaveSession createSaveSession() {
            return XmlElementStorage.this.checkIsSavingDisabled() || this.myCopiedStorageData == null ? null : this;
        }

        public final void setState(@NotNull Object component, @NotNull String componentName, @NotNull Object state, @Nullable Storage storageSpec) {
            Element element;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setState"));
            }
            try {
                element = DefaultStateSerializer.serializeState(state, storageSpec);
            }
            catch (WriteExternalException e) {
                LOG.debug((Throwable)e);
                return;
            }
            catch (Throwable e) {
                LOG.error("Unable to serialize " + componentName + " state", e);
                return;
            }
            if (this.myCopiedStorageData == null) {
                this.myCopiedStorageData = StorageData.setStateAndCloneIfNeed(componentName, element, this.myOriginalStorageData, this.myNewLiveStates);
            } else {
                this.myCopiedStorageData.setState(componentName, element, this.myNewLiveStates);
            }
        }

        public void forceSave() {
            LOG.assertTrue(this.myCopiedStorageData == null);
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return;
            }
            try {
                this.doSave(XmlElementStorage.this.getElement(this.myOriginalStorageData, this.isCollapsePathsOnSave(), Collections.<String, Element>emptyMap()));
            }
            catch (IOException e) {
                throw new StateStorageException((Throwable)e);
            }
        }

        public final void save() {
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return;
            }
            try {
                this.doSave(XmlElementStorage.this.getElement(this.myCopiedStorageData, this.isCollapsePathsOnSave(), this.myNewLiveStates));
                XmlElementStorage.this.myLoadedData = this.myCopiedStorageData;
            }
            catch (IOException e) {
                throw new StateStorageException((Throwable)e);
            }
        }

        protected boolean isCollapsePathsOnSave() {
            return true;
        }

        protected abstract void doSave(@Nullable Element var1) throws IOException;

        protected void saveForProvider(@Nullable BufferExposingByteArrayOutputStream content, @Nullable Element element) throws IOException {
            if (!XmlElementStorage.this.myStreamProvider.isApplicable(XmlElementStorage.this.myFileSpec, XmlElementStorage.this.myRoamingType)) {
                return;
            }
            if (element == null) {
                XmlElementStorage.this.myStreamProvider.delete(XmlElementStorage.this.myFileSpec, XmlElementStorage.this.myRoamingType);
            } else {
                this.doSaveForProvider(element, XmlElementStorage.this.myRoamingType, content);
            }
        }

        private void doSaveForProvider(@NotNull Element element, @NotNull RoamingType roamingType, @Nullable BufferExposingByteArrayOutputStream content) throws IOException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "doSaveForProvider"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "doSaveForProvider"));
            }
            if (content == null) {
                StorageUtil.sendContent(XmlElementStorage.this.myStreamProvider, XmlElementStorage.this.myFileSpec, element, roamingType, true);
            } else {
                XmlElementStorage.this.myStreamProvider.saveContent(XmlElementStorage.this.myFileSpec, content.getInternalBuffer(), content.size(), XmlElementStorage.this.myRoamingType, true);
            }
        }
    }
}

