/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.util.registry.Registry;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ShortcutTextField
extends JTextField {
    private KeyStroke myKeyStroke;

    public ShortcutTextField() {
        this.enableEvents(8L);
        this.setFocusTraversalKeysEnabled(false);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            int keyCode = e.getKeyCode();
            if (keyCode == 16 || keyCode == 18 || keyCode == 17 || keyCode == 65406 || keyCode == 157) {
                return;
            }
            this.setKeyStroke(KeyStroke.getKeyStroke(keyCode, e.getModifiers()));
        }
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.myKeyStroke = keyStroke;
        this.setText(KeyboardShortcutDialog.getTextByKeyStroke(keyStroke));
        this.updateCurrentKeyStrokeInfo();
    }

    protected void updateCurrentKeyStrokeInfo() {
    }

    public KeyStroke getKeyStroke() {
        return this.myKeyStroke;
    }

    @Override
    public void enableInputMethods(boolean enable) {
        super.enableInputMethods(enable && Registry.is((String)"ide.settings.keymap.input.method.enabled"));
    }
}

