/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.options.AbstractSchemesManager;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManagerFactoryImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends AbstractSchemesManager<T, E> {
    private static final Logger LOG = Logger.getInstance(SchemesManagerFactoryImpl.class);
    private static final String NAME = "name";
    private final String myFileSpec;
    private final SchemeProcessor<E> myProcessor;
    private final RoamingType myRoamingType;
    private final StreamProvider myProvider;
    private final File myIoDir;
    private VirtualFile myDir;
    private String mySchemeExtension;
    private boolean myUpgradeExtension;
    private final Set<String> myFilesToDelete;

    public SchemesManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType, @Nullable StreamProvider provider, @NotNull File baseDir) {
        VirtualFileTracker virtualFileTracker;
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        this.mySchemeExtension = ".xml";
        this.myFilesToDelete = new THashSet();
        this.myFileSpec = fileSpec;
        this.myProcessor = processor;
        this.myRoamingType = roamingType;
        this.myProvider = provider;
        this.myIoDir = baseDir;
        if (processor instanceof SchemeExtensionProvider) {
            this.mySchemeExtension = ((SchemeExtensionProvider)processor).getSchemeExtension();
            this.myUpgradeExtension = ((SchemeExtensionProvider)processor).isUpgradeNeeded();
        }
        if ((virtualFileTracker = (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class)) != null) {
            String baseDirPath = this.myIoDir.getAbsolutePath().replace(File.separatorChar, '/');
            virtualFileTracker.addTracker("file://" + baseDirPath, (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    ExternalizableScheme readScheme;
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "contentsChanged"));
                    }
                    if (event.getRequestor() != null || !SchemesManagerImpl.this.isMy(event)) {
                        return;
                    }
                    ExternalizableScheme scheme = SchemesManagerImpl.this.findSchemeFor(event.getFile().getName());
                    Scheme oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                        SchemesManagerImpl.this.removeScheme(scheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                    }
                    if ((readScheme = SchemesManagerImpl.this.readSchemeFromFile(event.getFile(), true, Collections.emptyMap())) != null) {
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                        Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        if (oldCurrentScheme != null && newCurrentScheme == null) {
                            SchemesManagerImpl.this.setCurrentSchemeName(readScheme.getName());
                            newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        }
                        if (oldCurrentScheme != newCurrentScheme) {
                            SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                        }
                    }
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    ExternalizableScheme readScheme;
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "fileCreated"));
                    }
                    if (event.getRequestor() == null && SchemesManagerImpl.this.isMy(event) && (readScheme = SchemesManagerImpl.this.readSchemeFromFile(event.getFile(), true, Collections.emptyMap())) != null) {
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                    }
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "fileDeleted"));
                    }
                    if (event.getRequestor() == null && SchemesManagerImpl.this.isMy(event)) {
                        ExternalizableScheme scheme = SchemesManagerImpl.this.findSchemeFor(event.getFile().getName());
                        Scheme oldCurrentScheme = null;
                        if (scheme != null) {
                            oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                            SchemesManagerImpl.this.removeScheme(scheme);
                            SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                        }
                        Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        if (oldCurrentScheme != null && newCurrentScheme == null && !SchemesManagerImpl.this.mySchemes.isEmpty()) {
                            SchemesManagerImpl.this.setCurrentSchemeName(((Scheme)SchemesManagerImpl.this.mySchemes.get(0)).getName());
                            newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        }
                        if (oldCurrentScheme != newCurrentScheme) {
                            SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                        }
                    }
                }
            }, false, (Disposable)ApplicationManager.getApplication());
        }
    }

    private boolean isMy(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl", "isMy"));
        }
        return StringUtilRt.endsWithIgnoreCase((CharSequence)event.getFile().getNameSequence(), (CharSequence)this.mySchemeExtension);
    }

    @NotNull
    public Collection<E> loadSchemes() {
        LinkedHashMap result = new LinkedHashMap();
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            this.readSchemesFromProviders(result);
        } else {
            VirtualFile[] files;
            VirtualFile dir = this.getVirtualDir();
            VirtualFile[] virtualFileArray = files = dir == null ? null : dir.getChildren();
            if (files != null) {
                for (VirtualFile file : files) {
                    Object scheme = this.readSchemeFromFile(file, false, Collections.emptyMap());
                    if (scheme == null) continue;
                    result.put(scheme.getName(), scheme);
                }
            }
        }
        Collection list = result.values();
        for (ExternalizableScheme scheme : list) {
            this.myProcessor.initScheme(scheme);
            this.checkCurrentScheme((Scheme)scheme);
        }
        Collection collection = list;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "loadSchemes"));
        }
        return collection;
    }

    private E findSchemeFor(@NotNull String ioFileName) {
        if (ioFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFileName", "com/intellij/openapi/options/SchemesManagerImpl", "findSchemeFor"));
        }
        for (Scheme scheme : this.mySchemes) {
            if (!(scheme instanceof ExternalizableScheme) || !ioFileName.equals(((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName() + this.mySchemeExtension)) continue;
            return (E)((ExternalizableScheme)scheme);
        }
        return null;
    }

    @Nullable
    private static Element loadElementOrNull(@Nullable InputStream stream) {
        try {
            return JDOMUtil.load((InputStream)stream);
        }
        catch (JDOMException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private void readSchemesFromProviders(@NotNull Map<String, E> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/options/SchemesManagerImpl", "readSchemesFromProviders"));
        }
        assert (this.myProvider != null);
        for (String subPath : this.myProvider.listSubFiles(this.myFileSpec, this.myRoamingType)) {
            try {
                String currentFileName;
                Element element = SchemesManagerImpl.loadElementOrNull(this.myProvider.loadContent(this.getFileFullPath(subPath), this.myRoamingType));
                if (element == null) {
                    return;
                }
                Object scheme = this.readScheme(element, Collections.emptyMap());
                boolean fileRenamed = false;
                assert (scheme != null);
                Object existing = this.findSchemeByName(scheme.getName());
                if (existing instanceof ExternalizableScheme && (currentFileName = ((ExternalizableScheme)existing).getExternalInfo().getCurrentFileName()) != null && !currentFileName.equals(subPath)) {
                    this.deleteServerFile(subPath);
                    subPath = currentFileName;
                    fileRenamed = true;
                }
                String fileName = this.checkFileNameIsFree(subPath, scheme.getName());
                if (!fileRenamed && !fileName.equals(subPath)) {
                    this.deleteServerFile(subPath);
                }
                this.loadScheme(scheme, false, fileName);
                scheme.getExternalInfo().markRemote();
                result.put(scheme.getName(), scheme);
            }
            catch (Exception e) {
                LOG.info("Cannot load data from stream provider: " + e.getMessage());
            }
        }
    }

    @NotNull
    private String checkFileNameIsFree(@NotNull String subPath, @NotNull String schemeName) {
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subPath", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
        }
        if (schemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
        }
        for (Scheme scheme : this.mySchemes) {
            String name;
            if (!(scheme instanceof ExternalizableScheme) || (name = ((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName()) == null || schemeName.equals(scheme.getName()) || subPath.length() != name.length() + this.mySchemeExtension.length() || !subPath.startsWith(name) || !subPath.endsWith(this.mySchemeExtension)) continue;
            String string = UniqueNameGenerator.generateUniqueName((String)FileUtil.sanitizeName((String)schemeName), this.collectAllFileNames());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
            }
            return string;
        }
        String string = subPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
        }
        return string;
    }

    @NotNull
    private Collection<String> collectAllFileNames() {
        THashSet result = new THashSet();
        for (Scheme scheme : this.mySchemes) {
            ExternalInfo externalInfo;
            if (!(scheme instanceof ExternalizableScheme) || (externalInfo = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName() == null) continue;
            result.add(externalInfo.getCurrentFileName());
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "collectAllFileNames"));
        }
        return tHashSet;
    }

    private void loadScheme(@NotNull E scheme, boolean forceAdd, @NotNull CharSequence fileName) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "loadScheme"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/options/SchemesManagerImpl", "loadScheme"));
        }
        String fileNameWithoutExtension = this.createFileName(fileName);
        if (!forceAdd && this.myFilesToDelete.contains(fileNameWithoutExtension)) {
            return;
        }
        Object existing = this.findSchemeByName(scheme.getName());
        if (existing != null) {
            if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                LOG.warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
            }
            this.mySchemes.remove(existing);
            if (this.isExternalizable(existing)) {
                this.myProcessor.onSchemeDeleted((ExternalizableScheme)existing);
            }
        }
        this.addNewScheme(scheme, true);
        scheme.getExternalInfo().setPreviouslySavedName(scheme.getName());
        scheme.getExternalInfo().setCurrentFileName(fileNameWithoutExtension);
    }

    private boolean canRead(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl", "canRead"));
        }
        if (!file.isDirectory()) {
            if (this.myUpgradeExtension && !".xml".equals(this.mySchemeExtension) && DirectoryStorageData.isStorageFile(file)) {
                return this.myDir.findChild(file.getNameSequence() + this.mySchemeExtension) == null;
            }
            if (StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.mySchemeExtension)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private E readSchemeFromFile(final @NotNull VirtualFile file, boolean forceAdd, @NotNull Map<String, E> filter) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl", "readSchemeFromFile"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/options/SchemesManagerImpl", "readSchemeFromFile"));
        }
        if (!this.canRead(file)) {
            return null;
        }
        try {
            Element element;
            try {
                element = JDOMUtil.load((InputStream)file.getInputStream());
            }
            catch (JDOMException e) {
                try {
                    File initialIOFile = new File(this.myIoDir, file.getName());
                    if (initialIOFile.isFile()) {
                        FileUtil.copy((File)initialIOFile, (File)new File(this.myIoDir, file.getName() + ".copy"));
                    }
                }
                catch (IOException e1) {
                    LOG.info((Throwable)e1);
                }
                LOG.info("Error reading file " + file.getPath() + ": " + e.getMessage());
                throw e;
            }
            E scheme = this.readScheme(element, filter);
            if (scheme != null) {
                this.loadScheme(scheme, forceAdd, file.getNameSequence());
                return scheme;
            }
        }
        catch (Exception e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String msg = "Cannot read scheme " + file.getName() + "  from '" + SchemesManagerImpl.this.myFileSpec + "': " + e.getLocalizedMessage();
                    LOG.info(msg, (Throwable)e);
                    Messages.showErrorDialog((String)msg, (String)"Load Settings");
                }
            });
        }
        return null;
    }

    @Nullable
    private E readScheme(@NotNull Element element, @NotNull Map<String, E> filter) throws InvalidDataException, IOException, JDOMException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/options/SchemesManagerImpl", "readScheme"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/options/SchemesManagerImpl", "readScheme"));
        }
        if (element.getName().equals("shared-scheme")) {
            Element sharedElement;
            String schemeName = element.getAttributeValue(NAME);
            if (filter.containsKey(schemeName)) {
                return null;
            }
            String schemePath = element.getAttributeValue("original-scheme-path");
            Element element2 = sharedElement = this.myProvider != null && this.myProvider.isEnabled() ? SchemesManagerImpl.loadElementOrNull(this.myProvider.loadContent(schemePath, this.myRoamingType)) : null;
            if (sharedElement == null) {
                Element localCopyElement = element.getChild("scheme-local-copy");
                Object scheme = localCopyElement == null ? null : this.doReadScheme((Element)localCopyElement.getChildren().get(0));
                return scheme == null || filter.containsKey(scheme.getName()) ? null : scheme;
            }
            Object result = this.readScheme(sharedElement, Collections.emptyMap());
            if (result != null) {
                this.renameScheme(result, schemeName);
            }
            return (E)result;
        }
        if (element.getName().equals("shared-scheme-original")) {
            E scheme = this.doReadScheme((Element)element.getChildren().get(0));
            if (scheme == null || filter.containsKey(scheme.getName())) {
                return null;
            }
            this.renameScheme(scheme, element.getAttributeValue(NAME));
            return scheme;
        }
        E scheme = this.doReadScheme(element);
        return scheme == null || filter.containsKey(scheme.getName()) ? null : (E)scheme;
    }

    @Nullable
    private E doReadScheme(Element element) throws InvalidDataException, IOException, JDOMException {
        ExternalizableScheme scheme = this.myProcessor instanceof BaseSchemeProcessor ? ((BaseSchemeProcessor)this.myProcessor).readScheme(element) : this.myProcessor.readScheme(new Document((Element)element.detach()));
        if (scheme != null) {
            scheme.getExternalInfo().setHash(JDOMUtil.getTreeHash((Element)element));
        }
        return (E)scheme;
    }

    @NotNull
    private String createFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/options/SchemesManagerImpl", "createFileName"));
        }
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.mySchemeExtension)) {
            fileName = fileName.subSequence(0, fileName.length() - this.mySchemeExtension.length());
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            fileName = fileName.subSequence(0, fileName.length() - ".xml".length());
        }
        String string = ((Object)fileName).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "createFileName"));
        }
        return string;
    }

    public void updateConfigFilesFromStreamProviders() {
    }

    private String getFileFullPath(@NotNull String subPath) {
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subPath", "com/intellij/openapi/options/SchemesManagerImpl", "getFileFullPath"));
        }
        return this.myFileSpec + '/' + subPath;
    }

    public boolean isImportAvailable() {
        return false;
    }

    public void save() {
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        for (Scheme scheme : this.mySchemes) {
            if (!(scheme instanceof ExternalizableScheme) || !this.myProcessor.shouldBeSaved((ExternalizableScheme)scheme)) continue;
            hasSchemes = true;
            ExternalizableScheme eScheme = (ExternalizableScheme)scheme;
            String fileName = eScheme.getExternalInfo().getCurrentFileName();
            if (fileName == null || SchemesManagerImpl.isRenamed(eScheme)) continue;
            nameGenerator.addExistingName(fileName);
        }
        VirtualFile dir = this.getVirtualDir();
        if (!hasSchemes) {
            this.myFilesToDelete.clear();
            if (dir != null && dir.exists()) {
                try {
                    StorageUtil.deleteFile(this, dir);
                }
                catch (IOException e) {
                    throw new StateStorageException((Throwable)e);
                }
            }
            return;
        }
        for (final Scheme scheme : this.mySchemes) {
            ExternalizableScheme eScheme;
            if (!this.isExternalizable(scheme) || !this.myProcessor.shouldBeSaved(eScheme = (ExternalizableScheme)scheme)) continue;
            try {
                this.saveScheme(eScheme, nameGenerator);
            }
            catch (Exception e) {
                Application app = ApplicationManager.getApplication();
                if (app.isUnitTestMode() || app.isCommandLine()) {
                    LOG.error("Cannot write scheme " + scheme.getName() + " in '" + this.myFileSpec + "': " + e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
                app.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)("Cannot save scheme '" + scheme.getName() + ": " + e.getMessage()), (String)"Save Settings");
                    }
                });
            }
        }
        this.deleteFiles(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScheme(@NotNull E scheme, @NotNull UniqueNameGenerator nameGenerator) throws WriteExternalException, IOException {
        String fileSpec;
        boolean renamed;
        Element element;
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "saveScheme"));
        }
        if (nameGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameGenerator", "com/intellij/openapi/options/SchemesManagerImpl", "saveScheme"));
        }
        ExternalInfo externalInfo = scheme.getExternalInfo();
        String currentFileNameWithoutExtension = externalInfo.getCurrentFileName();
        Parent parent = this.myProcessor.writeScheme(scheme);
        Element element2 = element = parent == null || parent instanceof Element ? (Element)parent : ((Document)parent).detachRootElement();
        if (JDOMUtil.isEmpty((Element)element)) {
            ContainerUtilRt.addIfNotNull(this.myFilesToDelete, (Object)currentFileNameWithoutExtension);
            return;
        }
        String fileNameWithoutExtension = currentFileNameWithoutExtension;
        if (fileNameWithoutExtension == null || SchemesManagerImpl.isRenamed(scheme)) {
            fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeName((String)scheme.getName()));
        }
        String fileName = fileNameWithoutExtension + this.mySchemeExtension;
        int newHash = JDOMUtil.getTreeHash((Element)element);
        if (currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.getHash()) {
            return;
        }
        this.myFilesToDelete.remove(fileNameWithoutExtension);
        BufferExposingByteArrayOutputStream byteOut = StorageUtil.writeToBytes((Parent)element, "\n");
        boolean bl = renamed = currentFileNameWithoutExtension != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension);
        if (!externalInfo.isRemote()) {
            VirtualFile file = null;
            if (renamed && (file = this.myDir.findChild(currentFileNameWithoutExtension + this.mySchemeExtension)) != null) {
                AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
                try {
                    file.rename((Object)this, fileName);
                }
                finally {
                    token.finish();
                }
            }
            if (file == null) {
                if (this.myDir == null || !this.myDir.isValid()) {
                    this.myDir = DirectoryBasedStorage.createDir(this.myIoDir, this);
                }
                file = DirectoryBasedStorage.getFile(fileName, this.myDir, this);
            }
            OutputStream out = file.getOutputStream((Object)this);
            try {
                byteOut.writeTo(out);
            }
            finally {
                out.close();
            }
        }
        if (renamed) {
            this.myFilesToDelete.add(currentFileNameWithoutExtension);
        }
        externalInfo.setHash(newHash);
        externalInfo.setPreviouslySavedName(scheme.getName());
        externalInfo.setCurrentFileName(this.createFileName(fileName));
        if (this.myProvider != null && this.myProvider.isEnabled() && this.myProvider.isApplicable(fileSpec = this.getFileFullPath(fileName), this.myRoamingType)) {
            this.myProvider.saveContent(fileSpec, byteOut.getInternalBuffer(), byteOut.size(), this.myRoamingType, true);
        }
    }

    private static boolean isRenamed(@NotNull ExternalizableScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "isRenamed"));
        }
        return !scheme.getName().equals(scheme.getExternalInfo().getPreviouslySavedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFiles(@Nullable VirtualFile dir) {
        if (this.myFilesToDelete.isEmpty()) {
            return;
        }
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            for (String nameWithoutExtension : this.myFilesToDelete) {
                this.deleteServerFile(nameWithoutExtension + this.mySchemeExtension);
                if (".xml".equals(this.mySchemeExtension)) continue;
                this.deleteServerFile(nameWithoutExtension + ".xml");
            }
        }
        if (dir != null) {
            AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
            try {
                for (VirtualFile file : dir.getChildren()) {
                    if (!this.myFilesToDelete.contains(file.getNameWithoutExtension())) continue;
                    DirectoryBasedStorage.deleteFile(file, this);
                }
                this.myFilesToDelete.clear();
            }
            finally {
                token.finish();
            }
        }
    }

    @Nullable
    private VirtualFile getVirtualDir() {
        VirtualFile virtualFile = this.myDir;
        if (virtualFile == null) {
            this.myDir = virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.myIoDir);
        }
        return virtualFile;
    }

    public File getRootDirectory() {
        return this.myIoDir;
    }

    private void deleteServerFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/options/SchemesManagerImpl", "deleteServerFile"));
        }
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            StorageUtil.delete(this.myProvider, this.getFileFullPath(path), this.myRoamingType);
        }
    }

    @Override
    protected void onSchemeDeleted(@NotNull Scheme toDelete) {
        if (toDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDelete", "com/intellij/openapi/options/SchemesManagerImpl", "onSchemeDeleted"));
        }
        super.onSchemeDeleted(toDelete);
        if (toDelete instanceof ExternalizableScheme) {
            ContainerUtilRt.addIfNotNull(this.myFilesToDelete, (Object)((ExternalizableScheme)toDelete).getExternalInfo().getCurrentFileName());
        }
    }

    @Override
    protected void onSchemeAdded(@NotNull T scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "onSchemeAdded"));
        }
        if (scheme instanceof ExternalizableScheme) {
            String fileName = ((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName();
            if (fileName != null) {
                this.myFilesToDelete.remove(fileName);
            }
            if (this.myProvider != null && this.myProvider.isEnabled()) {
                ((ExternalizableScheme)scheme).getExternalInfo().markRemote();
            }
        }
    }
}

