/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;

public class SourceRootPresentation {
    @NotNull
    public static Icon getSourceRootIcon(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFolder", "com/intellij/openapi/roots/ui/configuration/SourceRootPresentation", "getSourceRootIcon"));
        }
        Icon icon = SourceRootPresentation.getSourceRootIcon(sourceFolder.getJpsElement().asTyped());
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/SourceRootPresentation", "getSourceRootIcon"));
        }
        return icon;
    }

    @NotNull
    private static <P extends JpsElement> Icon getSourceRootIcon(@NotNull JpsTypedModuleSourceRoot<P> root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/ui/configuration/SourceRootPresentation", "getSourceRootIcon"));
        }
        ModuleSourceRootEditHandler<JpsElement> handler = ModuleSourceRootEditHandler.getEditHandler(root.getRootType());
        Icon icon = handler.getRootIcon(root.getProperties());
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/SourceRootPresentation", "getSourceRootIcon"));
        }
        return icon;
    }
}

