/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JComponent;

public class CommitLegendPanel {
    private final SimpleColoredComponent myRootPanel;
    private final InfoCalculator myInfoCalculator;

    public CommitLegendPanel(InfoCalculator infoCalculator) {
        this.myInfoCalculator = infoCalculator;
        this.myRootPanel = new SimpleColoredComponent();
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public void update() {
        int deleted = this.myInfoCalculator.getDeleted();
        int modified = this.myInfoCalculator.getModified();
        int cntNew = this.myInfoCalculator.getNew();
        this.myRootPanel.clear();
        if (cntNew > 0) {
            this.appendText(cntNew, this.myInfoCalculator.getIncludedNew(), FileStatus.ADDED, "commit.legend.new");
            if (modified > 0 || deleted > 0) {
                this.appendSpace();
            }
        }
        if (modified > 0) {
            this.appendText(modified, this.myInfoCalculator.getIncludedModified(), FileStatus.MODIFIED, "commit.legend.modified");
            if (deleted > 0) {
                this.appendSpace();
            }
        }
        if (deleted > 0) {
            this.appendText(deleted, this.myInfoCalculator.getIncludedDeleted(), FileStatus.DELETED, "commit.legend.deleted");
        }
    }

    private void appendText(int total, int included, FileStatus fileStatus, String labelKey) {
        String pattern = total == included ? "%s %d" : "%s %d of %d";
        String text = String.format(pattern, VcsBundle.message((String)labelKey, (Object[])new Object[0]), included, total);
        this.myRootPanel.append(text, new SimpleTextAttributes(0, fileStatus.getColor()));
    }

    private void appendSpace() {
        this.myRootPanel.append("   ");
    }

    public static interface InfoCalculator {
        public int getNew();

        public int getModified();

        public int getDeleted();

        public int getIncludedNew();

        public int getIncludedModified();

        public int getIncludedDeleted();
    }
}

