/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FileHistorySessionPartner
implements VcsAppendableHistorySessionPartner {
    private final LimitHistoryCheck myLimitHistoryCheck;
    private FileHistoryPanelImpl myFileHistoryPanel;
    private final VcsHistoryProvider myVcsHistoryProvider;
    private final AnnotationProvider myAnnotationProvider;
    private final FilePath myPath;
    private final String myRepositoryPath;
    private final AbstractVcs myVcs;
    private final FileHistoryRefresherI myRefresherI;
    private volatile VcsAbstractHistorySession mySession;
    private final BufferedListConsumer<VcsFileRevision> myBuffer;

    public FileHistorySessionPartner(VcsHistoryProvider vcsHistoryProvider, AnnotationProvider annotationProvider, FilePath path, String repositoryPath, AbstractVcs vcs, FileHistoryRefresherI refresherI) {
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myAnnotationProvider = annotationProvider;
        this.myPath = path;
        this.myLimitHistoryCheck = new LimitHistoryCheck(vcs.getProject(), path.getPath());
        this.myRepositoryPath = repositoryPath;
        this.myVcs = vcs;
        this.myRefresherI = refresherI;
        Consumer<List<VcsFileRevision>> sessionRefresher = new Consumer<List<VcsFileRevision>>(){

            public void consume(List<VcsFileRevision> vcsFileRevisions) {
                FileHistorySessionPartner.this.mySession.getRevisionList().addAll(vcsFileRevisions);
                final VcsHistorySession copy = FileHistorySessionPartner.this.mySession.copyWithCachedRevision();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileHistorySessionPartner.this.ensureHistoryPanelCreated().getHistoryPanelRefresh().consume((Object)copy);
                    }
                });
            }
        };
        this.myBuffer = new BufferedListConsumer<VcsFileRevision>(5, (Consumer)sessionRefresher, 1000){

            @Override
            protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
                if (consumerRunnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerRunnable", "com/intellij/openapi/vcs/history/FileHistorySessionPartner$2", "invokeConsumer"));
                }
                consumerRunnable.run();
            }
        };
    }

    public void acceptRevision(VcsFileRevision revision) {
        this.myLimitHistoryCheck.checkNumber();
        this.myBuffer.consumeOne(revision);
    }

    private FileHistoryPanelImpl ensureHistoryPanelCreated() {
        if (this.myFileHistoryPanel == null) {
            ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myVcs.getProject()).getContentManager();
            VcsHistorySession copy = this.mySession.copyWithCachedRevision();
            this.myFileHistoryPanel = new FileHistoryPanelImpl(this.myVcs, this.myPath, copy, this.myVcsHistoryProvider, contentManager, this.myRefresherI);
        }
        return this.myFileHistoryPanel;
    }

    private FileHistoryPanelImpl resetHistoryPanel() {
        VcsHistorySession copy = this.mySession.copyWithCachedRevision();
        if (this.myFileHistoryPanel == null) {
            ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myVcs.getProject()).getContentManager();
            this.myFileHistoryPanel = new FileHistoryPanelImpl(this.myVcs, this.myPath, copy, this.myVcsHistoryProvider, contentManager, this.myRefresherI);
        } else {
            this.myFileHistoryPanel.getHistoryPanelRefresh().consume((Object)copy);
        }
        return this.myFileHistoryPanel;
    }

    public void reportCreatedEmptySession(VcsAbstractHistorySession session) {
        if (this.mySession != null && session != null && ((Object)this.mySession.getRevisionList()).equals(session.getRevisionList())) {
            return;
        }
        this.mySession = session;
        if (this.mySession != null) {
            this.mySession.shouldBeRefreshed();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String actionName = VcsBundle.message((String)(FileHistorySessionPartner.this.myPath.isDirectory() ? "action.name.file.history.dir" : "action.name.file.history"), (Object[])new Object[]{FileHistorySessionPartner.this.myPath.getName()});
                ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(FileHistorySessionPartner.this.myVcs.getProject()).getContentManager();
                FileHistorySessionPartner.this.myFileHistoryPanel = FileHistorySessionPartner.this.resetHistoryPanel();
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)FileHistorySessionPartner.this.myVcs.getProject()).getToolWindow(ToolWindowId.VCS);
                assert (toolWindow != null) : "Version Control ToolWindow should be available at this point.";
                ContentUtilEx.addTabbedContent(toolWindow.getContentManager(), (JComponent)((Object)FileHistorySessionPartner.this.myFileHistoryPanel), "History", FileHistorySessionPartner.this.myFileHistoryPanel.getVirtualFile().getName(), FileHistorySessionPartner.this.myRefresherI.isFirstTime());
                if (FileHistorySessionPartner.this.myRefresherI.isFirstTime()) {
                    toolWindow.activate(null);
                }
            }
        });
    }

    public void reportException(VcsException exception) {
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myVcs.getProject(), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]) + ": " + exception.getMessage(), MessageType.ERROR);
    }

    public void beforeRefresh() {
        this.myLimitHistoryCheck.reset();
    }

    public void finished() {
        this.myBuffer.flush();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FileHistorySessionPartner.this.mySession == null) {
                    return;
                }
                FileHistorySessionPartner.this.ensureHistoryPanelCreated().getHistoryPanelRefresh().finished();
            }
        });
    }

    public void forceRefresh() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FileHistorySessionPartner.this.mySession == null) {
                    return;
                }
                FileHistorySessionPartner.this.ensureHistoryPanelCreated().scheduleRefresh(false);
            }
        });
    }
}

