/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilePointerPartNode {
    private static final FilePointerPartNode[] EMPTY_ARRAY = new FilePointerPartNode[0];
    @NotNull
    private String part;
    @NotNull
    private FilePointerPartNode[] children;
    private FilePointerPartNode parent;
    VirtualFilePointerImpl leaf;
    volatile Pair<VirtualFile, String> myFileAndUrl;
    private volatile long myLastUpdated;
    volatile int useCount;
    private int pointersUnder;
    private static final VirtualFileManager ourFileManager = VirtualFileManager.getInstance();
    private static final boolean UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();

    FilePointerPartNode(@NotNull String part, FilePointerPartNode parent, Pair<VirtualFile, String> fileAndUrl) {
        if (part == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "part", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "<init>"));
        }
        this.myLastUpdated = -1L;
        this.pointersUnder = 1;
        this.part = part;
        this.parent = parent;
        this.children = EMPTY_ARRAY;
        this.myFileAndUrl = fileAndUrl;
    }

    public String toString() {
        return this.part + (this.children.length == 0 ? "" : " -> " + this.children.length);
    }

    int position(@Nullable VirtualFile parent, @Nullable CharSequence parentName, boolean separator, @NotNull CharSequence childName, @NotNull FilePointerPartNode[] outNode) {
        int index;
        int partStart;
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "position"));
        }
        if (outNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outNode", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "position"));
        }
        this.checkConsistency();
        if (parent == null) {
            partStart = 0;
            outNode[0] = this;
        } else {
            VirtualFile gParent;
            CharSequence gParentName = (gParent = parent.getParent()) == null ? null : gParent.getNameSequence();
            partStart = this.position(gParent, gParentName, gParentName != null && !StringUtil.equals((CharSequence)gParentName, (CharSequence)"/"), parentName, outNode);
            if (partStart == -1) {
                return -1;
            }
        }
        boolean childSeparator = false;
        if (separator) {
            if (partStart == outNode[0].part.length()) {
                childSeparator = true;
            } else {
                int sepIndex = FilePointerPartNode.indexOfFirstDifferentChar("/", 0, outNode[0].part, partStart);
                if (sepIndex != 1) {
                    return -1;
                }
                ++partStart;
            }
        }
        if ((index = FilePointerPartNode.indexOfFirstDifferentChar(childName, 0, outNode[0].part, partStart)) == childName.length()) {
            return partStart + index;
        }
        if (partStart + index == outNode[0].part.length()) {
            for (FilePointerPartNode child : outNode[0].children) {
                int childPos = child.position(null, null, childSeparator, childName.subSequence(index, childName.length()), outNode);
                if (childPos == -1) continue;
                return childPos;
            }
        }
        return -1;
    }

    void getPointersUnder(@Nullable VirtualFile parent, boolean separator, @NotNull CharSequence childName, @NotNull List<FilePointerPartNode> out) {
        FilePointerPartNode[] outNode;
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "getPointersUnder"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "getPointersUnder"));
        }
        CharSequence parentName = parent == null ? null : parent.getNameSequence();
        int position = this.position(parent, parentName, separator, childName, outNode = new FilePointerPartNode[1]);
        if (position != -1) {
            FilePointerPartNode node = outNode[0];
            FilePointerPartNode.addAllPointersUnder(node, out);
        }
    }

    private static void addAllPointersUnder(@NotNull FilePointerPartNode node, @NotNull List<FilePointerPartNode> out) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "addAllPointersUnder"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "addAllPointersUnder"));
        }
        if (node.leaf != null) {
            out.add(node);
        }
        for (FilePointerPartNode child : node.children) {
            FilePointerPartNode.addAllPointersUnder(child, out);
        }
    }

    boolean getPointersUnder(@NotNull String path, int start, @NotNull List<FilePointerPartNode> out) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "getPointersUnder"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "getPointersUnder"));
        }
        this.checkConsistency();
        if (this.pointersUnder == 0) {
            return false;
        }
        int index = this.indexOfFirstDifferentChar(path, start);
        if (index - start == this.part.length() || index == path.length()) {
            if (index == path.length() && this.leaf != null) {
                out.add(this);
            }
            for (FilePointerPartNode child : this.children) {
                child.getPointersUnder(path, index, out);
            }
        }
        return false;
    }

    void checkConsistency() {
        if (UNIT_TEST && !ApplicationInfoImpl.isInPerformanceTest()) {
            this.doCheckConsistency();
        }
    }

    private void doCheckConsistency() {
        int childSum = 0;
        for (FilePointerPartNode child : this.children) {
            childSum += child.pointersUnder;
            child.doCheckConsistency();
            assert (child.parent == this);
        }
        if (this.leaf != null) {
            ++childSum;
        }
        assert (this.useCount == 0 == (this.leaf == null)) : this.useCount + " - " + (Object)((Object)this.leaf);
        assert (this.pointersUnder == childSum) : "expected: " + this.pointersUnder + "; actual: " + childSum;
    }

    @NotNull
    FilePointerPartNode findPointerOrCreate(@NotNull String path, int start, @NotNull Pair<VirtualFile, String> fileAndUrl) {
        FilePointerPartNode[] filePointerPartNodeArray;
        String pathRest;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
        }
        if (fileAndUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAndUrl", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
        }
        int index = this.indexOfFirstDifferentChar(path, start);
        if (index == path.length() && index - start == this.part.length()) {
            if (this.leaf == null) {
                ++this.pointersUnder;
            }
            FilePointerPartNode filePointerPartNode = this;
            if (filePointerPartNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
            }
            return filePointerPartNode;
        }
        if (index - start == this.part.length()) {
            for (FilePointerPartNode child : this.children) {
                int i = child.indexOfFirstDifferentChar(path, index);
                if (i == index || i <= index + 1 && path.charAt(index) == '/') continue;
                FilePointerPartNode node = child.findPointerOrCreate(path, index, fileAndUrl);
                if (node.leaf == null) {
                    ++this.pointersUnder;
                }
                FilePointerPartNode filePointerPartNode = node;
                if (filePointerPartNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
                }
                return filePointerPartNode;
            }
            String pathRest2 = path.substring(index);
            FilePointerPartNode newNode = new FilePointerPartNode(pathRest2, this, fileAndUrl);
            this.children = (FilePointerPartNode[])ArrayUtil.append((Object[])this.children, (Object)newNode);
            ++this.pointersUnder;
            FilePointerPartNode filePointerPartNode = newNode;
            if (filePointerPartNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
            }
            return filePointerPartNode;
        }
        if (index > start && index != path.length() && path.charAt(index - 1) == '/') {
            --index;
        }
        FilePointerPartNode newNode = (pathRest = path.substring(index)).isEmpty() ? this : new FilePointerPartNode(pathRest, this, fileAndUrl);
        String commonPredecessor = StringUtil.first((String)this.part, (int)(index - start), (boolean)false);
        FilePointerPartNode splittedAway = new FilePointerPartNode(this.part.substring(index - start), this, this.myFileAndUrl);
        splittedAway.children = this.children;
        for (FilePointerPartNode child : this.children) {
            child.parent = splittedAway;
        }
        splittedAway.pointersUnder = this.pointersUnder;
        splittedAway.useCount = this.useCount;
        splittedAway.associate(this.leaf, this.myFileAndUrl);
        this.associate(null, null);
        this.useCount = 0;
        this.part = commonPredecessor;
        if (newNode == this) {
            FilePointerPartNode[] filePointerPartNodeArray2 = new FilePointerPartNode[1];
            filePointerPartNodeArray = filePointerPartNodeArray2;
            filePointerPartNodeArray2[0] = splittedAway;
        } else {
            FilePointerPartNode[] filePointerPartNodeArray3 = new FilePointerPartNode[2];
            filePointerPartNodeArray3[0] = splittedAway;
            filePointerPartNodeArray = filePointerPartNodeArray3;
            filePointerPartNodeArray3[1] = newNode;
        }
        this.children = filePointerPartNodeArray;
        ++this.pointersUnder;
        FilePointerPartNode filePointerPartNode = newNode;
        if (filePointerPartNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "findPointerOrCreate"));
        }
        return filePointerPartNode;
    }

    boolean remove() {
        assert (this.leaf != null) : this.toString();
        this.associate(null, null);
        this.useCount = 0;
        this.myLastUpdated = -1L;
        FilePointerPartNode node = this;
        while (node.parent != null) {
            --node.pointersUnder;
            node = node.parent;
        }
        if (--node.pointersUnder == 0) {
            node.children = EMPTY_ARRAY;
            return true;
        }
        return false;
    }

    private int indexOfFirstDifferentChar(@NotNull CharSequence path, int start) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "indexOfFirstDifferentChar"));
        }
        return FilePointerPartNode.indexOfFirstDifferentChar(path, start, this.part, 0);
    }

    @NotNull
    Pair<VirtualFile, String> update() {
        Pair result;
        boolean fileIsValid;
        long lastUpdated = this.myLastUpdated;
        Pair fileAndUrl = this.myFileAndUrl;
        long fsModCount = ourFileManager.getModificationCount();
        if (lastUpdated == fsModCount) {
            Pair pair = fileAndUrl;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "update"));
            }
            return pair;
        }
        VirtualFile file = (VirtualFile)fileAndUrl.first;
        String url = (String)fileAndUrl.second;
        boolean changed = false;
        if (url == null) {
            url = file.getUrl();
            if (!file.isValid()) {
                file = null;
            }
            changed = true;
        }
        boolean bl = fileIsValid = file != null && file.isValid();
        if (file != null && !fileIsValid) {
            file = null;
            changed = true;
        }
        if (file == null) {
            file = ourFileManager.findFileByUrl(url);
            boolean bl2 = fileIsValid = file != null && file.isValid();
            if (file != null) {
                changed = true;
            }
        }
        if (file != null) {
            if (fileIsValid) {
                url = file.getUrl();
                changed |= !url.equals(fileAndUrl.second);
            } else {
                file = null;
                changed = true;
            }
        }
        if (changed) {
            this.myFileAndUrl = result = Pair.create((Object)file, (Object)url);
        } else {
            result = fileAndUrl;
        }
        this.myLastUpdated = fsModCount;
        Pair pair = result;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "update"));
        }
        return pair;
    }

    private static int indexOfFirstDifferentChar(@NotNull CharSequence s1, int start1, @NotNull String s2, int start2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "indexOfFirstDifferentChar"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/vfs/impl/FilePointerPartNode", "indexOfFirstDifferentChar"));
        }
        boolean ignoreCase = !SystemInfo.isFileSystemCaseSensitive;
        int len1 = s1.length();
        int len2 = s2.length();
        while (start1 < len1 && start2 < len2) {
            char c2;
            char c1 = s1.charAt(start1);
            if (!StringUtil.charsEqual((char)c1, (char)(c2 = s2.charAt(start2)), (boolean)ignoreCase)) {
                return start1;
            }
            ++start1;
            ++start2;
        }
        return start1;
    }

    void associate(VirtualFilePointerImpl pointer, Pair<VirtualFile, String> fileAndUrl) {
        if (pointer != null) {
            pointer.myNode = this;
        }
        this.leaf = pointer;
        this.myFileAndUrl = fileAndUrl;
        this.myLastUpdated = -1L;
    }

    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    int getPointersUnder() {
        return this.pointersUnder;
    }
}

