/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentFSImpl
extends PersistentFS
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.PersistentFS");
    private final MessageBus myEventBus;
    private final ReadWriteLock myRootsLock;
    private final Map<String, VirtualFileSystemEntry> myRoots;
    private final TIntObjectHashMap<VirtualFileSystemEntry> myRootsById;
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache;
    private final Object myInputLock;
    private final AtomicBoolean myShutDown;
    private final LowMemoryWatcher myWatcher;
    @NotNull
    private static final Comparator<EventWrapper> DEPTH_COMPARATOR = new Comparator<EventWrapper>(){

        @Override
        public int compare(@NotNull EventWrapper o1, @NotNull EventWrapper o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$6", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$6", "compare"));
            }
            return o1.event.getFileDepth() - o2.event.getFileDepth();
        }
    };
    private static final int DEPTH_LIMIT = 75;

    public PersistentFSImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "<init>"));
        }
        this.myRootsLock = new ReentrantReadWriteLock();
        this.myRoots = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        this.myRootsById = new TIntObjectHashMap();
        this.myIdToDirCache = ContainerUtil.createConcurrentIntObjectMap();
        this.myInputLock = new Object();
        this.myShutDown = new AtomicBoolean(false);
        this.myWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                PersistentFSImpl.this.clearIdCache();
            }
        });
        this.myEventBus = bus;
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                PersistentFSImpl.this.performShutdown();
            }
        });
    }

    public void initComponent() {
        FSRecords.connect();
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (this.myShutDown.compareAndSet(false, true)) {
            LOG.info("VFS dispose started");
            FSRecords.dispose();
            LOG.info("VFS dispose completed");
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("app.component.PersistentFS" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getComponentName"));
        }
        return "app.component.PersistentFS";
    }

    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "areChildrenLoaded"));
        }
        return PersistentFSImpl.areChildrenLoaded(PersistentFSImpl.getFileId(dir));
    }

    public long getCreationTimestamp() {
        return FSRecords.getCreationTimestamp();
    }

    @NotNull
    private static NewVirtualFileSystem getDelegate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getDelegate"));
        }
        NewVirtualFileSystem newVirtualFileSystem = (NewVirtualFileSystem)file.getFileSystem();
        if (newVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getDelegate"));
        }
        return newVirtualFileSystem;
    }

    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "wereChildrenAccessed"));
        }
        return FSRecords.wereChildrenAccessed(PersistentFSImpl.getFileId(dir));
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "list"));
        }
        int id = PersistentFSImpl.getFileId(file);
        Object[] nameIds = FSRecords.listAll(id);
        if (!PersistentFSImpl.areChildrenLoaded(id)) {
            nameIds = PersistentFSImpl.persistAllChildren(file, id, (FSRecords.NameId[])nameIds);
        }
        String[] stringArray = (String[])ContainerUtil.map2Array((Object[])nameIds, String.class, (Function)new Function<FSRecords.NameId, String>(){

            public String fun(FSRecords.NameId id) {
                return ((Object)id.name).toString();
            }
        });
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "list"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] listPersisted(@NotNull VirtualFile parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "listPersisted"));
        }
        String[] stringArray = PersistentFSImpl.listPersisted(FSRecords.list(PersistentFSImpl.getFileId(parent)));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "listPersisted"));
        }
        return stringArray;
    }

    @NotNull
    private static String[] listPersisted(@NotNull int[] childrenIds) {
        if (childrenIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenIds", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "listPersisted"));
        }
        String[] names = ArrayUtil.newStringArray((int)childrenIds.length);
        for (int i = 0; i < childrenIds.length; ++i) {
            names[i] = FSRecords.getName(childrenIds[i]);
        }
        if (names == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "listPersisted"));
        }
        return names;
    }

    @NotNull
    private static FSRecords.NameId[] persistAllChildren(@NotNull VirtualFile file, int id, @NotNull FSRecords.NameId[] current) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "persistAllChildren"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "persistAllChildren"));
        }
        NewVirtualFileSystem fs = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(file));
        Object[] delegateNames = VfsUtil.filterNames((String[])fs.list(file));
        if (delegateNames.length == 0 && current.length > 0) {
            if (current == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "persistAllChildren"));
            }
            return current;
        }
        HashSet toAdd = ContainerUtil.newHashSet((Object[])delegateNames);
        for (FSRecords.NameId nameId : current) {
            toAdd.remove(((Object)nameId.name).toString());
        }
        TIntArrayList childrenIds = new TIntArrayList(current.length + toAdd.size());
        ArrayList nameIds = ContainerUtil.newArrayListWithCapacity((int)(current.length + toAdd.size()));
        for (FSRecords.NameId nameId : current) {
            childrenIds.add(nameId.id);
            nameIds.add(nameId);
        }
        for (String newName : toAdd) {
            FakeVirtualFile child = new FakeVirtualFile(file, newName);
            FileAttributes attributes = fs.getAttributes((VirtualFile)child);
            if (attributes == null) continue;
            int childId = PersistentFSImpl.createAndFillRecord(fs, (VirtualFile)child, id, attributes);
            childrenIds.add(childId);
            nameIds.add(new FSRecords.NameId(childId, FileNameCache.storeName(newName), newName));
        }
        FSRecords.updateList(id, childrenIds.toNativeArray());
        PersistentFSImpl.setChildrenCached(id);
        FSRecords.NameId[] nameIdArray = nameIds.toArray(new FSRecords.NameId[nameIds.size()]);
        if (nameIdArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "persistAllChildren"));
        }
        return nameIdArray;
    }

    public static void setChildrenCached(int id) {
        int flags = FSRecords.getFlags(id);
        FSRecords.setFlags(id, flags | 1, true);
    }

    @Override
    @NotNull
    public FSRecords.NameId[] listAll(@NotNull VirtualFile parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "listAll"));
        }
        int parentId = PersistentFSImpl.getFileId(parent);
        FSRecords.NameId[] nameIds = FSRecords.listAll(parentId);
        if (!PersistentFSImpl.areChildrenLoaded(parentId)) {
            FSRecords.NameId[] nameIdArray = PersistentFSImpl.persistAllChildren(parent, parentId, nameIds);
            if (nameIdArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "listAll"));
            }
            return nameIdArray;
        }
        if (nameIds == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "listAll"));
        }
        return nameIds;
    }

    private static boolean areChildrenLoaded(int parentId) {
        return (FSRecords.getFlags(parentId) & 1) != 0;
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file, @NotNull FileAttribute att) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "readAttribute"));
        }
        if (att == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "att", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "readAttribute"));
        }
        return FSRecords.readAttributeWithLock(PersistentFSImpl.getFileId(file), att);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file, @NotNull FileAttribute att) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeAttribute"));
        }
        if (att == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "att", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeAttribute"));
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeAttribute(PersistentFSImpl.getFileId(file), att);
        if (dataOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeAttribute"));
        }
        return dataOutputStream;
    }

    @Nullable
    private static DataInputStream readContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "readContent"));
        }
        return FSRecords.readContent(PersistentFSImpl.getFileId(file));
    }

    @Nullable
    private static DataInputStream readContentById(int contentId) {
        return FSRecords.readContentById(contentId);
    }

    @NotNull
    private static DataOutputStream writeContent(@NotNull VirtualFile file, boolean readOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeContent"));
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeContent(PersistentFSImpl.getFileId(file), readOnly);
        if (dataOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeContent"));
        }
        return dataOutputStream;
    }

    private static void writeContent(@NotNull VirtualFile file, ByteSequence content, boolean readOnly) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeContent"));
        }
        FSRecords.writeContent(PersistentFSImpl.getFileId(file), content, readOnly);
    }

    @Override
    public int storeUnlinkedContent(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "storeUnlinkedContent"));
        }
        return FSRecords.storeUnlinkedContent(bytes);
    }

    public int getModificationCount(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getModificationCount"));
        }
        return FSRecords.getModCount(PersistentFSImpl.getFileId(file));
    }

    public int getCheapFileSystemModificationCount() {
        return FSRecords.getLocalModCount();
    }

    public int getFilesystemModificationCount() {
        return FSRecords.getModCount();
    }

    private static boolean writeAttributesToRecord(int id, int parentId, @NotNull VirtualFile file, @NotNull NewVirtualFileSystem fs, @NotNull FileAttributes attributes) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeAttributesToRecord"));
        }
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeAttributesToRecord"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "writeAttributesToRecord"));
        }
        String name = file.getName();
        if (!name.isEmpty() ? PersistentFSImpl.namesEqual((VirtualFileSystem)fs, name, FSRecords.getName(id)) : PersistentFSImpl.areChildrenLoaded(id)) {
            return false;
        }
        FSRecords.writeAttributesToRecord(id, parentId, attributes, name);
        return true;
    }

    @Override
    public int getFileAttributes(int id) {
        assert (id > 0);
        return FSRecords.getFlags(id);
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "isDirectory"));
        }
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.getFileId(file)));
    }

    private static int getParent(int id) {
        assert (id > 0);
        return FSRecords.getParent(id);
    }

    private static boolean namesEqual(@NotNull VirtualFileSystem fs, @NotNull String n1, String n2) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "namesEqual"));
        }
        if (n1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n1", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "namesEqual"));
        }
        return fs.isCaseSensitive() ? n1.equals(n2) : n1.equalsIgnoreCase(n2);
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDirectory", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "exists"));
        }
        return ((VirtualFileWithId)fileOrDirectory).getId() > 0;
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getTimeStamp"));
        }
        return FSRecords.getTimestamp(PersistentFSImpl.getFileId(file));
    }

    public void setTimeStamp(@NotNull VirtualFile file, long modStamp) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "setTimeStamp"));
        }
        int id = PersistentFSImpl.getFileId(file);
        FSRecords.setTimestamp(id, modStamp);
        PersistentFSImpl.getDelegate(file).setTimeStamp(file, modStamp);
    }

    private static int getFileId(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getFileId"));
        }
        int id = ((VirtualFileWithId)file).getId();
        if (id <= 0) {
            throw new InvalidVirtualFileAccessException(file);
        }
        return id;
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "isSymLink"));
        }
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.getFileId(file)));
    }

    public String resolveSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "resolveSymLink"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSpecialFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "isSpecialFile"));
        }
        return PersistentFSImpl.isSpecialFile(this.getFileAttributes(PersistentFSImpl.getFileId(file)));
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "isWritable"));
        }
        return (this.getFileAttributes(PersistentFSImpl.getFileId(file)) & 4) == 0;
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "isHidden"));
        }
        return (this.getFileAttributes(PersistentFSImpl.getFileId(file)) & 0x40) != 0;
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "setWritable"));
        }
        PersistentFSImpl.getDelegate(file).setWritable(file, writableFlag);
        boolean oldWritable = this.isWritable(file);
        if (oldWritable != writableFlag) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file, "writable", (Object)oldWritable, (Object)writableFlag, false));
        }
    }

    @Override
    public int getId(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getId"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getId"));
        }
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getId"));
        }
        int parentId = PersistentFSImpl.getFileId(parent);
        int[] children = FSRecords.list(parentId);
        if (children.length > 0) {
            int nameId = FSRecords.getNameId(childName);
            for (int childId : children) {
                if (nameId != FSRecords.getNameId(childId)) continue;
                return childId;
            }
        }
        for (int childId : children) {
            if (!PersistentFSImpl.namesEqual((VirtualFileSystem)fs, childName, FSRecords.getName(childId))) continue;
            return childId;
        }
        FakeVirtualFile fake = new FakeVirtualFile(parent, childName);
        FileAttributes attributes = fs.getAttributes((VirtualFile)fake);
        if (attributes != null) {
            int child = PersistentFSImpl.createAndFillRecord(fs, (VirtualFile)fake, parentId, attributes);
            FSRecords.updateList(parentId, ArrayUtil.append((int[])children, (int)child));
            return child;
        }
        return 0;
    }

    public long getLength(@NotNull VirtualFile file) {
        long len;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getLength"));
        }
        if (PersistentFSImpl.mustReloadContent(file)) {
            len = PersistentFSImpl.reloadLengthFromDelegate(file, PersistentFSImpl.getDelegate(file));
        } else {
            int id = PersistentFSImpl.getFileId(file);
            len = FSRecords.getLength(id);
        }
        return len;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "copyFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "copyFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "copyFile"));
        }
        PersistentFSImpl.getDelegate(file).copyFile(requestor, file, parent, name);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file, parent, name));
        VirtualFile child = parent.findChild(name);
        if (child == null) {
            throw new IOException("Cannot create child");
        }
        VirtualFile virtualFile = child;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "copyFile"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createChildDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createChildDirectory"));
        }
        PersistentFSImpl.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, dir, true, false));
        VirtualFile child = parent.findChild(dir);
        if (child == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        VirtualFile virtualFile = child;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createChildDirectory"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createChildFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createChildFile"));
        }
        PersistentFSImpl.getDelegate(parent).createChildFile(requestor, parent, file);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, file, false, false));
        VirtualFile child = parent.findChild(file);
        if (child == null) {
            throw new IOException("Cannot create child file '" + file + "' at " + parent.getPath());
        }
        VirtualFile virtualFile = child;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createChildFile"));
        }
        return virtualFile;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "deleteFile"));
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file);
        delegate.deleteFile(requestor, file);
        if (!delegate.exists(file)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file, false));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "renameFile"));
        }
        PersistentFSImpl.getDelegate(file).renameFile(requestor, file, newName);
        String oldName = file.getName();
        if (!newName.equals(oldName)) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file, "name", (Object)oldName, (Object)newName, false));
        }
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "contentsToByteArray"));
        }
        byte[] byArray = this.contentsToByteArray(file, true);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file, boolean cacheContent) throws IOException {
        byte[] byArray;
        boolean reloadFromDelegate;
        boolean outdated;
        int fileId;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "contentsToByteArray"));
        }
        DataInputStream contentStream = null;
        Object object = this.myInputLock;
        synchronized (object) {
            fileId = PersistentFSImpl.getFileId(file);
            outdated = PersistentFSImpl.checkFlag(fileId, 8) || FSRecords.getLength(fileId) == -1L;
            reloadFromDelegate = outdated || (contentStream = PersistentFSImpl.readContent(file)) == null;
        }
        if (reloadFromDelegate) {
            byte[] content;
            NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file);
            if (outdated) {
                FSRecords.setLength(fileId, delegate.getLength(file));
                content = delegate.contentsToByteArray(file);
            } else {
                content = delegate.contentsToByteArray(file);
                FSRecords.setLength(fileId, content.length);
            }
            ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
            if ((!delegate.isReadOnly() || cacheContent && !application.isInternal() && !application.isUnitTestMode()) && (long)content.length <= PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                Object object2 = this.myInputLock;
                synchronized (object2) {
                    PersistentFSImpl.writeContent(file, new ByteSequence(content), delegate.isReadOnly());
                    PersistentFSImpl.setFlag(file, 8, false);
                }
            }
            if (content == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "contentsToByteArray"));
            }
            return content;
        }
        try {
            int length = (int)file.getLength();
            assert (length >= 0) : file;
            byArray = FileUtil.loadBytes((InputStream)contentStream, (int)length);
        }
        catch (IOException e) {
            throw FSRecords.handleError(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(int contentId) throws IOException {
        DataInputStream stream = PersistentFSImpl.readContentById(contentId);
        assert (stream != null) : contentId;
        byte[] byArray = FileUtil.loadBytes((InputStream)stream);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        DataInputStream contentStream;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getInputStream"));
        }
        Object object = this.myInputLock;
        // MONITORENTER : object
        if (!PersistentFSImpl.mustReloadContent(file) && (contentStream = PersistentFSImpl.readContent(file)) != null) {
            DataInputStream dataInputStream = contentStream;
            // MONITOREXIT : object
            if (dataInputStream != null) return dataInputStream;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getInputStream"));
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file);
        long len = PersistentFSImpl.reloadLengthFromDelegate(file, delegate);
        InputStream nativeStream = delegate.getInputStream(file);
        if (len > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
            InputStream inputStream = nativeStream;
            // MONITOREXIT : object
            if (inputStream != null) return inputStream;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getInputStream"));
        }
        InputStream inputStream = this.createReplicator(file, nativeStream, len, delegate.isReadOnly());
        // MONITOREXIT : object
        if (inputStream != null) return inputStream;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getInputStream"));
    }

    private static long reloadLengthFromDelegate(@NotNull VirtualFile file, @NotNull NewVirtualFileSystem delegate) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "reloadLengthFromDelegate"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "reloadLengthFromDelegate"));
        }
        long len = delegate.getLength(file);
        FSRecords.setLength(PersistentFSImpl.getFileId(file), len);
        return len;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream createReplicator(final @NotNull VirtualFile file, InputStream nativeStream, final long fileLength, boolean bl) throws IOException {
        void readOnly;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createReplicator"));
        }
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file, (boolean)readOnly, bytes, bytes.length);
            return nativeStream;
        }
        BufferExposingByteArrayOutputStream cache = new BufferExposingByteArrayOutputStream((int)fileLength);
        return new ReplicatorInputStream(nativeStream, cache, (boolean)readOnly, cache){
            final /* synthetic */ boolean val$readOnly;
            final /* synthetic */ BufferExposingByteArrayOutputStream val$cache;
            {
                this.val$readOnly = bl;
                this.val$cache = bufferExposingByteArrayOutputStream;
                super(x0, x1);
            }

            public void close() throws IOException {
                super.close();
                PersistentFSImpl.this.storeContentToStorage(fileLength, file, this.val$readOnly, this.val$cache.getInternalBuffer(), this.val$cache.size());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file, boolean readOnly, @NotNull byte[] bytes, int n) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "storeContentToStorage"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "storeContentToStorage"));
        }
        Object object = this.myInputLock;
        synchronized (object) {
            void bytesLength;
            if ((long)bytesLength == fileLength) {
                PersistentFSImpl.writeContent(file, new ByteSequence(bytes, 0, (int)bytesLength), readOnly);
                PersistentFSImpl.setFlag(file, 8, false);
            } else {
                PersistentFSImpl.setFlag(file, 8, true);
            }
        }
    }

    private static boolean mustReloadContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "mustReloadContent"));
        }
        int fileId = PersistentFSImpl.getFileId(file);
        return PersistentFSImpl.checkFlag(fileId, 8) || FSRecords.getLength(fileId) == -1L;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file, final Object requestor, final long modStamp, long l) throws IOException {
        void timeStamp;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getOutputStream"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((long)timeStamp){
            private boolean closed;
            final /* synthetic */ long val$timeStamp;
            {
                this.val$timeStamp = l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                super.close();
                VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file, file.getModificationStamp(), modStamp, false);
                List<VFileContentChangeEvent> events = Collections.singletonList(event);
                BulkFileListener publisher = (BulkFileListener)PersistentFSImpl.this.myEventBus.syncPublisher(VirtualFileManager.VFS_CHANGES);
                publisher.before(events);
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file);
                OutputStream ioFileStream = delegate.getOutputStream(file, requestor, modStamp, this.val$timeStamp);
                DataOutputStream persistenceStream = PersistentFSImpl.writeContent(file, delegate.isReadOnly());
                try {
                    ((OutputStream)persistenceStream).write(this.buf, 0, this.count);
                }
                finally {
                    try {
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    finally {
                        this.closed = true;
                        ((OutputStream)persistenceStream).close();
                        ioFileStream.close();
                        PersistentFSImpl.executeTouch(file, false, event.getModificationStamp());
                        publisher.after(events);
                    }
                }
            }
        };
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getOutputStream"));
        }
        return byteArrayOutputStream;
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "acquireContent"));
        }
        return FSRecords.acquireFileContent(PersistentFSImpl.getFileId(file));
    }

    @Override
    public void releaseContent(int contentId) {
        FSRecords.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getCurrentContentId"));
        }
        return FSRecords.getContentId(PersistentFSImpl.getFileId(file));
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "moveFile"));
        }
        PersistentFSImpl.getDelegate(file).moveFile(requestor, file, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "processEvent"));
        }
        this.processEvents(Collections.singletonList(event));
    }

    @NotNull
    private static List<VFileEvent> validateEvents(@NotNull List<VFileEvent> events) {
        TIntHashSet invalidIDs;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "validateEvents"));
        }
        ArrayList deletionEvents = ContainerUtil.newArrayList();
        int size = events.size();
        for (int i = 0; i < size; ++i) {
            VFileEvent event = events.get(i);
            if (!(event instanceof VFileDeleteEvent) || !event.isValid()) continue;
            deletionEvents.add(new EventWrapper((VFileDeleteEvent)event, i));
        }
        if (deletionEvents.isEmpty()) {
            invalidIDs = EmptyIntHashSet.INSTANCE;
        } else {
            ContainerUtil.quickSort((List)deletionEvents, DEPTH_COMPARATOR);
            invalidIDs = new TIntHashSet(deletionEvents.size());
            THashSet dirsToBeDeleted = new THashSet(deletionEvents.size());
            block1: for (EventWrapper wrapper : deletionEvents) {
                VirtualFile candidate;
                for (VirtualFile parent = candidate = wrapper.event.getFile(); parent != null; parent = parent.getParent()) {
                    if (!dirsToBeDeleted.contains(parent)) continue;
                    invalidIDs.add(wrapper.id);
                    continue block1;
                }
                if (!candidate.isDirectory()) continue;
                dirsToBeDeleted.add(candidate);
            }
        }
        ArrayList<VFileEvent> filtered = new ArrayList<VFileEvent>(events.size() - invalidIDs.size());
        int size2 = events.size();
        for (int i = 0; i < size2; ++i) {
            VFileEvent event = events.get(i);
            if (!event.isValid() || event instanceof VFileDeleteEvent && invalidIDs.contains(i)) continue;
            filtered.add(event);
        }
        ArrayList<VFileEvent> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "validateEvents"));
        }
        return arrayList;
    }

    @Override
    public void processEvents(@NotNull List<VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "processEvents"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<VFileEvent> validated = PersistentFSImpl.validateEvents(events);
        BulkFileListener publisher = (BulkFileListener)this.myEventBus.syncPublisher(VirtualFileManager.VFS_CHANGES);
        publisher.before(validated);
        THashMap parentToChildrenEventsChanges = null;
        for (VFileEvent event : validated) {
            VirtualFile changedParent = null;
            if (event instanceof VFileCreateEvent) {
                changedParent = ((VFileCreateEvent)event).getParent();
                ((VFileCreateEvent)event).resetCache();
            } else if (event instanceof VFileDeleteEvent) {
                changedParent = ((VFileDeleteEvent)event).getFile().getParent();
            }
            if (changedParent != null) {
                List parentChildrenChanges;
                if (parentToChildrenEventsChanges == null) {
                    parentToChildrenEventsChanges = new THashMap();
                }
                if ((parentChildrenChanges = (List)parentToChildrenEventsChanges.get((Object)changedParent)) == null) {
                    parentChildrenChanges = new SmartList();
                    parentToChildrenEventsChanges.put((Object)changedParent, (Object)parentChildrenChanges);
                }
                parentChildrenChanges.add(event);
                continue;
            }
            this.applyEvent(event);
        }
        if (parentToChildrenEventsChanges != null) {
            parentToChildrenEventsChanges.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<VirtualFile, List<VFileEvent>>(){

                public boolean execute(VirtualFile parent, List<VFileEvent> childrenEvents) {
                    PersistentFSImpl.this.applyChildrenChangeEvents(parent, childrenEvents);
                    return true;
                }
            });
            parentToChildrenEventsChanges.clear();
        }
        publisher.after(validated);
    }

    private void applyChildrenChangeEvents(VirtualFile parent, List<VFileEvent> events) {
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(parent);
        TIntArrayList childrenIdsUpdated = new TIntArrayList();
        SmartList childrenToBeUpdated = new SmartList();
        int parentId = PersistentFSImpl.getFileId(parent);
        assert (parentId != 0);
        TIntHashSet parentChildrenIds = new TIntHashSet(FSRecords.list(parentId));
        boolean hasRemovedChildren = false;
        for (VFileEvent event : events) {
            if (event instanceof VFileCreateEvent) {
                String name = ((VFileCreateEvent)event).getChildName();
                FakeVirtualFile fake = new FakeVirtualFile(parent, name);
                FileAttributes attributes = delegate.getAttributes((VirtualFile)fake);
                if (attributes == null) continue;
                int childId = PersistentFSImpl.createAndFillRecord(delegate, (VirtualFile)fake, parentId, attributes);
                assert (parent instanceof VirtualDirectoryImpl) : parent;
                VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
                VirtualFileSystemEntry child = dir.createChild(name, childId, dir.getFileSystem());
                childrenToBeUpdated.add(child);
                childrenIdsUpdated.add(childId);
                parentChildrenIds.add(childId);
                continue;
            }
            if (!(event instanceof VFileDeleteEvent)) continue;
            VirtualFile file = ((VFileDeleteEvent)event).getFile();
            if (!file.exists()) {
                LOG.error("Deleting a file, which does not exist: " + file.getPath());
                continue;
            }
            hasRemovedChildren = true;
            int id = PersistentFSImpl.getFileId(file);
            childrenToBeUpdated.add(file);
            childrenIdsUpdated.add(-id);
            parentChildrenIds.remove(id);
        }
        FSRecords.updateList(parentId, parentChildrenIds.toArray());
        if (hasRemovedChildren) {
            this.clearIdCache();
        }
        VirtualDirectoryImpl parentImpl = (VirtualDirectoryImpl)parent;
        int len = childrenIdsUpdated.size();
        for (int i = 0; i < len; ++i) {
            int childId = childrenIdsUpdated.get(i);
            VirtualFile childFile = (VirtualFile)childrenToBeUpdated.get(i);
            if (childId > 0) {
                parentImpl.addChild((VirtualFileSystemEntry)childFile);
                continue;
            }
            FSRecords.deleteRecordRecursively(-childId);
            parentImpl.removeChild(childFile);
            PersistentFSImpl.invalidateSubtree(childFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String basePath, @NotNull NewVirtualFileSystem fs) {
        AbstractRoot newRoot;
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "findRoot"));
        }
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "findRoot"));
        }
        if (basePath.isEmpty()) {
            LOG.error("Invalid root, fs=" + fs);
            return null;
        }
        String rootUrl = PersistentFSImpl.normalizeRootUrl(basePath, fs);
        this.myRootsLock.readLock().lock();
        try {
            VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
            if (root != null) {
                VirtualFileSystemEntry virtualFileSystemEntry = root;
                return virtualFileSystemEntry;
            }
        }
        finally {
            this.myRootsLock.readLock().unlock();
        }
        int rootId = FSRecords.findRootRecord(rootUrl);
        VfsData.Segment segment = VfsData.getSegment(rootId, true);
        VfsData.DirectoryData directoryData = new VfsData.DirectoryData();
        if (fs instanceof JarFileSystem) {
            String parentPath = basePath.substring(0, basePath.indexOf("!/"));
            VirtualFile parentFile = LocalFileSystem.getInstance().findFileByPath(parentPath);
            if (parentFile == null) {
                return null;
            }
            FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(parentFile.getName());
            if (type != FileTypes.ARCHIVE) {
                return null;
            }
            newRoot = new JarRoot(fs, rootId, segment, directoryData, parentFile);
        } else {
            newRoot = new FsRoot(fs, rootId, segment, directoryData, basePath);
        }
        FileAttributes attributes = fs.getAttributes((VirtualFile)new StubVirtualFile(){

            @NotNull
            public String getPath() {
                String string = newRoot.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$8", "getPath"));
                }
                return string;
            }

            @Nullable
            public VirtualFile getParent() {
                return null;
            }
        });
        if (attributes == null || !attributes.isDirectory()) {
            return null;
        }
        boolean mark = false;
        this.myRootsLock.writeLock().lock();
        try {
            VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
            if (root != null) {
                VirtualFileSystemEntry virtualFileSystemEntry = root;
                return virtualFileSystemEntry;
            }
            VfsData.initFile(rootId, segment, -1, directoryData);
            mark = PersistentFSImpl.writeAttributesToRecord(rootId, 0, (VirtualFile)newRoot, fs, attributes);
            this.myRoots.put(rootUrl, newRoot);
            this.myRootsById.put(rootId, (Object)newRoot);
        }
        finally {
            this.myRootsLock.writeLock().unlock();
        }
        if (!mark && attributes.lastModified != FSRecords.getTimestamp(rootId)) {
            ((VirtualFileSystemEntry)newRoot).markDirtyRecursively();
        }
        LOG.assertTrue(rootId == newRoot.getId(), (Object)("root=" + (Object)((Object)newRoot) + " expected=" + rootId + " actual=" + newRoot.getId()));
        return newRoot;
    }

    @NotNull
    private static String normalizeRootUrl(@NotNull String basePath, @NotNull NewVirtualFileSystem fs) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "normalizeRootUrl"));
        }
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "normalizeRootUrl"));
        }
        String string = UriUtil.trimTrailingSlashes(fs.getProtocol() + "://" + VfsImplUtil.normalize(fs, FileUtil.toCanonicalPath((String)basePath)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "normalizeRootUrl"));
        }
        return string;
    }

    @Override
    public void clearIdCache() {
        this.myIdToDirCache.clear();
    }

    @Nullable
    public NewVirtualFile findFileById(int id) {
        return this.findFileById(id, false, null, 0);
    }

    @Override
    public NewVirtualFile findFileByIdIfCached(int id) {
        return this.findFileById(id, true, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry findFileById(int id, boolean cachedOnly, TIntArrayList visited, int mask) {
        VirtualFileSystemEntry old;
        VirtualFileSystemEntry result;
        VirtualFileSystemEntry cached = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
        if (cached != null) {
            return cached;
        }
        if (visited != null && (visited.size() >= 75 || (mask & id) == id && visited.contains(id))) {
            String sb = "Dead loop detected in persistent FS (id=" + id + " cached-only=" + cachedOnly + "):";
            for (int i = 0; i < visited.size(); ++i) {
                int _id = visited.get(i);
                sb = sb + "\n  " + _id + " '" + this.getName(_id) + "' " + String.format("%02x", this.getFileAttributes(_id)) + ' ' + this.myIdToDirCache.containsKey(_id);
            }
            LOG.error(sb);
            return null;
        }
        int parentId = PersistentFSImpl.getParent(id);
        if (parentId >= id && visited == null) {
            visited = new TIntArrayList(75);
        }
        if (visited != null) {
            visited.add(id);
        }
        if (parentId == 0) {
            this.myRootsLock.readLock().lock();
            try {
                result = (VirtualFileSystemEntry)((Object)this.myRootsById.get(id));
            }
            finally {
                this.myRootsLock.readLock().unlock();
            }
        } else {
            VirtualFileSystemEntry parentFile = this.findFileById(parentId, cachedOnly, visited, mask | id);
            result = parentFile instanceof VirtualDirectoryImpl ? ((VirtualDirectoryImpl)parentFile).findChildById(id, cachedOnly) : null;
        }
        if (result != null && result.isDirectory() && (old = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.put(id, (Object)result))) != null) {
            result = old;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VirtualFile[] getRoots() {
        VirtualFile[] virtualFileArray;
        block3: {
            this.myRootsLock.readLock().lock();
            Collection<VirtualFileSystemEntry> roots = this.myRoots.values();
            virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
            if (virtualFileArray != null) break block3;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getRoots"));
        }
        return virtualFileArray;
        finally {
            this.myRootsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VirtualFile[] getRoots(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getRoots"));
        }
        ArrayList<VirtualFileSystemEntry> roots = new ArrayList<VirtualFileSystemEntry>();
        this.myRootsLock.readLock().lock();
        try {
            for (VirtualFileSystemEntry root : this.myRoots.values()) {
                if (root.getFileSystem() != fs) continue;
                roots.add(root);
            }
        }
        finally {
            this.myRootsLock.readLock().unlock();
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getRoots"));
        }
        return virtualFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VirtualFile[] getLocalRoots() {
        List roots = ContainerUtil.newSmartList();
        this.myRootsLock.readLock().lock();
        try {
            for (VirtualFileSystemEntry root : this.myRoots.values()) {
                if (!root.isInLocalFileSystem() || root.getFileSystem() instanceof TempFileSystem) continue;
                roots.add(root);
            }
        }
        finally {
            this.myRootsLock.readLock().unlock();
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)roots);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "getLocalRoots"));
        }
        return virtualFileArray;
    }

    private VirtualFileSystemEntry applyEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "applyEvent"));
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                return PersistentFSImpl.executeCreateChild(createEvent.getParent(), createEvent.getChildName());
            }
            if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent.getFile());
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                PersistentFSImpl.executeTouch(contentUpdateEvent.getFile(), contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp());
            } else {
                if (event instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)event;
                    return PersistentFSImpl.executeCreateChild(copyEvent.getNewParent(), copyEvent.getNewChildName());
                }
                if (event instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                    this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
                } else if (event instanceof VFilePropertyChangeEvent) {
                    VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeRename(propertyChangeEvent.getFile(), (String)propertyChangeEvent.getNewValue());
                    } else if ("writable".equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeSetWritable(propertyChangeEvent.getFile(), (Boolean)propertyChangeEvent.getNewValue());
                    } else if (VirtualFile.PROP_HIDDEN.equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeSetHidden(propertyChangeEvent.getFile(), (Boolean)propertyChangeEvent.getNewValue());
                    } else if ("symlink".equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeSetTarget(propertyChangeEvent.getFile(), (String)propertyChangeEvent.getNewValue());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    @NonNls
    public String toString() {
        if ("PersistentFS" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "toString"));
        }
        return "PersistentFS";
    }

    private static VirtualFileSystemEntry executeCreateChild(@NotNull VirtualFile parent, @NotNull String name) {
        FakeVirtualFile fake;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeCreateChild"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeCreateChild"));
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(parent);
        FileAttributes attributes = delegate.getAttributes((VirtualFile)(fake = new FakeVirtualFile(parent, name)));
        if (attributes != null) {
            int parentId = PersistentFSImpl.getFileId(parent);
            int childId = PersistentFSImpl.createAndFillRecord(delegate, (VirtualFile)fake, parentId, attributes);
            PersistentFSImpl.appendIdToParentList(parentId, childId);
            assert (parent instanceof VirtualDirectoryImpl) : parent;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
            VirtualFileSystemEntry child = dir.createChild(name, childId, dir.getFileSystem());
            dir.addChild(child);
            return child;
        }
        return null;
    }

    private static int createAndFillRecord(@NotNull NewVirtualFileSystem delegateSystem, @NotNull VirtualFile delegateFile, int parentId, @NotNull FileAttributes attributes) {
        if (delegateSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateSystem", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createAndFillRecord"));
        }
        if (delegateFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFile", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createAndFillRecord"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "createAndFillRecord"));
        }
        int childId = FSRecords.createRecord();
        PersistentFSImpl.writeAttributesToRecord(childId, parentId, delegateFile, delegateSystem, attributes);
        return childId;
    }

    private static void appendIdToParentList(int parentId, int childId) {
        int[] childrenList = FSRecords.list(parentId);
        childrenList = ArrayUtil.append((int[])childrenList, (int)childId);
        FSRecords.updateList(parentId, childrenList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VirtualFile file) {
        int parentId;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeDelete"));
        }
        if (!file.exists()) {
            LOG.error("Deleting a file, which does not exist: " + file.getPath());
            return;
        }
        this.clearIdCache();
        int id = PersistentFSImpl.getFileId(file);
        VirtualFile parent = file.getParent();
        int n = parentId = parent == null ? 0 : PersistentFSImpl.getFileId(parent);
        if (parentId == 0) {
            String rootUrl = PersistentFSImpl.normalizeRootUrl(file.getPath(), (NewVirtualFileSystem)file.getFileSystem());
            this.myRootsLock.writeLock().lock();
            try {
                this.myRoots.remove(rootUrl);
                this.myRootsById.remove(id);
                FSRecords.deleteRootRecord(id);
            }
            finally {
                this.myRootsLock.writeLock().unlock();
            }
        } else {
            PersistentFSImpl.removeIdFromParentList(parentId, id, parent, file);
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file.getParent();
            assert (directory != null) : file;
            directory.removeChild(file);
        }
        FSRecords.deleteRecordRecursively(id);
        PersistentFSImpl.invalidateSubtree(file);
    }

    private static void invalidateSubtree(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "invalidateSubtree"));
        }
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file;
        impl.invalidate();
        for (VirtualFile child : impl.getCachedChildren()) {
            PersistentFSImpl.invalidateSubtree(child);
        }
    }

    private static void removeIdFromParentList(int parentId, int id, @NotNull VirtualFile parent, VirtualFile file) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "removeIdFromParentList"));
        }
        int[] childList = FSRecords.list(parentId);
        int index = ArrayUtil.indexOf((int[])childList, (int)id);
        if (index == -1) {
            throw new RuntimeException("Cannot find child (" + id + ")" + file + "\n\tin (" + parentId + ")" + parent + "\n\tactual children:" + Arrays.toString(childList));
        }
        childList = ArrayUtil.remove((int[])childList, (int)index);
        FSRecords.updateList(parentId, childList);
    }

    private static void executeRename(@NotNull VirtualFile file, @NotNull String newName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeRename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeRename"));
        }
        int id = PersistentFSImpl.getFileId(file);
        FSRecords.setName(id, newName);
        ((VirtualFileSystemEntry)file).setNewName(newName);
    }

    private static void executeSetWritable(@NotNull VirtualFile file, boolean writableFlag) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeSetWritable"));
        }
        PersistentFSImpl.setFlag(file, 4, !writableFlag);
        ((VirtualFileSystemEntry)file).updateProperty("writable", writableFlag);
    }

    private static void executeSetHidden(@NotNull VirtualFile file, boolean hiddenFlag) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeSetHidden"));
        }
        PersistentFSImpl.setFlag(file, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file).updateProperty(VirtualFile.PROP_HIDDEN, hiddenFlag);
    }

    private static void executeSetTarget(@NotNull VirtualFile file, String target) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeSetTarget"));
        }
        ((VirtualFileSystemEntry)file).setLinkTarget(target);
    }

    private static void setFlag(@NotNull VirtualFile file, int mask, boolean value) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "setFlag"));
        }
        PersistentFSImpl.setFlag(PersistentFSImpl.getFileId(file), mask, value);
    }

    private static void setFlag(int id, int mask, boolean value) {
        int flags;
        int oldFlags = FSRecords.getFlags(id);
        int n = flags = value ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            FSRecords.setFlags(id, flags, true);
        }
    }

    private static boolean checkFlag(int fileId, int mask) {
        return (FSRecords.getFlags(fileId) & mask) != 0;
    }

    private static void executeTouch(@NotNull VirtualFile file, boolean reloadContentFromDelegate, long newModificationStamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeTouch"));
        }
        if (reloadContentFromDelegate) {
            PersistentFSImpl.setFlag(file, 8, true);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file);
        FileAttributes attributes = delegate.getAttributes(file);
        FSRecords.setLength(PersistentFSImpl.getFileId(file), attributes != null ? attributes.length : 0L);
        FSRecords.setTimestamp(PersistentFSImpl.getFileId(file), attributes != null ? attributes.lastModified : 0L);
        ((VirtualFileSystemEntry)file).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file, @NotNull VirtualFile newParent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeMove"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl", "executeMove"));
        }
        this.clearIdCache();
        int fileId = PersistentFSImpl.getFileId(file);
        int newParentId = PersistentFSImpl.getFileId(newParent);
        int oldParentId = PersistentFSImpl.getFileId(file.getParent());
        PersistentFSImpl.removeIdFromParentList(oldParentId, fileId, file.getParent(), file);
        FSRecords.setParent(fileId, newParentId);
        PersistentFSImpl.appendIdToParentList(newParentId, fileId);
        ((VirtualFileSystemEntry)file).setParent(newParent);
    }

    @Override
    public String getName(int id) {
        assert (id > 0);
        return FSRecords.getName(id);
    }

    public void cleanPersistedContents() {
        int[] roots;
        for (int root : roots = FSRecords.listRoots()) {
            this.cleanPersistedContentsRecursively(root);
        }
    }

    private void cleanPersistedContentsRecursively(int id) {
        if (PersistentFSImpl.isDirectory(this.getFileAttributes(id))) {
            for (int child : FSRecords.list(id)) {
                this.cleanPersistedContentsRecursively(child);
            }
        } else {
            PersistentFSImpl.setFlag(id, 8, true);
        }
    }

    private static class FsRoot
    extends AbstractRoot {
        private final String myName;

        private FsRoot(@NotNull NewVirtualFileSystem fs, int id, VfsData.Segment segment, VfsData.DirectoryData data, @NotNull String basePath) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FsRoot", "<init>"));
            }
            if (basePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FsRoot", "<init>"));
            }
            super(id, segment, data, fs);
            this.myName = FileUtil.toSystemIndependentName((String)basePath);
        }

        @Override
        @NotNull
        public CharSequence getNameSequence() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FsRoot", "getNameSequence"));
            }
            return string;
        }

        @Override
        protected char[] appendPathOnFileSystem(int pathLength, int[] position) {
            boolean appendSlash;
            String name = this.getName();
            int nameLength = name.length();
            int rootPathLength = pathLength + nameLength;
            boolean bl = appendSlash = SystemInfo.isWindows && nameLength == 2 && name.charAt(1) == ':' && pathLength == 0;
            if (appendSlash) {
                ++rootPathLength;
            }
            char[] chars = new char[rootPathLength];
            position[0] = FsRoot.copyString(chars, position[0], name);
            if (appendSlash) {
                int n = position[0];
                position[0] = n + 1;
                chars[n] = 47;
            }
            return chars;
        }
    }

    private static class JarRoot
    extends AbstractRoot {
        private final VirtualFile myParentLocalFile;
        private final String myParentPath;

        private JarRoot(@NotNull NewVirtualFileSystem fs, int id, VfsData.Segment segment, VfsData.DirectoryData data, VirtualFile parentLocalFile) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$JarRoot", "<init>"));
            }
            super(id, segment, data, fs);
            this.myParentLocalFile = parentLocalFile;
            this.myParentPath = this.myParentLocalFile.getPath();
        }

        @Override
        @NotNull
        public CharSequence getNameSequence() {
            CharSequence charSequence = this.myParentLocalFile.getNameSequence();
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$JarRoot", "getNameSequence"));
            }
            return charSequence;
        }

        @Override
        protected char[] appendPathOnFileSystem(int accumulatedPathLength, int[] positionRef) {
            char[] chars = new char[this.myParentPath.length() + "!/".length() + accumulatedPathLength];
            positionRef[0] = JarRoot.copyString(chars, positionRef[0], this.myParentPath);
            positionRef[0] = JarRoot.copyString(chars, positionRef[0], "!/");
            return chars;
        }
    }

    private static abstract class AbstractRoot
    extends VirtualDirectoryImpl {
        public AbstractRoot(int id, VfsData.Segment segment, VfsData.DirectoryData data, NewVirtualFileSystem fs) {
            super(id, segment, data, null, fs);
        }

        @Override
        @NotNull
        public abstract CharSequence getNameSequence();

        @Override
        protected abstract char[] appendPathOnFileSystem(int var1, int[] var2);

        @Override
        public void setNewName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$AbstractRoot", "setNewName"));
            }
            throw new IncorrectOperationException();
        }

        @Override
        public final void setParent(@NotNull VirtualFile newParent) {
            if (newParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$AbstractRoot", "setParent"));
            }
            throw new IncorrectOperationException();
        }
    }

    private static class EventWrapper {
        private final VFileDeleteEvent event;
        private final int id;

        private EventWrapper(VFileDeleteEvent event, int id) {
            this.event = event;
            this.id = id;
        }
    }
}

