/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BackwardDependenciesBuilder
extends DependenciesBuilder {
    private final AnalysisScope myForwardScope = (AnalysisScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AnalysisScope>(){

        public AnalysisScope compute() {
            return BackwardDependenciesBuilder.this.getScope().getNarrowedComplementaryScope(BackwardDependenciesBuilder.this.getProject());
        }
    });

    public BackwardDependenciesBuilder(Project project, AnalysisScope scope) {
        this(project, scope, null);
    }

    public BackwardDependenciesBuilder(Project project, AnalysisScope scope, @Nullable AnalysisScope scopeOfInterest) {
        super(project, scope, scopeOfInterest);
        this.myFileCount = this.myForwardScope.getFileCount();
        this.myTotalFileCount = this.myFileCount + scope.getFileCount();
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisScopeBundle.message((String)"backward.dependencies.usage.view.root.node.text", (Object[])new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisScopeBundle.message((String)"backward.dependencies.usage.view.initial.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze() {
        AnalysisScope scope = this.myForwardScope;
        final ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(this.getProject(), scope, this.getScopeOfInterest());
        builder.setTotalFileCount(this.myTotalFileCount);
        ((DependenciesBuilder)builder).analyze();
        BackwardDependenciesBuilder.subtractScope(builder, this.getScope());
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        psiManager.startBatchFilesProcessingMode();
        try {
            final int fileCount = this.getScope().getFileCount();
            this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(PsiFile file) {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator != null) {
                        if (indicator.isCanceled()) {
                            throw new ProcessCanceledException();
                        }
                        indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.progress.text", (Object[])new Object[0]));
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null) {
                            indicator.setText2(BackwardDependenciesBuilder.this.getRelativeToProjectPath(virtualFile));
                        }
                        if (fileCount > 0) {
                            indicator.setFraction((double)(++BackwardDependenciesBuilder.this.myFileCount) / (double)BackwardDependenciesBuilder.this.myTotalFileCount);
                        }
                    }
                    Map<PsiFile, Set<PsiFile>> dependencies = builder.getDependencies();
                    for (PsiFile psiFile : dependencies.keySet()) {
                        if (!dependencies.get(psiFile).contains(file)) continue;
                        Set<PsiFile> fileDeps = BackwardDependenciesBuilder.this.getDependencies().get(file);
                        if (fileDeps == null) {
                            fileDeps = new HashSet<PsiFile>();
                            BackwardDependenciesBuilder.this.getDependencies().put(file, fileDeps);
                        }
                        fileDeps.add(psiFile);
                    }
                    psiManager.dropResolveCaches();
                    InjectedLanguageManager.getInstance((Project)file.getProject()).dropFileCaches(file);
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private static void subtractScope(DependenciesBuilder builders, AnalysisScope scope) {
        Map<PsiFile, Set<PsiFile>> dependencies = builders.getDependencies();
        HashSet<PsiFile> excluded = new HashSet<PsiFile>();
        for (PsiFile psiFile : dependencies.keySet()) {
            if (!scope.contains((PsiElement)psiFile)) continue;
            excluded.add(psiFile);
        }
        for (PsiFile psiFile : excluded) {
            dependencies.remove(psiFile);
        }
    }
}

