/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.projectImport.ProjectSetProcessor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSetReader {
    private static final Logger LOG = Logger.getInstance(ProjectSetReader.class);

    public void readDescriptor(@Language(value="JSON") @NotNull String descriptor, @Nullable ProjectSetProcessor.Context context) {
        JsonElement parse;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/platform/ProjectSetReader", "readDescriptor"));
        }
        ProjectSetProcessor[] extensions = (ProjectSetProcessor[])ProjectSetProcessor.EXTENSION_POINT_NAME.getExtensions();
        HashMap<String, ProjectSetProcessor> processors = new HashMap<String, ProjectSetProcessor>();
        for (ProjectSetProcessor extension : extensions) {
            processors.put(extension.getId(), extension);
        }
        try {
            parse = new JsonParser().parse(descriptor);
        }
        catch (JsonSyntaxException e) {
            LOG.error((Throwable)e);
            return;
        }
        Iterator<Map.Entry<String, JsonElement>> iterator = parse.getAsJsonObject().entrySet().iterator();
        if (context == null) {
            context = new ProjectSetProcessor.Context();
        }
        context.directoryName = "";
        ProjectSetReader.runProcessor(processors, context, iterator);
    }

    private static void runProcessor(final Map<String, ProjectSetProcessor> processors, final ProjectSetProcessor.Context context, final Iterator<Map.Entry<String, JsonElement>> iterator) {
        List list;
        if (!iterator.hasNext()) {
            return;
        }
        Map.Entry<String, JsonElement> entry = iterator.next();
        String key = entry.getKey();
        ProjectSetProcessor processor = processors.get(key);
        if (processor == null) {
            LOG.error("Processor not found for " + key);
            return;
        }
        if (entry.getValue().isJsonObject()) {
            JsonObject object = entry.getValue().getAsJsonObject();
            if (object.entrySet().size() == 1 && ((JsonElement)((Map.Entry)object.entrySet().iterator().next()).getValue()).isJsonArray()) {
                final Map.Entry next = (Map.Entry)object.entrySet().iterator().next();
                list = ContainerUtil.map((Iterable)((JsonElement)next.getValue()).getAsJsonArray(), (Function)new Function<JsonElement, Pair<String, String>>(){

                    public Pair<String, String> fun(JsonElement o) {
                        return Pair.create(next.getKey(), (Object)ProjectSetReader.getString(o));
                    }
                });
            } else {
                list = ContainerUtil.map((Collection)object.entrySet(), (Function)new Function<Map.Entry<String, JsonElement>, Pair<String, String>>(){

                    public Pair<String, String> fun(Map.Entry<String, JsonElement> entry) {
                        JsonElement value = entry.getValue();
                        return Pair.create((Object)entry.getKey(), (Object)ProjectSetReader.getString(value));
                    }
                });
            }
        } else {
            list = Collections.singletonList(Pair.create((Object)entry.getKey(), (Object)entry.getValue().getAsString()));
        }
        processor.processEntries(list, context, new Runnable(){

            @Override
            public void run() {
                ProjectSetReader.runProcessor(processors, context, iterator);
            }
        });
    }

    public static String getString(JsonElement value) {
        return value instanceof JsonPrimitive ? value.getAsString() : value.toString();
    }
}

