/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileLoadUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProfileManager", storages={@Storage(file="$APP_CONFIG$/editor.xml"), @Storage(file="$APP_CONFIG$/other.xml", deprecated=true)}, additionalExportFile="$ROOT_CONFIG$/inspection")
public class InspectionProfileManagerImpl
extends InspectionProfileManager
implements SeverityProvider,
PersistentStateComponent<Element> {
    private final InspectionToolRegistrar myRegistrar;
    private final SchemesManager<Profile, InspectionProfileImpl> mySchemesManager;
    private final AtomicBoolean myProfilesAreInitialized;
    private final SeverityRegistrar mySeverityRegistrar;
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProfileManager");
    private volatile boolean LOAD_PROFILES;

    public static InspectionProfileManagerImpl getInstanceImpl() {
        return (InspectionProfileManagerImpl)ServiceManager.getService(InspectionProfileManager.class);
    }

    public InspectionProfileManagerImpl(@NotNull InspectionToolRegistrar registrar, @NotNull SchemesManagerFactory schemesManagerFactory, @NotNull MessageBus messageBus) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "<init>"));
        }
        if (schemesManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesManagerFactory", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "<init>"));
        }
        this.myProfilesAreInitialized = new AtomicBoolean(false);
        this.LOAD_PROFILES = !ApplicationManager.getApplication().isUnitTestMode();
        this.myRegistrar = registrar;
        InspectionProfileManagerImpl.registerProvidedSeverities();
        this.mySchemesManager = schemesManagerFactory.createSchemesManager("$ROOT_CONFIG$/inspection", (SchemeProcessor)new BaseSchemeProcessor<InspectionProfileImpl>(){

            @NotNull
            public InspectionProfileImpl readScheme(@NotNull Element element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "readScheme"));
                }
                final InspectionProfileImpl profile = new InspectionProfileImpl(InspectionProfileLoadUtil.getProfileName(element), InspectionProfileManagerImpl.this.myRegistrar, (ProfileManager)InspectionProfileManagerImpl.this);
                try {
                    profile.readExternal(element);
                }
                catch (Exception ignored) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, profile.getName()}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0]));
                        }
                    }, ModalityState.NON_MODAL);
                }
                InspectionProfileImpl inspectionProfileImpl = profile;
                if (inspectionProfileImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "readScheme"));
                }
                return inspectionProfileImpl;
            }

            public boolean shouldBeSaved(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "shouldBeSaved"));
                }
                return !scheme.isProjectLevel() && scheme.wasInitialized();
            }

            public Element writeScheme(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "writeScheme"));
                }
                Element root = new Element("inspections");
                root.setAttribute("profile_name", scheme.getName());
                scheme.serializeInto(root, false);
                return root;
            }

            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "onSchemeAdded"));
                }
                InspectionProfileManagerImpl.updateProfileImpl(scheme);
                InspectionProfileManagerImpl.this.fireProfileChanged(scheme);
                InspectionProfileManagerImpl.onProfilesChanged();
            }

            public void onSchemeDeleted(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "onSchemeDeleted"));
                }
                InspectionProfileManagerImpl.onProfilesChanged();
            }

            public void onCurrentSchemeChanged(Scheme oldCurrentScheme) {
                Profile current = (Profile)InspectionProfileManagerImpl.this.mySchemesManager.getCurrentScheme();
                if (current != null) {
                    InspectionProfileManagerImpl.this.fireProfileChanged((Profile)oldCurrentScheme, current, null);
                }
                InspectionProfileManagerImpl.onProfilesChanged();
            }
        }, RoamingType.PER_USER);
        this.mySeverityRegistrar = new SeverityRegistrar(messageBus);
    }

    @NotNull
    private static InspectionProfileImpl createSampleProfile() {
        InspectionProfileImpl inspectionProfileImpl = new InspectionProfileImpl("Default");
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "createSampleProfile"));
        }
        return inspectionProfileImpl;
    }

    public static void registerProvidedSeverities() {
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType t : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = t.getSeverity(null);
                SeverityRegistrar.registerStandard(t, highlightSeverity);
                TextAttributesKey attributesKey = t.getAttributesKey();
                Icon icon = t instanceof HighlightInfoType.Iconable ? ((HighlightInfoType.Iconable)((Object)t)).getIcon() : null;
                HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (TextAttributesKey)attributesKey, (Icon)icon);
            }
        }
    }

    @NotNull
    public Collection<Profile> getProfiles() {
        this.initProfiles();
        List list = this.mySchemesManager.getAllSchemes();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getProfiles"));
        }
        return list;
    }

    public void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.myProfilesAreInitialized.set(false);
    }

    @Override
    public void initProfiles() {
        if (this.myProfilesAreInitialized.getAndSet(true)) {
            if (this.mySchemesManager.getAllSchemes().isEmpty()) {
                this.createDefaultProfile();
            }
            return;
        }
        if (!this.LOAD_PROFILES) {
            return;
        }
        this.mySchemesManager.loadSchemes();
        List profiles = this.mySchemesManager.getAllSchemes();
        if (profiles.isEmpty()) {
            this.createDefaultProfile();
        } else {
            for (Profile profile : profiles) {
                this.addProfile(profile);
            }
        }
    }

    private void createDefaultProfile() {
        InspectionProfileImpl defaultProfile = (InspectionProfileImpl)this.createProfile();
        defaultProfile.setBaseProfile(InspectionProfileImpl.getDefaultProfile());
        this.addProfile(defaultProfile);
    }

    @Override
    public Profile loadProfile(@NotNull String path) throws IOException, JDOMException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "loadProfile"));
        }
        final File file = new File(path);
        if (file.exists()) {
            try {
                return InspectionProfileLoadUtil.load(file, this.myRegistrar, (ProfileManager)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (JDOMException e) {
                throw e;
            }
            catch (Exception ignored) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, file}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0]));
                    }
                }, ModalityState.NON_MODAL);
            }
        }
        return this.getProfile(path, false);
    }

    public void updateProfile(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "updateProfile"));
        }
        this.mySchemesManager.addNewScheme((Scheme)profile, true);
        InspectionProfileManagerImpl.updateProfileImpl(profile);
    }

    private static void updateProfileImpl(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "updateProfileImpl"));
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            InspectionProjectProfileManager.getInstance(project).initProfileWrapper(profile);
        }
    }

    @Override
    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getSeverityRegistrar"));
        }
        return severityRegistrar;
    }

    @Override
    @NotNull
    public SeverityRegistrar getOwnSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getOwnSeverityRegistrar"));
        }
        return severityRegistrar;
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        try {
            this.mySeverityRegistrar.writeExternal(state);
        }
        catch (WriteExternalException e) {
            throw new RuntimeException(e);
        }
        return state;
    }

    public void loadState(Element state) {
        try {
            this.mySeverityRegistrar.readExternal(state);
        }
        catch (InvalidDataException e) {
            throw new RuntimeException(e);
        }
    }

    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    public Profile createProfile() {
        return InspectionProfileManagerImpl.createSampleProfile();
    }

    public void setRootProfile(String rootProfile) {
        Profile current = (Profile)this.mySchemesManager.getCurrentScheme();
        if (current != null && !Comparing.strEqual((String)rootProfile, (String)current.getName())) {
            this.fireProfileChanged(current, this.getProfile(rootProfile), null);
        }
        this.mySchemesManager.setCurrentSchemeName(rootProfile);
    }

    public Profile getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getProfile"));
        }
        Profile found = (Profile)this.mySchemesManager.findSchemeByName(name);
        if (found != null) {
            return found;
        }
        if (returnRootProfileIfNamedIsAbsent) {
            return this.getRootProfile();
        }
        return null;
    }

    @NotNull
    public Profile getRootProfile() {
        Profile current = (Profile)this.mySchemesManager.getCurrentScheme();
        if (current != null) {
            Profile profile = current;
            if (profile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getRootProfile"));
            }
            return profile;
        }
        Collection<Profile> profiles = this.getProfiles();
        if (profiles.isEmpty()) {
            InspectionProfileImpl inspectionProfileImpl = InspectionProfileManagerImpl.createSampleProfile();
            if (inspectionProfileImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getRootProfile"));
            }
            return inspectionProfileImpl;
        }
        Profile profile = profiles.iterator().next();
        if (profile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getRootProfile"));
        }
        return profile;
    }

    public void deleteProfile(@NotNull String profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "deleteProfile"));
        }
        Profile found = (Profile)this.mySchemesManager.findSchemeByName(profile);
        if (found != null) {
            this.mySchemesManager.removeScheme((Scheme)found);
        }
    }

    public void addProfile(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "addProfile"));
        }
        this.mySchemesManager.addNewScheme((Scheme)profile, true);
    }

    @NotNull
    public String[] getAvailableProfileNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)this.mySchemesManager.getAllSchemeNames());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getAvailableProfileNames"));
        }
        return stringArray;
    }

    @Override
    public Profile getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getProfile"));
        }
        return this.getProfile(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onProfilesChanged() {
        for (final Project project : ProjectManager.getInstance().getOpenProjects()) {
            HighlightingSettingsPerFile highlightingSettingsPerFile = HighlightingSettingsPerFile.getInstance(project);
            synchronized (highlightingSettingsPerFile) {
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed()) {
                        DaemonListeners.getInstance(project).updateStatusBar();
                    }
                }
            });
        }
    }
}

