/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectedIndentOptionsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"indent.options.notification.provider");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(final @NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Editor editor;
        Project project;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor instanceof TextEditor && (project = (editor = ((TextEditor)fileEditor).getEditor()).getProject()) != null) {
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile = documentManager.getPsiFile(document);
            final Ref indentOptionsProviderRef = new Ref();
            if (psiFile != null) {
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
                CommonCodeStyleSettings.IndentOptions userOptions = settings.getIndentOptions(psiFile.getFileType());
                CommonCodeStyleSettings.IndentOptions detectedOptions = CodeStyleSettingsManager.getSettings((Project)project).getIndentOptionsByFile(psiFile, null, true, (Processor)new Processor<FileIndentOptionsProvider>(){

                    public boolean process(FileIndentOptionsProvider provider) {
                        indentOptionsProviderRef.set((Object)provider);
                        return false;
                    }
                });
                final FileIndentOptionsProvider provider = (FileIndentOptionsProvider)indentOptionsProviderRef.get();
                if (provider != null && !provider.isAcceptedWithoutWarning(file) && provider.getDisplayName() != null && !userOptions.equals((Object)detectedOptions)) {
                    EditorNotificationPanel panel = new EditorNotificationPanel().text(ApplicationBundle.message((String)"code.style.indents.detector.message", (Object[])new Object[]{provider.getDisplayName(), DetectedIndentOptionsNotificationProvider.getOptionDiffInfoString(userOptions, detectedOptions)}));
                    if (provider.getIcon() != null) {
                        panel.icon(provider.getIcon());
                    }
                    panel.createActionLabel(ApplicationBundle.message((String)"code.style.indents.detector.accept", (Object[])new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            provider.setAccepted(file);
                            EditorNotifications.getInstance((Project)project).updateAllNotifications();
                        }
                    });
                    if (provider.canBeDisabled()) {
                        panel.createActionLabel(ApplicationBundle.message((String)"code.style.indents.detector.disable", (Object[])new Object[0]), new Runnable(){

                            @Override
                            public void run() {
                                provider.disable(project);
                                if (editor instanceof EditorEx) {
                                    ((EditorEx)editor).reinitSettings();
                                }
                                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                            }
                        });
                    }
                    return panel;
                }
            }
        }
        return null;
    }

    @NotNull
    private static String getOptionDiffInfoString(CommonCodeStyleSettings.IndentOptions user, CommonCodeStyleSettings.IndentOptions detected) {
        StringBuilder sb = new StringBuilder();
        if (user.INDENT_SIZE != detected.INDENT_SIZE) {
            sb.append("indent size=").append(detected.INDENT_SIZE);
        }
        if (user.TAB_SIZE != detected.TAB_SIZE) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("tab size=").append(detected.TAB_SIZE);
        }
        if (user.USE_TAB_CHARACTER != detected.USE_TAB_CHARACTER) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(detected.USE_TAB_CHARACTER ? "tabs" : "no tabs");
        }
        if (user.SMART_TABS != detected.SMART_TABS) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(detected.SMART_TABS ? "smart tabs" : "no smart tabs");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "getOptionDiffInfoString"));
        }
        return string;
    }
}

