/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.psi.impl.source.codeStyle.LegacyCodeStyleSchemesSettings;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CodeStyleSchemeSettings", storages={@Storage(file="$APP_CONFIG$/code.style.schemes.xml")}, additionalExportFile="$ROOT_CONFIG$/codestyles")
public class PersistableCodeStyleSchemes
extends CodeStyleSchemesImpl
implements PersistentStateComponent<Element> {
    @NonNls
    static final String CODE_STYLE_SCHEMES_FILE = "code.style.schemes.xml";
    private boolean isLoaded;

    public PersistableCodeStyleSchemes(SchemesManagerFactory schemesManagerFactory) {
        super(schemesManagerFactory);
    }

    @Nullable
    public Element getState() {
        return XmlSerializer.serialize((Object)((Object)this), (SerializationFilter)new SerializationFilter(){

            public boolean accepts(@NotNull Accessor accessor, Object bean) {
                if (accessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/psi/impl/source/codeStyle/PersistableCodeStyleSchemes$1", "accepts"));
                }
                return accessor.getValueClass().equals(String.class);
            }
        });
    }

    public void loadState(Element state) {
        this.init();
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)state);
        this.isLoaded = true;
        this.updateCurrentScheme();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void loadSettings() {
        this.init();
        LegacyCodeStyleSchemesSettings legacySettings = (LegacyCodeStyleSchemesSettings)ServiceManager.getService(LegacyCodeStyleSchemesSettings.class);
        if (legacySettings != null) {
            this.CURRENT_SCHEME_NAME = legacySettings.CURRENT_SCHEME_NAME;
        }
        this.isLoaded = true;
        this.updateCurrentScheme();
    }

    private void updateCurrentScheme() {
        CodeStyleScheme current;
        CodeStyleScheme codeStyleScheme = current = this.CURRENT_SCHEME_NAME == null ? null : this.findSchemeByName(this.CURRENT_SCHEME_NAME);
        if (current == null) {
            current = this.getDefaultScheme();
        }
        this.setCurrentScheme(current);
    }
}

