/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.ASTShallowComparator;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.diff.DiffTree;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSupportImpl
extends BlockSupport {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.text.BlockSupportImpl");

    public BlockSupportImpl(Project project) {
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/source/text/BlockSupportImpl$1", "updateStarted"));
                }
                doc.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
            }
        });
    }

    @Override
    public void reparseRange(PsiFile file, int startOffset, int endOffset, CharSequence newTextS) throws IncorrectOperationException {
        LOG.assertTrue(file.isValid());
        PsiFileImpl psiFile = (PsiFileImpl)file;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        document.replaceString(startOffset, endOffset, newTextS);
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
    }

    @Override
    @NotNull
    public DiffLog reparseRange(@NotNull PsiFile file, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        if (changedPsiRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedPsiRange", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        if (newFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        PsiFileImpl fileImpl = (PsiFileImpl)file;
        Couple<ASTNode> reparseableRoots = this.findReparseableRoots(fileImpl, changedPsiRange, newFileText);
        DiffLog diffLog = reparseableRoots != null ? BlockSupportImpl.mergeTrees(fileImpl, (ASTNode)reparseableRoots.first, (ASTNode)reparseableRoots.second, indicator) : BlockSupportImpl.makeFullParse(fileImpl.getTreeElement(), newFileText, newFileText.length(), fileImpl, indicator);
        if (diffLog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        return diffLog;
    }

    @Nullable
    public Couple<ASTNode> findReparseableRoots(@NotNull PsiFileImpl file, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/BlockSupportImpl", "findReparseableRoots"));
        }
        if (changedPsiRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedPsiRange", "com/intellij/psi/impl/source/text/BlockSupportImpl", "findReparseableRoots"));
        }
        if (newFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "findReparseableRoots"));
        }
        Project project = file.getProject();
        FileElement fileElement = file.getTreeElement();
        CharTable charTable = fileElement.getCharTable();
        int lengthShift = newFileText.length() - fileElement.getTextLength();
        if (fileElement.getElementType() instanceof ITemplateDataElementType || BlockSupportImpl.isTooDeep((UserDataHolder)file)) {
            return null;
        }
        LeafElement leafAtStart = fileElement.findLeafElementAt(Math.max(0, changedPsiRange.getStartOffset() - 1));
        LeafElement leafAtEnd = fileElement.findLeafElementAt(Math.min(changedPsiRange.getEndOffset(), fileElement.getTextLength() - 1));
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        for (FileElement node = leafAtStart != null && leafAtEnd != null ? TreeUtil.findCommonParent(leafAtStart, leafAtEnd) : fileElement; node != null && !(node instanceof FileElement); node = node.getTreeParent()) {
            ASTNode chameleon;
            IElementType elementType = node.getElementType();
            if (!(elementType instanceof IReparseableElementType)) continue;
            TextRange textRange = node.getTextRange();
            IReparseableElementType reparseable = (IReparseableElementType)elementType;
            if (!baseLanguage.isKindOf(reparseable.getLanguage()) || textRange.getLength() + lengthShift <= 0) continue;
            int start = textRange.getStartOffset();
            int end = start + textRange.getLength() + lengthShift;
            if (end > newFileText.length()) {
                BlockSupportImpl.reportInconsistentLength(file, newFileText, node, start, end);
                break;
            }
            CharSequence newTextStr = newFileText.subSequence(start, end);
            if (!reparseable.isParsable(node.getTreeParent(), newTextStr, baseLanguage, project) || (chameleon = reparseable.createNode(newTextStr)) == null) continue;
            DummyHolder holder = DummyHolderFactory.createHolder(file.getManager(), null, node.getPsi(), charTable);
            holder.getTreeElement().rawAddChildren((TreeElement)chameleon);
            if (holder.getTextLength() != newTextStr.length()) {
                String details = ApplicationManager.getApplication().isInternal() ? "text=" + newTextStr + "; treeText=" + holder.getText() + ";" : "";
                LOG.error("Inconsistent reparse: " + details + " type=" + elementType);
            }
            return Couple.of((Object)node, (Object)chameleon);
        }
        return null;
    }

    private static void reportInconsistentLength(PsiFile file, CharSequence newFileText, ASTNode node, int start, int end) {
        String message = "Index out of bounds: type=" + node.getElementType() + "; file=" + file + "; file.class=" + file.getClass() + "; start=" + start + "; end=" + end + "; length=" + node.getTextLength();
        String newTextBefore = ((Object)newFileText.subSequence(0, start)).toString();
        String oldTextBefore = ((Object)file.getText().subSequence(0, start)).toString();
        if (oldTextBefore.equals(newTextBefore)) {
            message = message + "; oldTextBefore==newTextBefore";
        }
        LOG.error(message, new Attachment[]{new Attachment(file.getName() + "_oldNodeText.txt", node.getText()), new Attachment(file.getName() + "_oldFileText.txt", file.getText()), new Attachment(file.getName() + "_newFileText.txt", ((Object)newFileText).toString())});
    }

    @NotNull
    private static DiffLog makeFullParse(ASTNode parent, @NotNull CharSequence newFileText, int textLength, @NotNull PsiFileImpl fileImpl, @NotNull ProgressIndicator indicator) {
        if (newFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        if (fileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        if (fileImpl instanceof PsiCodeFragment) {
            FileElement holderElement = new DummyHolder(fileImpl.getManager(), null).getTreeElement();
            holderElement.rawAddChildren(fileImpl.createContentLeafElement(holderElement.getCharTable().intern(newFileText, 0, textLength)));
            DiffLog diffLog = new DiffLog();
            diffLog.appendReplaceFileElement((FileElement)parent, (FileElement)holderElement.getFirstChildNode());
            DiffLog diffLog2 = diffLog;
            if (diffLog2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
            }
            return diffLog2;
        }
        FileViewProvider viewProvider = fileImpl.getViewProvider();
        viewProvider.getLanguages();
        FileType fileType = viewProvider.getVirtualFile().getFileType();
        String fileName = fileImpl.getName();
        LightVirtualFile lightFile = new LightVirtualFile(fileName, fileType, newFileText, viewProvider.getVirtualFile().getCharset(), fileImpl.getViewProvider().getModificationStamp());
        lightFile.setOriginalFile(viewProvider.getVirtualFile());
        FileViewProvider copy = viewProvider.createCopy((VirtualFile)lightFile);
        if (copy.isEventSystemEnabled()) {
            throw new AssertionError((Object)("Copied view provider must be non-physical for reparse to deliver correct events: " + viewProvider));
        }
        copy.getLanguages();
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)lightFile);
        PsiFileImpl newFile = BlockSupportImpl.getFileCopy(fileImpl, copy);
        newFile.setOriginalFile(fileImpl);
        FileElement newFileElement = (FileElement)newFile.getNode();
        FileElement oldFileElement = (FileElement)fileImpl.getNode();
        DiffLog diffLog = BlockSupportImpl.mergeTrees(fileImpl, oldFileElement, newFileElement, indicator);
        ((PsiManagerEx)fileImpl.getManager()).getFileManager().setViewProvider((VirtualFile)lightFile, null);
        DiffLog diffLog3 = diffLog;
        if (diffLog3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        return diffLog3;
    }

    @NotNull
    public static PsiFileImpl getFileCopy(PsiFileImpl originalFile, FileViewProvider providerCopy) {
        FileViewProvider viewProvider = originalFile.getViewProvider();
        Language language = originalFile.getLanguage();
        PsiFileImpl newFile = (PsiFileImpl)providerCopy.getPsi(language);
        if (newFile == null && language == PlainTextLanguage.INSTANCE && originalFile == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            newFile = (PsiFileImpl)providerCopy.getPsi(providerCopy.getBaseLanguage());
        }
        if (newFile == null) {
            throw new RuntimeException("View provider " + viewProvider + " refused to parse text with " + language + "; languages: " + viewProvider.getLanguages() + "; base: " + viewProvider.getBaseLanguage() + "; copy: " + providerCopy + "; copy.base: " + providerCopy.getBaseLanguage() + "; vFile: " + viewProvider.getVirtualFile() + "; copy.vFile: " + providerCopy.getVirtualFile() + "; fileType: " + viewProvider.getVirtualFile().getFileType() + "; copy.original(): " + (providerCopy.getVirtualFile() instanceof LightVirtualFile ? ((LightVirtualFile)providerCopy.getVirtualFile()).getOriginalFile() : null));
        }
        PsiFileImpl psiFileImpl = newFile;
        if (psiFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "getFileCopy"));
        }
        return psiFileImpl;
    }

    @NotNull
    private static DiffLog replaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "replaceElementWithEvents"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "replaceElementWithEvents"));
        }
        DiffLog diffLog = new DiffLog();
        diffLog.appendReplaceElementWithEvents(oldRoot, newRoot);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "replaceElementWithEvents"));
        }
        return diffLog2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static DiffLog mergeTrees(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull ProgressIndicator indicator) {
        block16: {
            DiffLog diffLog;
            block15: {
                if (fileImpl == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (oldRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (newRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (newRoot instanceof FileElement) {
                    ((FileElement)newRoot).setCharTable(fileImpl.getTreeElement().getCharTable());
                }
                try {
                    newRoot.putUserData(TREE_TO_BE_REPARSED, (Object)oldRoot);
                    if (BlockSupportImpl.isReplaceWholeNode(fileImpl, newRoot)) {
                        DiffLog treeChangeEvent = BlockSupportImpl.replaceElementWithEvents((CompositeElement)oldRoot, (CompositeElement)newRoot);
                        fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
                        DiffLog diffLog2 = treeChangeEvent;
                        diffLog = diffLog2;
                        break block15;
                    }
                    newRoot.getFirstChildNode();
                    break block16;
                }
                catch (BlockSupport.ReparsedSuccessfullyException e) {
                    DiffLog diffLog3 = e.getDiffLog();
                    DiffLog diffLog4 = diffLog3;
                    if (diffLog4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                    }
                    return diffLog4;
                }
            }
            if (diffLog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
            }
            return diffLog;
            finally {
                newRoot.putUserData(TREE_TO_BE_REPARSED, null);
            }
        }
        ASTShallowComparator comparator = new ASTShallowComparator(indicator);
        ASTStructure treeStructure = BlockSupportImpl.createInterruptibleASTStructure(newRoot, indicator);
        DiffLog diffLog = new DiffLog();
        BlockSupportImpl.diffTrees(oldRoot, diffLog, comparator, treeStructure, indicator);
        DiffLog diffLog5 = diffLog;
        if (diffLog5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
        }
        return diffLog5;
    }

    public static <T> void diffTrees(@NotNull ASTNode oldRoot, @NotNull DiffTreeChangeBuilder<ASTNode, T> builder, @NotNull ShallowNodeComparator<ASTNode, T> comparator, @NotNull FlyweightCapableTreeStructure<T> newTreeStructure, @NotNull ProgressIndicator indicator) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (newTreeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTreeStructure", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        TreeUtil.ensureParsedRecursivelyCheckingProgress(oldRoot, indicator);
        DiffTree.diff((FlyweightCapableTreeStructure)BlockSupportImpl.createInterruptibleASTStructure(oldRoot, indicator), newTreeStructure, comparator, builder);
    }

    private static ASTStructure createInterruptibleASTStructure(@NotNull ASTNode oldRoot, final @NotNull ProgressIndicator indicator) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "createInterruptibleASTStructure"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "createInterruptibleASTStructure"));
        }
        return new ASTStructure(oldRoot){

            @Override
            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                if (astNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/psi/impl/source/text/BlockSupportImpl$2", "getChildren"));
                }
                if (into == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "into", "com/intellij/psi/impl/source/text/BlockSupportImpl$2", "getChildren"));
                }
                indicator.checkCanceled();
                return super.getChildren(astNode, into);
            }
        };
    }

    private static boolean isReplaceWholeNode(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode newRoot) throws BlockSupport.ReparsedSuccessfullyException {
        boolean explicitlyMarkedDeep;
        if (fileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/impl/source/text/BlockSupportImpl", "isReplaceWholeNode"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "isReplaceWholeNode"));
        }
        Boolean data = (Boolean)fileImpl.getUserData(DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            fileImpl.putUserData(DO_NOT_REPARSE_INCREMENTALLY, null);
        }
        if ((explicitlyMarkedDeep = Boolean.TRUE.equals(data)) || BlockSupportImpl.isTooDeep((UserDataHolder)fileImpl)) {
            return true;
        }
        ASTNode childNode = newRoot.getFirstChildNode();
        boolean childTooDeep = BlockSupportImpl.isTooDeep((UserDataHolder)childNode);
        if (childTooDeep) {
            childNode.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, null);
            fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        return childTooDeep;
    }

    public static void sendBeforeChildrenChangeEvent(@NotNull PsiManagerImpl manager, @NotNull PsiElement scope, boolean isGenericChange) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendBeforeChildrenChangeEvent"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendBeforeChildrenChangeEvent"));
        }
        if (!scope.isPhysical()) {
            manager.beforeChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope);
        event.setFile(scope.getContainingFile());
        TextRange range = scope.getTextRange();
        event.setOffset(range == null ? 0 : range.getStartOffset());
        event.setOldLength(scope.getTextLength());
        event.setGenericChange(isGenericChange);
        manager.beforeChildrenChange(event);
    }

    public static void sendAfterChildrenChangedEvent(@NotNull PsiManagerImpl manager, @NotNull PsiFile scope, int oldLength, boolean isGenericChange) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendAfterChildrenChangedEvent"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendAfterChildrenChangedEvent"));
        }
        if (!scope.isPhysical()) {
            manager.afterChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent((PsiElement)scope);
        event.setFile(scope);
        event.setOffset(0);
        event.setOldLength(oldLength);
        event.setGenericChange(isGenericChange);
        manager.childrenChanged(event);
    }
}

