/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private PsiType[] myActualParameterTypes;
    protected LanguageLevel myLanguageLevel;

    public JavaMethodsConflictResolver(@NotNull PsiExpressionList list, @NotNull LanguageLevel languageLevel) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this((PsiElement)list, null, languageLevel);
    }

    public JavaMethodsConflictResolver(@NotNull PsiElement argumentsList, PsiType[] actualParameterTypes, @NotNull LanguageLevel languageLevel) {
        if (argumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsList", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "resolveConflict"));
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        boolean atLeastOneMatch = JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.getActualParametersLength(), true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSameSignatures(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.getActualParametersLength(), false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        int applicabilityLevel = this.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkSpecifics(conflicts, applicabilityLevel, this.myLanguageLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.getActualParametersLength());
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet uniques = new THashSet(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(new CandidateInfo[conflicts.size()]);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    if (this.nonComparable(method, conflict, applicabilityLevel == 3)) continue;
                    switch (this.isMoreSpecific((MethodCandidateInfo)method, (MethodCandidateInfo)conflict, applicabilityLevel, languageLevel)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "nonComparable"));
        }
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "nonComparable"));
        }
        assert (method != conflict);
        return false;
    }

    protected static void checkAccessStaticLevels(@NotNull List<CandidateInfo> conflicts, boolean checkAccessible) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkAccessStaticLevels"));
        }
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index = 0;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method = (MethodCandidateInfo)conflict;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method) : JavaMethodsConflictResolver.getCheckStaticLevel(method);
            checkLevels[index++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    protected void checkSameSignatures(@NotNull List<CandidateInfo> conflicts) {
        PsiMethod method;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSameSignatures"));
        }
        THashMap signatures = new THashMap(conflicts.size());
        HashSet superMethods = new HashSet();
        for (CandidateInfo conflict : conflicts) {
            method = ((MethodCandidateInfo)conflict).getElement();
            for (HierarchicalMethodSignature methodSignature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
                PsiMethod superMethod = methodSignature.getMethod();
                PsiClass aClass = superMethod.getContainingClass();
                if (aClass == null || "java.lang.Object".equals(aClass.getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        block2: for (int i = 0; i < conflicts.size(); ++i) {
            PsiReferenceExpression expression;
            PsiExpression qualifierExpression;
            PsiClass currentClass;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            method = (PsiMethod)info.getElement();
            if (!method.hasModifierProperty("static") && superMethods.contains(method)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = ((MethodCandidateInfo)info).getSubstitutor(false);
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, info);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1 != null && existingClass != null) {
                if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                    signatures.put(signature, info);
                    continue;
                }
                if (existingClass.isInterface() && "java.lang.Object".equals(class1.getQualifiedName())) {
                    conflicts.remove(info);
                    --i;
                    continue;
                }
            }
            if (method == existingMethod) {
                PsiElement scope1 = info.getCurrentFileResolveScope();
                PsiElement scope2 = existing.getCurrentFileResolveScope();
                if (scope1 instanceof PsiClass && scope2 instanceof PsiClass && PsiTreeUtil.isAncestor((PsiElement)scope1, (PsiElement)scope2, (boolean)true) && !existing.isAccessible()) {
                    signatures.put(signature, info);
                    continue;
                }
            }
            boolean existingTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(existing);
            boolean infoTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(info);
            if (existingTypeParamAgree && !infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(method, existingMethod)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (!existingTypeParamAgree && infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(existingMethod, method)) {
                signatures.put(signature, info);
                int index = conflicts.indexOf(existing);
                conflicts.remove(index);
                --i;
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)class1, (PsiClass)existingClass, (boolean)true) || InheritanceUtil.isInheritorOrSelf((PsiClass)existingClass, (PsiClass)class1, (boolean)true)) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                PsiParameter[] existingParameters = existingMethod.getParameterList().getParameters();
                int parametersLength = parameters.length;
                for (int i1 = 0; i1 < parametersLength; ++i1) {
                    if (!(parameters[i1].getType() instanceof PsiArrayType) || existingParameters[i1].getType() instanceof PsiArrayType) continue;
                    signatures.put(signature, info);
                    continue block2;
                }
                PsiType returnType1 = method.getReturnType();
                PsiType returnType2 = existingMethod.getReturnType();
                if (returnType1 != null && returnType2 != null && !(returnType1 = infoSubstitutor.substitute(returnType1)).equals(returnType2 = ((MethodCandidateInfo)existing).getSubstitutor(false).substitute(returnType2)) && returnType1.isAssignableFrom(returnType2)) {
                    conflicts.remove(i);
                    --i;
                    continue;
                }
                signatures.put(signature, info);
                continue;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myArgumentsList, PsiMethodCallExpression.class);
            if (methodCallExpression == null || (currentClass = (qualifierExpression = (expression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null ? PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression.getType()) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) == null || existingClass == null || class1 == null) continue;
            PsiSubstitutor eSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)existingClass, (PsiClass)currentClass, (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
            PsiSubstitutor cSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)class1, (PsiClass)currentClass, (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
            if (eSubstitutor == null || cSubstitutor == null || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)existingMethod.getSignature(eSubstitutor), (MethodSignature)method.getSignature(cSubstitutor))) continue;
            PsiType returnType = eSubstitutor.substitute(existingMethod.getReturnType());
            PsiType returnType1 = cSubstitutor.substitute(method.getReturnType());
            if (returnType == null || returnType1 == null || returnType1.equals(returnType)) continue;
            if (TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)returnType1, (boolean)false)) {
                if (class1.isInterface() && !existingClass.isInterface()) continue;
                conflicts.remove(existing);
            } else {
                if (!TypeConversionUtil.isAssignable((PsiType)returnType1, (PsiType)returnType, (boolean)false)) continue;
                conflicts.remove(i);
            }
            --i;
            break;
        }
    }

    private static boolean areTypeParametersAgree(@NotNull CandidateInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "areTypeParametersAgree"));
        }
        return ((MethodCandidateInfo)info).getPertinentApplicabilityLevel() != 1;
    }

    public static boolean checkParametersNumber(@NotNull List<CandidateInfo> conflicts, int argumentsCount, boolean ignoreIfStaticsProblem) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkParametersNumber"));
        }
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            if (method.isVarArgs()) {
                return true;
            }
            if (method.getParameterList().getParametersCount() == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        int index = unmatchedIndices.get(u);
                        conflicts.remove(index);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public int checkApplicability(@NotNull List<CandidateInfo> conflicts) {
        int level;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkApplicability"));
        }
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)conflict);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator.next();
                level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)info);
                if (level >= maxApplicabilityLevel) continue;
                iterator.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getPertinentApplicabilityLevel"));
        }
        return conflict.getPertinentApplicabilityLevel();
    }

    private static int getCheckAccessLevel(@NotNull MethodCandidateInfo method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getCheckAccessLevel"));
        }
        boolean visible = method.isAccessible();
        return visible ? 1 : 0;
    }

    private static int getCheckStaticLevel(@NotNull MethodCandidateInfo method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getCheckStaticLevel"));
        }
        boolean available = method.isStaticsScopeCorrect();
        return (available ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    @NotNull
    private PsiType[] getActualParameterTypes() {
        PsiType[] types = this.myActualParameterTypes;
        if (types == null) {
            LOG.assertTrue(this.myArgumentsList instanceof PsiExpressionList, (Object)this.myArgumentsList);
            this.myActualParameterTypes = types = this.getArgumentTypes();
        }
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getActualParameterTypes"));
        }
        return types;
    }

    private int getActualParametersLength() {
        if (this.myActualParameterTypes == null) {
            LOG.assertTrue(this.myArgumentsList instanceof PsiExpressionList, (Object)this.myArgumentsList);
            return ((PsiExpressionList)this.myArgumentsList).getExpressions().length;
        }
        return this.myActualParameterTypes.length;
    }

    @NotNull
    protected PsiType[] getArgumentTypes() {
        PsiType[] psiTypeArray = ((PsiExpressionList)this.myArgumentsList).getExpressionTypes();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getArgumentTypes"));
        }
        return psiTypeArray;
    }

    private static boolean isBoxingHappened(PsiType argType, PsiType parameterType, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isBoxingHappened"));
        }
        if (argType == null) {
            return parameterType instanceof PsiPrimitiveType;
        }
        if (parameterType instanceof PsiClassType) {
            parameterType = ((PsiClassType)parameterType).setLanguageLevel(languageLevel);
        }
        return TypeConversionUtil.boxingConversionApplicable((PsiType)parameterType, (PsiType)argType);
    }

    private Specifics isMoreSpecific(@NotNull MethodCandidateInfo info1, @NotNull MethodCandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, @NotNull LanguageLevel languageLevel) {
        boolean varargs2;
        boolean raw2;
        boolean raw1;
        if (info1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        if (info2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        PsiMethod method1 = info1.getElement();
        PsiMethod method2 = info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = info1.getSubstitutor(false);
        PsiSubstitutor classSubstitutor2 = info2.getSubstitutor(false);
        int max = Math.max(params1.length, params2.length);
        PsiType[] types1 = PsiType.createArray((int)max);
        PsiType[] types2 = PsiType.createArray((int)max);
        boolean varargsPosition = applicabilityLevel == 2;
        for (int i = 0; i < max; ++i) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i, params1.length - 1)].getType() : null;
            PsiType psiType = type2 = params2.length > 0 ? params2[Math.min(i, params2.length - 1)].getType() : null;
            if (varargsPosition) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && params1.length == params2.length && class1 != null && (!JavaVersionService.getInstance().isAtLeast((PsiElement)class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        boolean sameBoxing = true;
        int[] boxingHappened = new int[2];
        for (int i = 0; i < types1.length; ++i) {
            ProgressManager.checkCanceled();
            PsiType type1 = classSubstitutor1.substitute(types1[i]);
            PsiType type2 = classSubstitutor2.substitute(types2[i]);
            PsiType argType = i < this.getActualParameterTypes().length ? this.getActualParameterTypes()[i] : null;
            boolean boxingInFirst = false;
            if (JavaMethodsConflictResolver.isBoxingHappened(argType, type1, languageLevel)) {
                boxingHappened[0] = boxingHappened[0] + 1;
                boxingInFirst = true;
            }
            boolean boxingInSecond = false;
            if (JavaMethodsConflictResolver.isBoxingHappened(argType, type2, languageLevel)) {
                boxingHappened[1] = boxingHappened[1] + 1;
                boxingInSecond = true;
            }
            sameBoxing &= boxingInFirst == boxingInSecond;
        }
        if (boxingHappened[0] == 0 && boxingHappened[1] > 0) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] > 0 && boxingHappened[1] == 0) {
            return Specifics.SECOND;
        }
        if (sameBoxing) {
            PsiSubstitutor siteSubstitutor1 = info1.getSiteSubstitutor();
            PsiSubstitutor siteSubstitutor2 = info2.getSiteSubstitutor();
            PsiType[] types2AtSite = JavaMethodsConflictResolver.typesAtSite(types2, siteSubstitutor2);
            PsiType[] types1AtSite = JavaMethodsConflictResolver.typesAtSite(types1, siteSubstitutor1);
            PsiSubstitutor methodSubstitutor1 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor1, types1, types2AtSite, languageLevel);
            boolean applicable12 = this.isApplicableTo(types2AtSite, method1, languageLevel, varargsPosition, methodSubstitutor1, method2);
            PsiSubstitutor methodSubstitutor2 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor2, types2, types1AtSite, languageLevel);
            boolean applicable21 = this.isApplicableTo(types1AtSite, method2, languageLevel, varargsPosition, methodSubstitutor2, method1);
            if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                boolean typeArgsApplicable12 = GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])typeParameters1, (PsiSubstitutor)methodSubstitutor1, (PsiElement)this.myArgumentsList, (!applicable21 ? 1 : 0) != 0);
                boolean typeArgsApplicable21 = GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])typeParameters2, (PsiSubstitutor)methodSubstitutor2, (PsiElement)this.myArgumentsList, (!applicable12 ? 1 : 0) != 0);
                if (!typeArgsApplicable12) {
                    applicable12 = false;
                }
                if (!typeArgsApplicable21) {
                    applicable21 = false;
                }
            }
            if (applicable12 || applicable21) {
                if (applicable12 && !applicable21) {
                    return Specifics.SECOND;
                }
                if (applicable21 && !applicable12) {
                    return Specifics.FIRST;
                }
                boolean abstract1 = method1.hasModifierProperty("abstract");
                boolean abstract2 = method2.hasModifierProperty("abstract");
                if (abstract1 && !abstract2) {
                    return Specifics.SECOND;
                }
                if (abstract2 && !abstract1) {
                    return Specifics.FIRST;
                }
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && this.myArgumentsList instanceof PsiExpressionList && (typeParameters1.length == 0 || typeParameters2.length == 0)) {
                boolean toCompareFunctional = false;
                if (types1.length > 0 && types2.length > 0) {
                    for (int i = 0; i < this.getActualParametersLength(); ++i) {
                        PsiType type1 = types1[Math.min(i, types1.length - 1)];
                        PsiType type2 = types2[Math.min(i, types2.length - 1)];
                        if (!LambdaUtil.isFunctionalType((PsiType)type1) || TypeConversionUtil.erasure((PsiType)type1).isAssignableFrom(type2) || !LambdaUtil.isFunctionalType((PsiType)type2) || TypeConversionUtil.erasure((PsiType)type2).isAssignableFrom(type1)) continue;
                        types1AtSite[Math.min((int)i, (int)(types1.length - 1))] = PsiType.NULL;
                        types2AtSite[Math.min((int)i, (int)(types2.length - 1))] = PsiType.NULL;
                        toCompareFunctional = true;
                    }
                }
                if (toCompareFunctional) {
                    boolean applicable12ignoreFunctionalType = this.isApplicableTo(types2AtSite, method1, languageLevel, varargsPosition, JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor1, types1, types2AtSite, languageLevel), null);
                    boolean applicable21ignoreFunctionalType = this.isApplicableTo(types1AtSite, method2, languageLevel, varargsPosition, JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor2, types2, types1AtSite, languageLevel), null);
                    if (applicable12ignoreFunctionalType || applicable21ignoreFunctionalType) {
                        Specifics specifics = null;
                        for (int i = 0; i < this.getActualParametersLength(); ++i) {
                            if (types1AtSite[Math.min(i, types1.length - 1)] != PsiType.NULL || types2AtSite[Math.min(i, types2.length - 1)] != PsiType.NULL) continue;
                            Specifics specific = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific((CandidateInfo)info1, (CandidateInfo)info2, ((PsiExpressionList)this.myArgumentsList).getExpressions()[i], i);
                            if (specific == Specifics.NEITHER) {
                                specifics = Specifics.NEITHER;
                                break;
                            }
                            if (specifics == null) {
                                specifics = specific;
                                continue;
                            }
                            if (specifics == specific) continue;
                            specifics = Specifics.NEITHER;
                            break;
                        }
                        if (!applicable12ignoreFunctionalType && applicable21ignoreFunctionalType) {
                            return specifics == Specifics.FIRST ? Specifics.FIRST : Specifics.NEITHER;
                        }
                        if (!applicable21ignoreFunctionalType && applicable12ignoreFunctionalType) {
                            return specifics == Specifics.SECOND ? Specifics.SECOND : Specifics.NEITHER;
                        }
                        return specifics;
                    }
                }
            }
        } else if (varargsPosition) {
            PsiType lastParamType1 = classSubstitutor1.substitute(types1[types1.length - 1]);
            PsiType lastParamType2 = classSubstitutor2.substitute(types2[types1.length - 1]);
            boolean assignable1 = TypeConversionUtil.isAssignable((PsiType)lastParamType2, (PsiType)lastParamType1);
            boolean assignable2 = TypeConversionUtil.isAssignable((PsiType)lastParamType1, (PsiType)lastParamType2);
            if (assignable1 && !assignable2) {
                return Specifics.FIRST;
            }
            if (assignable2 && !assignable1) {
                return Specifics.SECOND;
            }
        }
        if (class1 != class2) {
            if (class2.isInheritor(class1, true) || class1.isInterface() && !class2.isInterface()) {
                if (MethodSignatureUtil.isSubsignature((MethodSignature)method1.getSignature(info1.getSubstitutor(false)), (MethodSignature)method2.getSignature(info2.getSubstitutor(false)))) {
                    return Specifics.SECOND;
                }
                if (method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && boxingHappened[0] == 0) {
                    return Specifics.SECOND;
                }
            } else {
                if (MethodSignatureUtil.areErasedParametersEqual((MethodSignature)method1.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)method2.getSignature(PsiSubstitutor.EMPTY)) && MethodSignatureUtil.isSubsignature((MethodSignature)method2.getSignature(info2.getSubstitutor(false)), (MethodSignature)method1.getSignature(info1.getSubstitutor(false)))) {
                    return Specifics.FIRST;
                }
                if ((class1.isInheritor(class2, true) || class2.isInterface()) && method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && boxingHappened[0] == 0) {
                    return Specifics.FIRST;
                }
            }
        }
        if ((raw1 = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method1, (PsiSubstitutor)classSubstitutor1)) ^ (raw2 = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method2, (PsiSubstitutor)classSubstitutor2))) {
            return raw1 ? Specifics.SECOND : Specifics.FIRST;
        }
        boolean varargs1 = info1.isVarargs();
        if (varargs1 ^ (varargs2 = info2.isVarargs())) {
            return varargs1 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private boolean isApplicableTo(@NotNull PsiType[] types2AtSite, @NotNull PsiMethod method1, @NotNull LanguageLevel languageLevel, boolean varargsPosition, @NotNull PsiSubstitutor methodSubstitutor1, PsiMethod method2) {
        PsiElement parent;
        if (types2AtSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types2AtSite", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (methodSubstitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSubstitutor1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && method2 != null && method1.getTypeParameters().length > 0 && this.myArgumentsList instanceof PsiExpressionList && (parent = this.myArgumentsList.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)parent).getTypeArguments().length == 0) {
            return InferenceSession.isMoreSpecific(method2, method1, ((PsiExpressionList)this.myArgumentsList).getExpressions(), this.myArgumentsList, varargsPosition);
        }
        int applicabilityLevel = PsiUtil.getApplicabilityLevel((PsiMethod)method1, (PsiSubstitutor)methodSubstitutor1, (PsiType[])types2AtSite, (LanguageLevel)languageLevel, (boolean)false, (boolean)varargsPosition);
        return applicabilityLevel > 1;
    }

    @NotNull
    private static PsiType[] typesAtSite(@NotNull PsiType[] types1, @NotNull PsiSubstitutor siteSubstitutor1) {
        if (types1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        if (siteSubstitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siteSubstitutor1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        PsiType[] types = PsiType.createArray((int)types1.length);
        for (int i = 0; i < types1.length; ++i) {
            types[i] = siteSubstitutor1.substitute(types1[i]);
        }
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        return types;
    }

    @NotNull
    private static PsiSubstitutor calculateMethodSubstitutor(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiMethod method, @NotNull PsiSubstitutor siteSubstitutor, @NotNull PsiType[] types1, @NotNull PsiType[] types2, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (siteSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siteSubstitutor", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (types1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)method.getProject()).inferTypeArguments(typeParameters, types1, types2, languageLevel);
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method)) {
            PsiClass aClass;
            PsiType type;
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (!substitutor.getSubstitutionMap().containsKey(typeParameter)) {
                type = siteSubstitutor.substitute(typeParameter);
                if (type instanceof PsiClassType && typeParameter.getOwner() == method && (aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method) {
                    type = TypeConversionUtil.erasure((PsiType)type, (PsiSubstitutor)siteSubstitutor);
                }
                substitutor = substitutor.put(typeParameter, type);
                continue;
            }
            type = substitutor.substitute(typeParameter);
            if (!(type instanceof PsiClassType) || !((aClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter)) continue;
            substitutor = substitutor.put(typeParameter, (PsiType)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, siteSubstitutor));
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        return psiSubstitutor;
    }

    public void checkPrimitiveVarargs(@NotNull List<CandidateInfo> conflicts, int argumentsCount) {
        PsiType type;
        PsiType componentType;
        PsiMethod method;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkPrimitiveVarargs"));
        }
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo conflict : conflicts) {
            PsiClassType classType;
            ProgressManager.checkCanceled();
            method = (PsiMethod)conflict.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal((Object)(componentType = ((PsiArrayType)(type = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType()), (Object)(classType = PsiType.getJavaLangObject((PsiManager)method.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)method.getProject()))))) continue;
            objectVararg = conflict;
        }
        if (objectVararg != null) {
            for (CandidateInfo conflict : conflicts) {
                ProgressManager.checkCanceled();
                method = (PsiMethod)conflict.getElement();
                if (method == objectVararg || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                type = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    @Nullable
    private static PsiType getFunctionalType(int functionalTypeIdx, @NotNull CandidateInfo candidateInfo) {
        if (candidateInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateInfo", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getFunctionalType"));
        }
        PsiMethod psiMethod = (PsiMethod)candidateInfo.getElement();
        LOG.assertTrue(true);
        PsiParameter[] methodParameters = psiMethod.getParameterList().getParameters();
        if (methodParameters.length == 0) {
            return null;
        }
        PsiParameter param = functionalTypeIdx < methodParameters.length ? methodParameters[functionalTypeIdx] : methodParameters[methodParameters.length - 1];
        return ((MethodCandidateInfo)candidateInfo).getSiteSubstitutor().substitute(param.getType());
    }

    @NotNull
    private static Specifics isFunctionalTypeMoreSpecific(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, PsiExpression expr, int functionalInterfaceIdx) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
        }
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
        }
        if (expr instanceof PsiParenthesizedExpression) {
            Specifics specifics = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(method, conflict, ((PsiParenthesizedExpression)expr).getExpression(), functionalInterfaceIdx);
            if (specifics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
            }
            return specifics;
        }
        if (expr instanceof PsiConditionalExpression) {
            Specifics elseSpecifics;
            Specifics thenSpecifics = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(method, conflict, ((PsiConditionalExpression)expr).getThenExpression(), functionalInterfaceIdx);
            Specifics specifics = thenSpecifics == (elseSpecifics = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(method, conflict, ((PsiConditionalExpression)expr).getElseExpression(), functionalInterfaceIdx)) ? thenSpecifics : Specifics.NEITHER;
            if (specifics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
            }
            return specifics;
        }
        if (expr instanceof PsiFunctionalExpression) {
            if (expr instanceof PsiLambdaExpression && !((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                Specifics specifics = Specifics.NEITHER;
                if (specifics == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                }
                return specifics;
            }
            if (expr instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)expr).isExact()) {
                Specifics specifics = Specifics.NEITHER;
                if (specifics == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                }
                return specifics;
            }
            PsiType sType = JavaMethodsConflictResolver.getFunctionalType(functionalInterfaceIdx, method);
            PsiType tType = JavaMethodsConflictResolver.getFunctionalType(functionalInterfaceIdx, conflict);
            if (LambdaUtil.isFunctionalType((PsiType)sType) && LambdaUtil.isFunctionalType((PsiType)tType)) {
                boolean specific12 = InferenceSession.isFunctionalTypeMoreSpecificOnExpression(sType, tType, expr);
                boolean specific21 = InferenceSession.isFunctionalTypeMoreSpecificOnExpression(tType, sType, expr);
                if (specific12 && !specific21) {
                    Specifics specifics = Specifics.FIRST;
                    if (specifics == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                    }
                    return specifics;
                }
                if (!specific12 && specific21) {
                    Specifics specifics = Specifics.SECOND;
                    if (specifics == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                    }
                    return specifics;
                }
            }
        }
        Specifics specifics = Specifics.NEITHER;
        if (specifics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
        }
        return specifics;
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

