/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchPredicateProvider;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.DeleteNodesAction;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.StringToConstraintsTransformer;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.BinaryPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ContainsPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ReferencePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.impl.matcher.predicates.WithinPredicate;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternCompiler {
    private static CompileContext lastTestingContext;

    public static void transformOldPattern(MatchOptions options) {
        StringToConstraintsTransformer.transformOldPattern(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledPattern compilePattern(Project project, MatchOptions options) throws MalformedPatternException, UnsupportedOperationException {
        FileType fileType = options.getFileType();
        assert (fileType instanceof LanguageFileType);
        Language language = ((LanguageFileType)fileType).getLanguage();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByLanguage(language);
        assert (profile != null);
        CompiledPattern result = profile.createCompiledPattern();
        String[] prefixes = result.getTypedVarPrefixes();
        assert (prefixes.length > 0);
        CompileContext context = new CompileContext();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            lastTestingContext = context;
        }
        try {
            context.init(result, options, project, options.getScope() instanceof GlobalSearchScope);
            List<PsiElement> elements = PatternCompiler.compileByAllPrefixes(project, options, result, context, prefixes);
            CompiledPattern pattern = context.getPattern();
            PatternCompiler.checkForUnknownVariables(pattern, elements);
            pattern.setNodes(elements);
            if (context.getSearchHelper().doOptimizing() && context.getSearchHelper().isScannedSomething()) {
                Set<PsiFile> set = context.getSearchHelper().getFilesSetToScan();
                ArrayList<PsiFile> filesToScan = new ArrayList<PsiFile>(set.size());
                GlobalSearchScope scope = (GlobalSearchScope)options.getScope();
                for (PsiFile file : set) {
                    if (!scope.contains(file.getVirtualFile())) continue;
                    if (file instanceof PsiFileImpl) {
                        ((PsiFileImpl)file).clearCaches();
                    }
                    filesToScan.add(file);
                }
                if (filesToScan.size() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("ssr.will.not.find.anything", new Object[0]));
                }
                result.setScope((SearchScope)new LocalSearchScope(PsiUtilCore.toPsiElementArray(filesToScan)));
            }
        }
        finally {
            context.clear();
        }
        return result;
    }

    private static void checkForUnknownVariables(final CompiledPattern pattern, List<PsiElement> elements) {
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (element instanceof PsiComment) {
                        return;
                    }
                    super.visitElement(element);
                    if (!(element instanceof LeafElement) || !pattern.isTypedVar(element)) {
                        return;
                    }
                    MatchingHandler handler = pattern.getHandler(pattern.getTypedVarString(element));
                    if (handler == null) {
                        throw new MalformedPatternException();
                    }
                }
            });
        }
    }

    public static String getLastFindPlan() {
        return ((TestModeOptimizingSearchHelper)lastTestingContext.getSearchHelper()).getSearchPlan();
    }

    @NotNull
    private static List<PsiElement> compileByAllPrefixes(Project project, MatchOptions options, CompiledPattern pattern, CompileContext context, String[] applicablePrefixes) {
        if (applicablePrefixes.length == 0) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        List<PsiElement> elements = PatternCompiler.doCompile(project, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context);
        if (elements.isEmpty()) {
            List<PsiElement> list = elements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (file == null) {
            List<PsiElement> list = elements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        PsiElement last = elements.get(elements.size() - 1);
        Pattern[] patterns = new Pattern[applicablePrefixes.length];
        for (int i = 0; i < applicablePrefixes.length; ++i) {
            String s = StructuralSearchUtil.shieldSpecialChars(applicablePrefixes[i]);
            patterns[i] = Pattern.compile(s + "\\w+\\b");
        }
        int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file, patterns);
        int patternEndOffset = last.getTextRange().getEndOffset();
        if (elements.size() == 0 || PatternCompiler.checkErrorElements((PsiElement)file, patternEndOffset, patternEndOffset, varEndOffsets, true) != Boolean.TRUE) {
            List<PsiElement> list = elements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
            }
            return list;
        }
        int varCount = varEndOffsets.length;
        String[] prefixSequence = new String[varCount];
        for (int i = 0; i < varCount; ++i) {
            prefixSequence[i] = applicablePrefixes[0];
        }
        List<PsiElement> finalElements = PatternCompiler.compileByPrefixes(project, options, pattern, context, applicablePrefixes, patterns, prefixSequence, 0);
        List<PsiElement> list = finalElements != null ? finalElements : PatternCompiler.doCompile(project, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "compileByAllPrefixes"));
        }
        return list;
    }

    @Nullable
    private static List<PsiElement> compileByPrefixes(Project project, MatchOptions options, CompiledPattern pattern, CompileContext context, String[] applicablePrefixes, Pattern[] substitutionPatterns, String[] prefixSequence, int index) {
        if (index >= prefixSequence.length) {
            List<PsiElement> elements = PatternCompiler.doCompile(project, options, pattern, new ArrayPrefixProvider(prefixSequence), context);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiElement parent = elements.get(0).getParent();
            PsiElement last = elements.get(elements.size() - 1);
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(parent.getContainingFile(), substitutionPatterns);
            int patternEndOffset = last.getTextRange().getEndOffset();
            return PatternCompiler.checkErrorElements(parent, patternEndOffset, patternEndOffset, varEndOffsets, false) != Boolean.TRUE ? elements : null;
        }
        String[] alternativeVariant = null;
        String[] arr$ = applicablePrefixes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            List<PsiElement> finalElements;
            int patternEndOffset;
            String applicablePrefix;
            prefixSequence[index] = applicablePrefix = arr$[i$];
            List<PsiElement> elements = PatternCompiler.doCompile(project, options, pattern, new ArrayPrefixProvider(prefixSequence), context);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiFile file = elements.get(0).getContainingFile();
            if (file == null) {
                return elements;
            }
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file, substitutionPatterns);
            int offset = varEndOffsets[index];
            Boolean result = PatternCompiler.checkErrorElements((PsiElement)file, offset, patternEndOffset = elements.get(elements.size() - 1).getTextRange().getEndOffset(), varEndOffsets, false);
            if (result == Boolean.TRUE || result != Boolean.FALSE && (result != null || alternativeVariant != null) || (finalElements = PatternCompiler.compileByPrefixes(project, options, pattern, context, applicablePrefixes, substitutionPatterns, prefixSequence, index + 1)) == null) continue;
            if (result == Boolean.FALSE) {
                return finalElements;
            }
            alternativeVariant = new String[prefixSequence.length];
            System.arraycopy(prefixSequence, 0, alternativeVariant, 0, prefixSequence.length);
        }
        return alternativeVariant != null ? PatternCompiler.compileByPrefixes(project, options, pattern, context, applicablePrefixes, substitutionPatterns, alternativeVariant, index + 1) : null;
    }

    @NotNull
    private static int[] findAllTypedVarOffsets(PsiFile file, final Pattern[] substitutionPatterns) {
        final TIntHashSet result = new TIntHashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof LeafElement) {
                    String text = element.getText();
                    for (Pattern pattern : substitutionPatterns) {
                        Matcher matcher = pattern.matcher(text);
                        while (matcher.find()) {
                            result.add(element.getTextRange().getStartOffset() + matcher.end());
                        }
                    }
                }
            }
        });
        int[] resultArray = result.toArray();
        Arrays.sort(resultArray);
        if (resultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler", "findAllTypedVarOffsets"));
        }
        return resultArray;
    }

    @Nullable
    private static Boolean checkErrorElements(PsiElement element, final int offset, final int patternEndOffset, int[] varEndOffsets, final boolean strict) {
        final TIntArrayList errorOffsets = new TIntArrayList();
        final boolean[] containsErrorTail = new boolean[]{false};
        final TIntHashSet varEndOffsetsSet = new TIntHashSet(varEndOffsets);
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                super.visitErrorElement(element);
                int startOffset = element.getTextRange().getStartOffset();
                if ((strict || !varEndOffsetsSet.contains(startOffset)) && startOffset != patternEndOffset) {
                    errorOffsets.add(startOffset);
                }
                if (startOffset == offset) {
                    containsErrorTail[0] = true;
                }
            }
        });
        for (int i = 0; i < errorOffsets.size(); ++i) {
            int errorOffset = errorOffsets.get(i);
            if (errorOffset > offset) continue;
            return true;
        }
        return containsErrorTail[0] ? null : Boolean.valueOf(false);
    }

    private static List<PsiElement> doCompile(Project project, MatchOptions options, CompiledPattern result, PrefixProvider prefixProvider, CompileContext context) {
        PsiElement[] matchStatements;
        result.clearHandlers();
        context.init(result, options, project, options.getScope() instanceof GlobalSearchScope);
        StringBuilder buf = new StringBuilder();
        Template template = TemplateManager.getInstance(project).createTemplate("", "", options.getSearchPattern());
        int segmentsCount = template.getSegmentsCount();
        String text = template.getTemplateText();
        buf.setLength(0);
        int prevOffset = 0;
        for (int i = 0; i < segmentsCount; ++i) {
            MatchPredicate predicate;
            int offset = template.getSegmentOffset(i);
            String name = template.getSegmentName(i);
            String prefix = prefixProvider.getPrefix(i);
            if (prefix == null) {
                throw new MalformedPatternException();
            }
            buf.append(text.substring(prevOffset, offset));
            buf.append(prefix);
            buf.append(name);
            MatchVariableConstraint constraint = options.getVariableConstraint(name);
            if (constraint == null) {
                constraint = new MatchVariableConstraint();
                constraint.setName(name);
                options.addVariableConstraint(constraint);
            }
            SubstitutionHandler handler = result.createSubstitutionHandler(name, prefix + name, constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
            if (constraint.isWithinHierarchy()) {
                handler.setSubtype(true);
            }
            if (constraint.isStrictlyWithinHierarchy()) {
                handler.setStrictSubtype(true);
            }
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getRegExp())) {
                predicate = new RegExpPredicate(constraint.getRegExp(), options.isCaseSensitiveMatch(), name, constraint.isWholeWordsOnly(), constraint.isPartOfSearchResults());
                if (constraint.isInvertRegExp()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler, predicate);
            }
            if (constraint.isReference()) {
                predicate = new ReferencePredicate(constraint.getNameOfReferenceVar());
                if (constraint.isInvertReference()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler, predicate);
            }
            LinkedHashSet<MatchPredicate> predicates = new LinkedHashSet<MatchPredicate>();
            for (MatchPredicateProvider matchPredicateProvider : (MatchPredicateProvider[])Extensions.getExtensions(MatchPredicateProvider.EP_NAME)) {
                matchPredicateProvider.collectPredicates(constraint, name, options, predicates);
            }
            for (MatchPredicate matchPredicate : predicates) {
                PatternCompiler.addPredicate(handler, matchPredicate);
            }
            PatternCompiler.addScriptConstraint(name, constraint, handler);
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getContainsConstraint())) {
                predicate = new ContainsPredicate(name, constraint.getContainsConstraint());
                if (constraint.isInvertContainsConstraint()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler, predicate);
            }
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) assert (false);
            prevOffset = offset;
        }
        MatchVariableConstraint constraint = options.getVariableConstraint("__context__");
        if (constraint != null) {
            SubstitutionHandler handler = result.createSubstitutionHandler("__context__", "__context__", constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
            if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) {
                MatchPredicate predicate = new WithinPredicate("__context__", constraint.getWithinConstraint(), project);
                if (constraint.isInvertWithinConstraint()) {
                    predicate = new NotPredicate(predicate);
                }
                PatternCompiler.addPredicate(handler, predicate);
            }
            PatternCompiler.addScriptConstraint("__context__", constraint, handler);
        }
        buf.append(text.substring(prevOffset, text.length()));
        try {
            matchStatements = MatcherImplUtil.createTreeFromText(buf.toString(), PatternTreeContext.Block, options.getFileType(), options.getDialect(), options.getPatternContext(), project, false);
            if (matchStatements.length == 0) {
                throw new MalformedPatternException();
            }
        }
        catch (IncorrectOperationException e) {
            throw new MalformedPatternException(e.getMessage());
        }
        NodeFilter filter = LexicalNodesFilter.getInstance();
        GlobalCompilingVisitor compilingVisitor = new GlobalCompilingVisitor();
        compilingVisitor.compile(matchStatements, context);
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (PsiElement matchStatement : matchStatements) {
            if (filter.accepts(matchStatement)) continue;
            elements.add(matchStatement);
        }
        new DeleteNodesAction(compilingVisitor.getLexicalNodes()).run();
        return elements;
    }

    private static void addScriptConstraint(String name, MatchVariableConstraint constraint, SubstitutionHandler handler) {
        if (constraint.getScriptCodeConstraint() != null && constraint.getScriptCodeConstraint().length() > 2) {
            String script = StringUtil.stripQuotesAroundValue((String)constraint.getScriptCodeConstraint());
            String s = ScriptSupport.checkValidScript(script);
            if (s != null) {
                throw new MalformedPatternException("Script constraint for " + constraint.getName() + " has problem " + s);
            }
            ScriptPredicate predicate = new ScriptPredicate(name, script);
            PatternCompiler.addPredicate(handler, predicate);
        }
    }

    static void addPredicate(SubstitutionHandler handler, MatchPredicate predicate) {
        if (handler.getPredicate() == null) {
            handler.setPredicate(predicate);
        } else {
            handler.setPredicate(new BinaryPredicate(handler.getPredicate(), predicate, false));
        }
    }

    private static class ArrayPrefixProvider
    implements PrefixProvider {
        private final String[] myPrefixes;

        private ArrayPrefixProvider(String[] prefixes) {
            this.myPrefixes = prefixes;
        }

        @Override
        public String getPrefix(int varIndex) {
            if (varIndex >= this.myPrefixes.length) {
                return null;
            }
            return this.myPrefixes[varIndex];
        }
    }

    private static class ConstantPrefixProvider
    implements PrefixProvider {
        private final String myPrefix;

        private ConstantPrefixProvider(String prefix) {
            this.myPrefix = prefix;
        }

        @Override
        public String getPrefix(int varIndex) {
            return this.myPrefix;
        }
    }

    private static interface PrefixProvider {
        public String getPrefix(int var1);
    }
}

