/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.StructuralReplaceAction;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.ui.HintHint;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    static Key<SubstitutionShortInfoHandler> LISTENER_KEY = Key.create((String)"sslistener.key");
    private static final String MODIFY_EDITOR_CONTENT = SSRBundle.message("modify.editor.content.command.name", new Object[0]);
    private static final TooltipGroup SS_INFO_TOOLTIP_GROUP = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
    @NonNls
    private static final String SS_GROUP = "structuralsearchgroup";

    @NotNull
    public static Editor createEditor(Document doc, Project project, boolean editable, @Nullable TemplateContextType contextType) {
        Editor editor = UIUtil.createEditor(doc, project, editable, false, contextType);
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/UIUtil", "createEditor"));
        }
        return editor;
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project, boolean editable, boolean addToolTipForVariableHandler, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/structuralsearch/plugin/ui/UIUtil", "createEditor"));
        }
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project) : EditorFactory.getInstance().createViewer(doc, project);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        EditorColorsScheme scheme = editor.getColorsScheme();
        scheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        if (!editable) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color c = globalScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (c == null) {
                c = globalScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(c);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter(editor, contextType);
        if (addToolTipForVariableHandler) {
            SubstitutionShortInfoHandler handler = new SubstitutionShortInfoHandler(editor);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)handler);
            editor.getDocument().addDocumentListener((DocumentListener)handler);
            editor.getCaretModel().addCaretListener((CaretListener)handler);
            editor.putUserData(LISTENER_KEY, (Object)handler);
        }
        Editor editor2 = editor;
        if (editor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/UIUtil", "createEditor"));
        }
        return editor2;
    }

    public static JComponent createOptionLine(JComponent[] options) {
        JPanel tmp = new JPanel();
        tmp.setLayout(new BoxLayout(tmp, 0));
        for (int i = 0; i < options.length; ++i) {
            if (i != 0) {
                tmp.add(Box.createHorizontalStrut(10));
            }
            tmp.add(options[i]);
        }
        tmp.add(Box.createHorizontalGlue());
        return tmp;
    }

    public static JComponent createOptionLine(JComponent option) {
        return UIUtil.createOptionLine(new JComponent[]{option});
    }

    public static void setContent(final Editor editor, String val, final int from, final int end, Project project) {
        final String value = val != null ? val : "";
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        editor.getDocument().replaceString(from, end == -1 ? editor.getDocument().getTextLength() : end, (CharSequence)value);
                    }
                });
            }
        }, MODIFY_EDITOR_CONTENT, (Object)SS_GROUP);
    }

    static String getShortParamString(Configuration config, String varname) {
        String script;
        ReplacementVariableDefinition replacementVariableDefinition;
        if (config == null) {
            return "";
        }
        MatchOptions options = config.getMatchOptions();
        MatchVariableConstraint constraint = options == null ? null : options.getVariableConstraint(varname);
        NamedScriptableDefinition namedScriptableDefinition = constraint;
        ReplacementVariableDefinition replacementVariableDefinition2 = replacementVariableDefinition = config instanceof ReplaceConfiguration ? ((ReplaceConfiguration)config).getOptions().getVariableDefinition(varname) : null;
        if (replacementVariableDefinition != null) {
            namedScriptableDefinition = replacementVariableDefinition;
        }
        if (constraint == null && replacementVariableDefinition == null) {
            return SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]);
        }
        StringBuilder buf = new StringBuilder();
        if (constraint != null) {
            if (constraint.isPartOfSearchResults()) {
                UIUtil.append(buf, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (constraint.getRegExp() != null && constraint.getRegExp().length() > 0) {
                UIUtil.append(buf, SSRBundle.message("text.tooltip.message", constraint.isInvertRegExp() ? SSRBundle.message("not.tooltip.message", new Object[0]) : "", constraint.getRegExp()));
            }
            if (constraint.isWithinHierarchy() || constraint.isStrictlyWithinHierarchy()) {
                UIUtil.append(buf, SSRBundle.message("within.hierarchy.tooltip.message", new Object[0]));
            }
            if (constraint.isReadAccess()) {
                UIUtil.append(buf, SSRBundle.message("value.read.tooltip.message", constraint.isInvertReadAccess() ? SSRBundle.message("not.tooltip.message", new Object[0]) : ""));
            }
            if (constraint.isWriteAccess()) {
                UIUtil.append(buf, SSRBundle.message("value.written.tooltip.message", constraint.isInvertWriteAccess() ? SSRBundle.message("not.tooltip.message", new Object[0]) : ""));
            }
            if (constraint.getNameOfExprType() != null && constraint.getNameOfExprType().length() > 0) {
                UIUtil.append(buf, SSRBundle.message("exprtype.tooltip.message", constraint.isInvertExprType() ? SSRBundle.message("not.tooltip.message", new Object[0]) : "", constraint.getNameOfExprType(), constraint.isExprTypeWithinHierarchy() ? SSRBundle.message("supertype.tooltip.message", new Object[0]) : ""));
            }
            if (constraint.getNameOfFormalArgType() != null && constraint.getNameOfFormalArgType().length() > 0) {
                UIUtil.append(buf, SSRBundle.message("expected.type.tooltip.message", constraint.isInvertFormalType() ? SSRBundle.message("not.tooltip.message", new Object[0]) : "", constraint.getNameOfFormalArgType(), constraint.isFormalArgTypeWithinHierarchy() ? SSRBundle.message("supertype.tooltip.message", new Object[0]) : ""));
            }
            if (constraint.getMinCount() == constraint.getMaxCount()) {
                UIUtil.append(buf, SSRBundle.message("occurs.tooltip.message", constraint.getMinCount()));
            } else {
                UIUtil.append(buf, SSRBundle.message("min.occurs.tooltip.message", constraint.getMinCount(), constraint.getMaxCount() == Integer.MAX_VALUE ? StringUtil.decapitalize((String)SSRBundle.message("editvarcontraints.unlimited", new Object[0])) : Integer.valueOf(constraint.getMaxCount())));
            }
        }
        if ((script = namedScriptableDefinition.getScriptCodeConstraint()) != null && script.length() > 2) {
            String str = SSRBundle.message("script.tooltip.message", StringUtil.stripQuotesAroundValue((String)script));
            UIUtil.append(buf, str);
        }
        return buf.toString();
    }

    private static void append(StringBuilder buf, String str) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(str);
    }

    public static void invokeAction(Configuration config, SearchContext context) {
        if (config instanceof SearchConfiguration) {
            StructuralSearchAction.triggerAction(config, context);
        } else {
            StructuralReplaceAction.triggerAction(config, context);
        }
    }

    static void showTooltip(@NotNull Editor editor, int start, int end, @NotNull String text) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/UIUtil", "showTooltip"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/plugin/ui/UIUtil", "showTooltip"));
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point left = editor.logicalPositionToXY(editor.offsetToLogicalPosition(start));
        int documentLength = editor.getDocument().getTextLength();
        if (end >= documentLength) {
            end = documentLength;
        }
        Point right = editor.logicalPositionToXY(editor.offsetToLogicalPosition(end));
        Point bestPoint = new Point(left.x + (right.x - left.x) / 2, right.y + editor.getLineHeight() / 2);
        if (visibleArea.x > bestPoint.x) {
            bestPoint.x = visibleArea.x;
        } else if (visibleArea.x + visibleArea.width < bestPoint.x) {
            bestPoint.x = visibleArea.x + visibleArea.width - 5;
        }
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), bestPoint, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hint = new HintHint(editor, bestPoint).setAwtTooltip(true).setHighlighterType(true).setCalloutShift(editor.getLineHeight() / 2 - 1);
        TooltipController.getInstance().showTooltip(editor, p, text, visibleArea.width, false, SS_INFO_TOOLTIP_GROUP, hint);
    }

    public static void updateHighlighter(Editor editor, StructuralSearchProfile profile) {
        TemplateEditorUtil.setHighlighter(editor, profile.getTemplateContextType());
    }
}

