/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.popup.MovablePopup;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExpandableItemsHandler<KeyType, ComponentType extends JComponent>
implements ExpandableItemsHandler<KeyType> {
    protected final ComponentType myComponent;
    private final Alarm myUpdateAlarm;
    private final CellRendererPane myRendererPane;
    private final JComponent myTipComponent;
    private boolean myEnabled;
    private final MovablePopup myPopup;
    private KeyType myKey;
    private Rectangle myKeyItemBounds;
    private BufferedImage myImage;

    protected AbstractExpandableItemsHandler(@NotNull ComponentType component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/AbstractExpandableItemsHandler", "<init>"));
        }
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myRendererPane = new CellRendererPane();
        this.myTipComponent = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                Insets insets = this.getInsets();
                UIUtil.drawImage((Graphics)g, (Image)AbstractExpandableItemsHandler.this.myImage, (int)insets.left, (int)insets.top, null);
            }
        };
        this.myEnabled = Registry.is((String)"ide.expansion.hints.enabled");
        this.myComponent = component;
        ((Container)this.myComponent).add(this.myRendererPane);
        ((Container)this.myComponent).validate();
        this.myPopup = new MovablePopup((Component)this.myComponent, this.myTipComponent);
        MouseAdapter tipMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (((Component)AbstractExpandableItemsHandler.this.myComponent).getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Point p = e.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(p, AbstractExpandableItemsHandler.this.myComponent);
                ((Component)AbstractExpandableItemsHandler.this.myComponent).dispatchEvent(new MouseWheelEvent((Component)AbstractExpandableItemsHandler.this.myComponent, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation()));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(p, AbstractExpandableItemsHandler.this.myComponent);
                ((Component)AbstractExpandableItemsHandler.this.myComponent).dispatchEvent(new MouseEvent((Component)AbstractExpandableItemsHandler.this.myComponent, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseClicked(e);
            }
        };
        this.myTipComponent.addMouseListener(tipMouseAdapter);
        this.myTipComponent.addMouseWheelListener(tipMouseAdapter);
        this.myTipComponent.addMouseMotionListener(tipMouseAdapter);
        ((Component)this.myComponent).addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (AbstractExpandableItemsHandler.this.myTipComponent.getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }
        });
        ((Component)this.myComponent).addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e, false);
            }
        });
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractExpandableItemsHandler.this.onFocusLost();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }
        });
    }

    protected void onFocusLost() {
        this.hideHint();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
        if (!this.myEnabled) {
            this.hideHint();
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public Collection<KeyType> getExpandedItems() {
        Collection<Object> collection = this.myKey == null ? Collections.emptyList() : Collections.singleton(this.myKey);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AbstractExpandableItemsHandler", "getExpandedItems"));
        }
        return collection;
    }

    protected void updateCurrentSelection() {
        this.handleSelectionChange(this.myKey, true);
    }

    private void handleMouseEvent(MouseEvent e) {
        this.handleMouseEvent(e, true);
    }

    protected void handleMouseEvent(MouseEvent e, boolean forceUpdate) {
        KeyType selected = this.getCellKeyForPoint(e.getPoint());
        if (forceUpdate || !Comparing.equal(this.myKey, selected)) {
            this.handleSelectionChange(selected, true);
        }
    }

    protected void handleSelectionChange(KeyType selected) {
        this.handleSelectionChange(selected, false);
    }

    protected void handleSelectionChange(final KeyType selected, final boolean processIfUnfocused) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        if (selected == null) {
            this.hideHint();
            return;
        }
        if (!selected.equals(this.myKey)) {
            this.hideHint();
        }
        this.myUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                AbstractExpandableItemsHandler.this.doHandleSelectionChange(selected, processIfUnfocused);
            }
        }, 10);
    }

    private void doHandleSelectionChange(@NotNull KeyType selected, boolean processIfUnfocused) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/ui/AbstractExpandableItemsHandler", "doHandleSelectionChange"));
        }
        if (!(this.myEnabled && ((Component)this.myComponent).isEnabled() && ((Component)this.myComponent).isShowing() && ((JComponent)this.myComponent).getVisibleRect().intersects(this.getVisibleRect(selected)) && (((Component)this.myComponent).isFocusOwner() || processIfUnfocused) && !this.isPopup())) {
            this.hideHint();
            return;
        }
        this.myKey = selected;
        Point location = this.createToolTipImage(this.myKey);
        if (location == null) {
            this.hideHint();
        } else {
            Dimension size = this.myTipComponent.getPreferredSize();
            this.myPopup.setBounds(location.x, location.y, size.width, size.height);
            this.myPopup.setHeavyWeight(this.hasOwnedWindows());
            if (!this.myPopup.isVisible()) {
                this.myPopup.setVisible(true);
            }
            this.repaintKeyItem();
        }
    }

    protected boolean isPopup() {
        Window window = SwingUtilities.getWindowAncestor(this.myComponent);
        return window != null && !(window instanceof Dialog) && !(window instanceof Frame) && !AbstractExpandableItemsHandler.isHintsAllowed(window);
    }

    private static boolean isHintsAllowed(Window window) {
        JRootPane pane;
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return Boolean.TRUE.equals(pane.getClientProperty("ShowHints"));
        }
        return false;
    }

    private boolean hasOwnedWindows() {
        Window owner = SwingUtilities.getWindowAncestor(this.myComponent);
        Window popup = SwingUtilities.getWindowAncestor(this.myTipComponent);
        for (Window other : owner.getOwnedWindows()) {
            if (popup == other || !other.isVisible()) continue;
            return false;
        }
        return true;
    }

    private void hideHint() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myPopup.isVisible()) {
            this.myPopup.setVisible(false);
            this.repaintKeyItem();
        }
        this.myKey = null;
    }

    public boolean isShowing() {
        return this.myPopup.isVisible();
    }

    private void repaintKeyItem() {
        if (this.myKeyItemBounds != null) {
            ((JComponent)this.myComponent).repaint(this.myKeyItemBounds);
        }
    }

    @Nullable
    private Point createToolTipImage(@NotNull KeyType key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ui/AbstractExpandableItemsHandler", "createToolTipImage"));
        }
        Pair<Component, Rectangle> rendererAndBounds = this.getCellRendererAndBounds(key);
        if (rendererAndBounds == null) {
            return null;
        }
        Component renderer = (Component)rendererAndBounds.first;
        if (!(renderer instanceof JComponent)) {
            return null;
        }
        Rectangle cellBounds = this.myKeyItemBounds = (Rectangle)rendererAndBounds.second;
        Rectangle visibleRect = this.getVisibleRect(key);
        if (cellBounds.y < visibleRect.y) {
            return null;
        }
        int cellMaxY = cellBounds.y + cellBounds.height;
        int visMaxY = visibleRect.y + visibleRect.height;
        if (cellMaxY > visMaxY) {
            return null;
        }
        int cellMaxX = cellBounds.x + cellBounds.width;
        int visMaxX = visibleRect.x + visibleRect.width;
        Point location = new Point(visMaxX, cellBounds.y);
        SwingUtilities.convertPointToScreen(location, this.myComponent);
        Rectangle screen = !Registry.is((String)"ide.expansion.hints.on.all.screens") ? ScreenUtil.getScreenRectangle((Point)location) : ScreenUtil.getAllScreensRectangle();
        int borderWidth = this.isPaintBorder() ? 1 : 0;
        int width = Math.min(screen.width + screen.x - location.x - borderWidth, cellMaxX - visMaxX);
        int height = cellBounds.height;
        if (width <= 0 || height <= 0) {
            return null;
        }
        Dimension size = this.getImageSize(width, height);
        this.myImage = UIUtil.createImage((int)size.width, (int)size.height, (int)1);
        Graphics2D g = this.myImage.createGraphics();
        g.setClip(null);
        this.doFillBackground(height, width, g);
        g.translate(cellBounds.x - visMaxX, 0);
        this.doPaintTooltipImage(renderer, cellBounds, g, key);
        CustomLineBorder border = null;
        if (borderWidth > 0) {
            border = new CustomLineBorder(this.getBorderColor(), borderWidth, 0, borderWidth, borderWidth);
            location.y -= borderWidth;
            size.width += borderWidth;
            size.height += borderWidth + borderWidth;
        }
        g.dispose();
        this.myRendererPane.remove(renderer);
        this.myTipComponent.setBorder((Border)border);
        this.myTipComponent.setPreferredSize(size);
        return location;
    }

    protected boolean isPaintBorder() {
        return true;
    }

    protected Color getBorderColor() {
        return JBColor.border();
    }

    protected Dimension getImageSize(int width, int height) {
        return new Dimension(width, height);
    }

    protected void doFillBackground(int height, int width, Graphics2D g) {
        g.setColor(((Component)this.myComponent).getBackground());
        g.fillRect(0, 0, width, height);
    }

    protected void doPaintTooltipImage(Component rComponent, Rectangle cellBounds, Graphics2D g, KeyType key) {
        this.myRendererPane.paintComponent(g, rComponent, (Container)this.myComponent, 0, 0, cellBounds.width, cellBounds.height, true);
    }

    protected Rectangle getVisibleRect(KeyType key) {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    @Nullable
    protected abstract Pair<Component, Rectangle> getCellRendererAndBounds(KeyType var1);

    protected abstract KeyType getCellKeyForPoint(Point var1);
}

